/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.EnvironmentInterface;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.gamerule.v1.rule.EnumRule;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1508;
import net.minecraft.class_1540;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4538;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5552;
import net.minecraft.class_746;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.MishangucClient;
import pers.solid.mishang.uc.MishangucRules;
import pers.solid.mishang.uc.item.BlockToolItem;
import pers.solid.mishang.uc.item.InteractsWithEntity;
import pers.solid.mishang.uc.item.MishangucItem;
import pers.solid.mishang.uc.mixin.WorldRendererInvoker;
import pers.solid.mishang.uc.render.RendersBeforeOutline;
import pers.solid.mishang.uc.util.BlockPlacementContext;
import pers.solid.mishang.uc.util.TextBridge;

@EnvironmentInterface(value=EnvType.CLIENT, itf=RendersBeforeOutline.class)
@ApiStatus.AvailableSince(value="0.2.4")
public class CarryingToolItem
extends BlockToolItem
implements MishangucItem,
InteractsWithEntity,
RendersBeforeOutline {
    public CarryingToolItem(class_1792.class_1793 settings, @Nullable Boolean includesFluid) {
        super(settings, includesFluid);
    }

    @Contract(pure=true)
    public static boolean hasHoldingBlockState(@NotNull class_1799 stack) {
        return stack.method_7941("holdingBlockState") != null;
    }

    @Contract(pure=true)
    public static boolean hasHoldingEntity(@NotNull class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10573("holdingEntityType", 8);
    }

    @Contract(pure=true)
    @Nullable
    public static class_2248 getHoldingBlock(@NotNull class_1799 stack) {
        class_2487 holdingBlockStateNbt = stack.method_7941("holdingBlockState");
        if (holdingBlockStateNbt == null) {
            return null;
        }
        class_2960 identifier = class_2960.method_12829((String)holdingBlockStateNbt.method_10558("Name"));
        return (class_2248)class_7923.field_41175.method_10223(identifier);
    }

    @Contract(pure=true)
    @Nullable
    public static class_2680 getHoldingBlockState(@NotNull class_1799 stack, class_4538 world) {
        class_2487 holdingBlockStateNbt = stack.method_7941("holdingBlockState");
        if (holdingBlockStateNbt != null) {
            try {
                return class_2512.method_10681((class_7871)world.method_45448(class_7924.field_41254), (class_2487)holdingBlockStateNbt);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Contract(mutates="param1")
    public static void setHoldingEntity(@NotNull class_1799 stack, @Nullable class_1297 entity) {
        if (entity == null) {
            stack.method_7983("holdingEntityType");
            stack.method_7983("EntityTag");
            stack.method_7983("holdingEntityName");
            stack.method_7983("holdingEntityWidth");
            stack.method_7983("holdingEntityHeight");
        } else {
            class_2487 entityTag = new class_2487();
            entity.method_5786(entityTag);
            class_2487 nbt = stack.method_7948();
            nbt.method_10566("EntityTag", (class_2520)entityTag);
            nbt.method_10582("holdingEntityType", class_7923.field_41177.method_10221((Object)entity.method_5864()).toString());
            nbt.method_10582("holdingEntityName", class_2561.class_2562.method_10867((class_2561)entity.method_5477()));
            nbt.method_10548("holdingEntityWidth", entity.method_17681());
            nbt.method_10548("holdingEntityHeight", entity.method_17682());
        }
    }

    @Contract(mutates="param1")
    private static void setHoldingEntityUUID(class_1799 stack, UUID uuid) {
        class_2487 entityTag = stack.method_7941("EntityTag");
        if (entityTag != null) {
            entityTag.method_25927("UUID", uuid);
        }
    }

    @Contract(mutates="param1")
    public static void setHoldingBlockState(@NotNull class_1799 stack, @Nullable class_2680 state) {
        if (state == null) {
            stack.method_7983("holdingBlockState");
        } else {
            stack.method_7959("holdingBlockState", (class_2520)class_2512.method_10686((class_2680)state));
        }
    }

    @Contract(pure=true)
    @Nullable
    public static class_1297 createHoldingEntity(@NotNull class_1799 stack, class_3218 world, class_1657 player) {
        class_2487 nbt = stack.method_7969();
        if (nbt != null) {
            String holdingEntityType = nbt.method_10558("holdingEntityType");
            class_2960 entityTypeId = class_2960.method_12829((String)holdingEntityType);
            if (entityTypeId == null || !class_7923.field_41177.method_10250(entityTypeId)) {
                return null;
            }
            class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(entityTypeId);
            return entityType.method_5888(world, nbt, null, player.method_24515(), class_3730.field_16467, false, false);
        }
        return null;
    }

    private static class_5250 getEntityName(@NotNull class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return TextBridge.empty();
        }
        if (nbt.method_10573("holdingEntityName", 8)) {
            return class_2561.class_2562.method_10877((String)nbt.method_10558("holdingEntityName"));
        }
        if (nbt.method_10573("holdingEntityType", 8)) {
            class_2960 holdingEntityType = class_2960.method_12829((String)nbt.method_10558("holdingEntityType"));
            return class_7923.field_41177.method_10250(holdingEntityType) ? ((class_1299)class_7923.field_41177.method_10223(holdingEntityType)).method_5897().method_27661() : TextBridge.literal(String.valueOf(holdingEntityType));
        }
        return TextBridge.empty();
    }

    public class_2561 method_7864(class_1799 stack) {
        class_2561 name = super.method_7864(stack);
        class_2248 holdingBlock = CarryingToolItem.getHoldingBlock(stack);
        if (CarryingToolItem.hasHoldingEntity(stack)) {
            return TextBridge.translatable("item.mishanguc.carrying_tool.holding", name, CarryingToolItem.getEntityName(stack));
        }
        if (holdingBlock == null) {
            return TextBridge.translatable("item.mishanguc.carrying_tool.empty", name);
        }
        return TextBridge.translatable("item.mishanguc.carrying_tool.holding", name, holdingBlock.method_9518());
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.tooltip.1").method_27692(class_124.field_1080));
        tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.tooltip.2").method_27692(class_124.field_1080));
        tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.tooltip.3").method_27692(class_124.field_1080));
        class_2248 holdingBlock = CarryingToolItem.getHoldingBlock(stack);
        if (holdingBlock != null) {
            tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.tooltip.currently", holdingBlock.method_9518().method_27692(class_124.field_1054)).method_27692(class_124.field_1060));
        } else if (CarryingToolItem.hasHoldingEntity(stack)) {
            tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.tooltip.currently", CarryingToolItem.getEntityName(stack).method_27692(class_124.field_1054)).method_27692(class_124.field_1060));
        }
    }

    @Override
    public class_1269 useOnBlock(class_1799 stack, class_1657 player, class_1937 world, class_3965 blockHitResult, class_1268 hand, boolean fluidIncluded) {
        if (!this.hasAccess(player, world, true)) {
            return class_1269.field_5811;
        }
        if (CarryingToolItem.hasHoldingBlockState(stack)) {
            BlockPlacementContext blockPlacementContext = new BlockPlacementContext(world, blockHitResult.method_17777(), player, stack, blockHitResult, fluidIncluded);
            if (blockPlacementContext.canPlace()) {
                blockPlacementContext.setBlockState(3);
                blockPlacementContext.setBlockEntity();
                if (world.field_9236) {
                    blockPlacementContext.playSound();
                } else {
                    player.method_7353((class_2561)TextBridge.translatable(player.method_7337() ? "item.mishanguc.carrying_tool.message.placed_creative" : "item.mishanguc.carrying_tool.message.placed", blockPlacementContext.stateToPlace.method_26204().method_9518()), true);
                }
                if (!player.method_7337()) {
                    CarryingToolItem.setHoldingBlockState(stack, null);
                    stack.method_7983("BlockEntityTag");
                }
                return class_1269.method_29236((boolean)world.field_9236);
            }
            return class_1269.field_5811;
        }
        if (CarryingToolItem.hasHoldingEntity(stack)) {
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                class_1297 entity = CarryingToolItem.createHoldingEntity(stack, serverWorld, player);
                if (entity == null) {
                    return class_1269.field_5811;
                }
                class_243 pos = blockHitResult.method_17784();
                entity.method_30634(pos.field_1352, pos.field_1351, pos.field_1350);
                boolean spawnEntity = world.method_8649(entity);
                if (spawnEntity) {
                    player.method_7353((class_2561)TextBridge.translatable(player.method_7337() ? "item.mishanguc.carrying_tool.message.spawned_creative" : "item.mishanguc.carrying_tool.message.spawned", CarryingToolItem.getEntityName(stack)), true);
                    if (!player.method_7337()) {
                        CarryingToolItem.setHoldingEntity(stack, null);
                    } else {
                        CarryingToolItem.setHoldingEntityUUID(stack, class_3532.method_15394());
                    }
                    return class_1269.field_5812;
                }
                return class_1269.field_5814;
            }
            return class_1269.field_5812;
        }
        class_2680 blockState = world.method_8320(blockHitResult.method_17777());
        class_1269 actionResult = blockState.method_26174(world, player, hand, blockHitResult);
        if (actionResult.method_23665()) {
            return actionResult;
        }
        if (world.field_9236) {
            return class_1269.field_5811;
        }
        player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.no_placing").method_27692(class_124.field_1061), true);
        return class_1269.field_5814;
    }

    private boolean hasAccess(class_1657 player, class_1937 world, boolean warn) {
        if (world.field_9236) {
            return MishangucClient.CLIENT_CARRYING_TOOL_ACCESS.get().hasAccess(player);
        }
        MishangucRules.ToolAccess toolAccess = (MishangucRules.ToolAccess)((EnumRule)world.method_8450().method_20746(MishangucRules.CARRYING_TOOL_ACCESS)).get();
        return toolAccess.hasAccess(player, warn);
    }

    @Override
    public class_1269 beginAttackBlock(class_1799 stack, class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction, boolean fluidIncluded) {
        if (!this.hasAccess(player, world, true)) {
            return class_1269.field_5811;
        }
        class_2248 alreadyHolding = CarryingToolItem.getHoldingBlock(stack);
        if (alreadyHolding != null && !player.method_7337()) {
            if (!world.field_9236) {
                player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.no_picking", Optional.ofNullable(CarryingToolItem.getHoldingBlock(stack)).map(class_2248::method_9518).orElse(TextBridge.empty())).method_27692(class_124.field_1061), true);
                return class_1269.field_5814;
            }
            return class_1269.field_21466;
        }
        boolean alreadyHoldingEntity = CarryingToolItem.hasHoldingEntity(stack);
        if (alreadyHoldingEntity && !player.method_7337()) {
            if (world.field_9236) {
                return class_1269.field_21466;
            }
            player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.no_picking", CarryingToolItem.getEntityName(stack)).method_27692(class_124.field_1061), true);
            return class_1269.field_5814;
        }
        class_2680 removed = world.method_8320(pos);
        if (removed.method_26204() instanceof class_5552 && !player.method_5687(2)) {
            return class_1269.field_5814;
        }
        CarryingToolItem.setHoldingBlockState(stack, removed);
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity != null) {
            blockEntity.method_38240(stack);
        } else {
            stack.method_7983("BlockEntityTag");
        }
        world.method_8544(pos);
        world.method_8501(pos, class_2246.field_10124.method_9564());
        if (world.field_9236) {
            world.method_20290(2001, pos, class_2248.method_9507((class_2680)removed));
        }
        if (!world.field_9236) {
            if (alreadyHolding == null) {
                player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.pick", removed.method_26204().method_9518()), true);
            } else if (alreadyHoldingEntity) {
                player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.pick_overriding", CarryingToolItem.getEntityName(stack)), true);
            } else {
                player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.picked_overriding", removed.method_26204().method_9518(), alreadyHolding.method_9518()), true);
            }
        }
        CarryingToolItem.setHoldingEntity(stack, null);
        return class_1269.field_5812;
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1271<class_1799> use = super.method_7836(world, user, hand);
        if (use.method_5467().method_23665() || !this.hasAccess(user, world, true)) {
            return use;
        }
        class_1799 stack = user.method_5998(hand);
        class_2680 holdingBlockState = CarryingToolItem.getHoldingBlockState(stack, (class_4538)world);
        if (holdingBlockState != null) {
            if (holdingBlockState.method_26204() instanceof class_5552 && !user.method_5687(2)) {
                return class_1271.method_22431((Object)stack);
            }
            if (world.field_9236) {
                return class_1271.method_22427((Object)((class_1799)use.method_5466()));
            }
            class_1540 fallingBlockEntity = new class_1540(class_1299.field_6089, world);
            class_2487 nbt = new class_2487();
            nbt.method_10566("BlockState", (class_2520)stack.method_7941("holdingBlockState"));
            fallingBlockEntity.method_5651(nbt);
            class_243 eyePos = user.method_33571();
            fallingBlockEntity.method_5641(eyePos.field_1352, eyePos.field_1351, eyePos.field_1350, user.method_36454(), user.method_36455());
            fallingBlockEntity.method_18799(class_243.method_1030((float)user.method_36455(), (float)user.method_36454()).method_1021(2.0).method_1019(user.method_18798()));
            fallingBlockEntity.field_7193 = true;
            fallingBlockEntity.field_7194 = stack.method_7941("BlockEntityTag");
            fallingBlockEntity.method_6965(holdingBlockState.method_26204().method_9520(), Integer.MAX_VALUE);
            boolean spawnEntity = world.method_8649((class_1297)fallingBlockEntity);
            if (spawnEntity) {
                if (!user.method_7337()) {
                    CarryingToolItem.setHoldingBlockState(stack, null);
                    stack.method_7983("BlockEntityTag");
                }
                user.method_7353((class_2561)TextBridge.translatable(user.method_7337() ? "item.mishanguc.carrying_tool.message.block_thrown_creative" : "item.mishanguc.carrying_tool.message.block_thrown", holdingBlockState.method_26204().method_9518()), true);
                return class_1271.method_22427((Object)((class_1799)use.method_5466()));
            }
            return class_1271.method_22431((Object)((class_1799)use.method_5466()));
        }
        if (CarryingToolItem.hasHoldingEntity(stack)) {
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                class_1297 entity = CarryingToolItem.createHoldingEntity(stack, serverWorld, user);
                if (entity == null) {
                    return use;
                }
                class_243 pos = user.method_19538();
                entity.method_5641(pos.field_1352, pos.field_1351, pos.field_1350, user.method_36454(), user.method_36455());
                entity.method_18799(class_243.method_1030((float)user.method_36455(), (float)user.method_36454()).method_1021(2.0).method_1019(user.method_18798()));
                boolean spawnEntity = world.method_8649(entity);
                if (spawnEntity) {
                    user.method_7353((class_2561)TextBridge.translatable(user.method_7337() ? "item.mishanguc.carrying_tool.message.entity_thrown_creative" : "item.mishanguc.carrying_tool.message.entity_thrown", CarryingToolItem.getEntityName(stack)), true);
                    if (!user.method_7337()) {
                        CarryingToolItem.setHoldingEntity(stack, null);
                    } else {
                        CarryingToolItem.setHoldingEntityUUID(stack, class_3532.method_15394());
                    }
                    return class_1271.method_22427((Object)((class_1799)use.method_5466()));
                }
                return class_1271.method_22431((Object)((class_1799)use.method_5466()));
            }
            return class_1271.method_22427((Object)((class_1799)use.method_5466()));
        }
        return use;
    }

    @Override
    @NotNull
    public class_1269 attackEntityCallback(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 hitResult) {
        if (!this.hasAccess(player, world, true) || player.method_7325()) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        if (entity instanceof class_1657) {
            if (world.field_9236) {
                return class_1269.field_5811;
            }
            player.method_43496((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.pick_player").method_27692(class_124.field_1061));
            return class_1269.field_5814;
        }
        if (CarryingToolItem.hasHoldingEntity(stack) && !player.method_7337()) {
            if (world.field_9236) {
                return class_1269.field_5812;
            }
            player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.no_picking", CarryingToolItem.getEntityName(stack)).method_27692(class_124.field_1061), true);
            return class_1269.field_5814;
        }
        if (CarryingToolItem.hasHoldingBlockState(stack) && !player.method_7337()) {
            if (world.field_9236) {
                return class_1269.field_5812;
            }
            player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.no_picking", Optional.ofNullable(CarryingToolItem.getHoldingBlock(stack)).map(class_2248::method_9518).orElse(TextBridge.empty())).method_27692(class_124.field_1061), true);
            return class_1269.field_5814;
        }
        if (!world.field_9236) {
            if (CarryingToolItem.hasHoldingEntity(stack)) {
                player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.pick_entity_overriding", entity.method_5477(), CarryingToolItem.getEntityName(stack)), true);
            } else if (CarryingToolItem.hasHoldingBlockState(stack)) {
                player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.pick_entity_overriding", entity.method_5477(), Objects.requireNonNull(CarryingToolItem.getHoldingBlock(stack)).method_9518()), true);
            } else {
                player.method_7353((class_2561)TextBridge.translatable("item.mishanguc.carrying_tool.message.pick_entity", entity.method_5477()), true);
            }
            CarryingToolItem.setHoldingBlockState(stack, null);
            CarryingToolItem.setHoldingEntity(stack, entity);
            entity.method_5650(class_1297.class_5529.field_26999);
            if (entity instanceof class_1508) {
                class_1508 enderDragonPart = (class_1508)entity;
                enderDragonPart.field_7007.method_5768();
            }
        }
        return class_1269.field_5812;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlockOutline(class_1657 player, class_1799 itemStack, WorldRenderContext worldRenderContext, WorldRenderContext.BlockOutlineContext blockOutlineContext, class_1268 hand) {
        BlockPlacementContext blockPlacementContext;
        if (!this.hasAccess(player, (class_1937)worldRenderContext.world(), true)) {
            return true;
        }
        class_310 client = class_310.method_1551();
        class_4597 consumers = worldRenderContext.consumers();
        if (consumers == null) {
            return true;
        }
        class_4588 vertexConsumer = consumers.getBuffer((class_1921)class_1921.field_21695);
        class_4587 matrices = worldRenderContext.matrixStack();
        class_239 crosshairTarget = client.field_1765;
        if (!(crosshairTarget instanceof class_3965)) {
            return true;
        }
        class_3965 blockHitResult = (class_3965)crosshairTarget;
        boolean includesFluid = this.includesFluid(itemStack, player.method_5715());
        class_2338 pos = blockOutlineContext.blockPos();
        if (CarryingToolItem.hasHoldingBlockState(itemStack) && (blockPlacementContext = new BlockPlacementContext((class_1937)worldRenderContext.world(), pos, player, itemStack, blockHitResult, includesFluid)).canPlace()) {
            WorldRendererInvoker.drawCuboidShapeOutline(matrices, vertexConsumer, blockPlacementContext.stateToPlace.method_26172((class_1922)blockPlacementContext.world, blockPlacementContext.posToPlace, class_3726.method_16195((class_1297)player)), (double)blockPlacementContext.posToPlace.method_10263() - blockOutlineContext.cameraX(), (double)blockPlacementContext.posToPlace.method_10264() - blockOutlineContext.cameraY(), (double)blockPlacementContext.posToPlace.method_10260() - blockOutlineContext.cameraZ(), 0.0f, 1.0f, 1.0f, 0.8f);
            WorldRendererInvoker.drawCuboidShapeOutline(matrices, vertexConsumer, blockPlacementContext.stateToPlace.method_26227().method_17776((class_1922)blockPlacementContext.world, blockPlacementContext.posToPlace), (double)blockPlacementContext.posToPlace.method_10263() - blockOutlineContext.cameraX(), (double)blockPlacementContext.posToPlace.method_10264() - blockOutlineContext.cameraY(), (double)blockPlacementContext.posToPlace.method_10260() - blockOutlineContext.cameraZ(), 0.0f, 0.5f, 1.0f, 0.5f);
        }
        if (hand == class_1268.field_5808 && (!CarryingToolItem.hasHoldingBlockState(itemStack) && !CarryingToolItem.hasHoldingEntity(itemStack) || player.method_7337())) {
            class_2680 hitState = worldRenderContext.world().method_8320(pos);
            WorldRendererInvoker.drawCuboidShapeOutline(matrices, vertexConsumer, hitState.method_26172((class_1922)worldRenderContext.world(), pos, class_3726.method_16195((class_1297)player)), (double)pos.method_10263() - blockOutlineContext.cameraX(), (double)pos.method_10264() - blockOutlineContext.cameraY(), (double)pos.method_10260() - blockOutlineContext.cameraZ(), 1.0f, 0.0f, 0.0f, 0.8f);
            WorldRendererInvoker.drawCuboidShapeOutline(matrices, vertexConsumer, hitState.method_26227().method_17776((class_1922)worldRenderContext.world(), pos), (double)pos.method_10263() - blockOutlineContext.cameraX(), (double)pos.method_10264() - blockOutlineContext.cameraY(), (double)pos.method_10260() - blockOutlineContext.cameraZ(), 1.0f, 0.5f, 0.0f, 0.5f);
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBeforeOutline(WorldRenderContext context, class_239 hitResult, class_746 player, class_1268 hand) {
        if (hand != class_1268.field_5808 || player.method_7325() || !this.hasAccess((class_1657)player, (class_1937)context.world(), true)) {
            return;
        }
        class_1799 stack = player.method_6047();
        class_2487 nbt = stack.method_7969();
        class_4597 consumers = context.consumers();
        class_4587 matrices = context.matrixStack();
        if (consumers == null) {
            return;
        }
        class_4588 vertexConsumer = consumers.getBuffer(class_1921.method_23594());
        class_243 cameraPos = context.camera().method_19326();
        if (hitResult.method_17783() == class_239.class_240.field_1332 && CarryingToolItem.hasHoldingEntity(stack) && nbt != null) {
            float width = nbt.method_10583("holdingEntityWidth");
            float height = nbt.method_10583("holdingEntityHeight");
            class_243 pos = hitResult.method_17784();
            WorldRendererInvoker.drawCuboidShapeOutline(matrices, vertexConsumer, class_259.method_1081((double)(pos.field_1352 - (double)(width / 2.0f)), (double)pos.field_1351, (double)(pos.field_1350 - (double)(width / 2.0f)), (double)(pos.field_1352 + (double)(width / 2.0f)), (double)(pos.field_1351 + (double)height), (double)(pos.field_1350 + (double)(width / 2.0f))), -cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350, 0.0f, 1.0f, 1.0f, 0.8f);
        }
        if (!player.method_7337() && (CarryingToolItem.hasHoldingBlockState(stack) || CarryingToolItem.hasHoldingEntity(stack))) {
            return;
        }
        if (hitResult instanceof class_3966) {
            class_3966 entityHitResult = (class_3966)hitResult;
            class_1297 entity = entityHitResult.method_17782();
            WorldRendererInvoker.drawCuboidShapeOutline(matrices, vertexConsumer, class_259.method_1078((class_238)entity.method_5829()), -cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350, 1.0f, 0.0f, 0.0f, 0.8f);
        }
    }
}

