/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.item;

import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3513;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5552;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.item.BlockToolItem;
import pers.solid.mishang.uc.item.HotbarScrollInteraction;
import pers.solid.mishang.uc.mixin.WorldRendererInvoker;
import pers.solid.mishang.uc.util.BlockMatchingRule;
import pers.solid.mishang.uc.util.BlockPlacementContext;
import pers.solid.mishang.uc.util.TextBridge;

public class FastBuildingToolItem
extends BlockToolItem
implements HotbarScrollInteraction {
    private static final class_3513<BlockMatchingRule> RULES_TO_CYCLE = (class_3513)class_156.method_654((Object)class_3513.method_37913((int)4), map -> {
        map.method_15225((Object)BlockMatchingRule.SAME_STATE);
        map.method_15225((Object)BlockMatchingRule.SAME_BLOCK);
        map.method_15225((Object)BlockMatchingRule.SAME_MATERIAL);
        map.method_15225((Object)BlockMatchingRule.ANY);
    });

    public FastBuildingToolItem(class_1792.class_1793 settings, @Nullable Boolean includesFluid) {
        super(settings, includesFluid);
    }

    @Override
    public class_1269 useOnBlock(class_1799 stack, class_1657 player, class_1937 world, class_3965 blockHitResult, class_1268 hand, boolean fluidIncluded) {
        if (!player.method_7337()) {
            return class_1269.field_5811;
        }
        class_2350 side = blockHitResult.method_17780();
        class_2338 centerBlockPos = blockHitResult.method_17777();
        class_2680 centerState = world.method_8320(centerBlockPos);
        BlockPlacementContext blockPlacementContext = new BlockPlacementContext(world, centerBlockPos, player, stack, blockHitResult, fluidIncluded);
        int range = this.getRange(stack);
        BlockMatchingRule matchingRule = this.getMatchingRule(stack);
        boolean soundPlayed = false;
        for (class_2338 pos : matchingRule.getPlainValidBlockPoss(world, centerBlockPos, side, range)) {
            BlockPlacementContext offsetBlockPlacementContext;
            class_2680 state = world.method_8320(pos);
            if (!matchingRule.match(centerState, state) || !(offsetBlockPlacementContext = new BlockPlacementContext(blockPlacementContext, pos)).canPlace() || !offsetBlockPlacementContext.canReplace()) continue;
            if (!world.field_9236) {
                offsetBlockPlacementContext.setBlockState(11);
                offsetBlockPlacementContext.setBlockEntity();
            }
            if (!soundPlayed) {
                offsetBlockPlacementContext.playSound();
            }
            soundPlayed = true;
        }
        return class_1269.field_5812;
    }

    @Override
    public class_1269 beginAttackBlock(class_1799 stack, class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction, boolean fluidIncluded) {
        if (!player.method_7337()) {
            return class_1269.field_5811;
        }
        if (!world.method_8608()) {
            int range = this.getRange(stack);
            BlockMatchingRule matchingRule = this.getMatchingRule(stack);
            for (class_2338 pos1 : matchingRule.getPlainValidBlockPoss(world, pos, direction, range)) {
                if (world.method_8320(pos1).method_26204() instanceof class_5552 && !player.method_5687(2)) continue;
                if (fluidIncluded) {
                    world.method_8501(pos1, class_2246.field_10124.method_9564());
                    continue;
                }
                world.method_8650(pos1, false);
            }
        }
        world.method_8444(player, 2001, pos, class_2248.method_9507((class_2680)world.method_8320(pos)));
        return class_1269.field_5812;
    }

    public class_1799 method_7854() {
        class_1799 stack = super.method_7854();
        class_2487 tag = stack.method_7948();
        tag.method_10569("Range", 5);
        tag.method_10582("MatchingRule", "mishanguc:same_block");
        return stack;
    }

    public int getRange(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        return nbt.method_10573("Range", 99) ? Integer.min(nbt.method_10550("Range"), 128) : 8;
    }

    @NotNull
    public BlockMatchingRule getMatchingRule(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        BlockMatchingRule matchingRule = BlockMatchingRule.fromString(tag.method_10558("MatchingRule"));
        return matchingRule == null ? BlockMatchingRule.SAME_BLOCK : matchingRule;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.fast_building_tool.tooltip.1").method_27692(class_124.field_1080));
        tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.fast_building_tool.tooltip.2").method_27692(class_124.field_1080));
        tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.fast_building_tool.tooltip.range", TextBridge.literal(Integer.toString(this.getRange(stack))).method_27692(class_124.field_1054)).method_27692(class_124.field_1080));
        tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.fast_building_tool.tooltip.matchingRule", this.getMatchingRule(stack).getName().method_27692(class_124.field_1054)).method_27692(class_124.field_1080));
    }

    protected class_1799 createStack(int range, BlockMatchingRule blockMatchingRule) {
        class_1799 stack = new class_1799((class_1935)this);
        class_2487 nbt = stack.method_7948();
        nbt.method_10569("Range", range);
        nbt.method_10582("MatchingRule", blockMatchingRule.method_15434());
        return stack;
    }

    public void appendToEntries(class_1761.class_7704 stacks) {
        stacks.method_45420(this.createStack(1, BlockMatchingRule.SAME_BLOCK));
        stacks.method_45420(this.createStack(16, BlockMatchingRule.SAME_BLOCK));
        stacks.method_45420(this.createStack(32, BlockMatchingRule.SAME_BLOCK));
        stacks.method_45420(this.createStack(64, BlockMatchingRule.SAME_BLOCK));
    }

    public class_2561 method_7864(class_1799 stack) {
        return TextBridge.translatable("item.mishanguc.fast_building_tool.format", this.method_7848(), Integer.toString(this.getRange(stack)), this.getMatchingRule(stack).getName());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlockOutline(class_1657 player, class_1799 itemStack, WorldRenderContext worldRenderContext, WorldRenderContext.BlockOutlineContext blockOutlineContext, class_1268 hand) {
        class_3965 blockHitResult;
        class_310 client = class_310.method_1551();
        if (!player.method_7337()) {
            return true;
        }
        if (hand == class_1268.field_5810 && player.method_6047().method_7909() instanceof class_1747) {
            return true;
        }
        class_4597 consumers = worldRenderContext.consumers();
        if (consumers == null) {
            return true;
        }
        class_4588 vertexConsumer = consumers.getBuffer((class_1921)class_1921.field_21695);
        boolean includesFluid = this.includesFluid(itemStack, player.method_5715());
        BlockMatchingRule matchingRule = this.getMatchingRule(itemStack);
        int range = this.getRange(itemStack);
        class_239 class_2392 = client.field_1765;
        if (!(class_2392 instanceof class_3965) || (blockHitResult = (class_3965)class_2392).method_17783() != class_239.class_240.field_1332) {
            return true;
        }
        class_3965 raycast = blockHitResult;
        class_638 world = worldRenderContext.world();
        BlockPlacementContext blockPlacementContext = new BlockPlacementContext((class_1937)world, blockOutlineContext.blockPos(), player, itemStack, raycast, includesFluid);
        for (class_2338 pos : matchingRule.getPlainValidBlockPoss((class_1937)world, raycast.method_17777(), raycast.method_17780(), range)) {
            class_2680 state = world.method_8320(pos);
            BlockPlacementContext offsetBlockPlacementContext = new BlockPlacementContext(blockPlacementContext, pos);
            if (offsetBlockPlacementContext.canPlace() && offsetBlockPlacementContext.canReplace()) {
                WorldRendererInvoker.drawCuboidShapeOutline(worldRenderContext.matrixStack(), vertexConsumer, offsetBlockPlacementContext.stateToPlace.method_26172((class_1922)world, pos, class_3726.method_16195((class_1297)player)), (double)offsetBlockPlacementContext.posToPlace.method_10263() - blockOutlineContext.cameraX(), (double)offsetBlockPlacementContext.posToPlace.method_10264() - blockOutlineContext.cameraY(), (double)offsetBlockPlacementContext.posToPlace.method_10260() - blockOutlineContext.cameraZ(), 0.0f, 1.0f, 1.0f, 0.8f);
                if (includesFluid) {
                    WorldRendererInvoker.drawCuboidShapeOutline(worldRenderContext.matrixStack(), vertexConsumer, offsetBlockPlacementContext.stateToPlace.method_26227().method_17776((class_1922)world, pos), (double)offsetBlockPlacementContext.posToPlace.method_10263() - blockOutlineContext.cameraX(), (double)offsetBlockPlacementContext.posToPlace.method_10264() - blockOutlineContext.cameraY(), (double)offsetBlockPlacementContext.posToPlace.method_10260() - blockOutlineContext.cameraZ(), 0.0f, 0.5f, 1.0f, 0.5f);
                }
            }
            if (hand != class_1268.field_5808 || state.method_26204() instanceof class_5552 && !player.method_5687(2)) continue;
            WorldRendererInvoker.drawCuboidShapeOutline(worldRenderContext.matrixStack(), vertexConsumer, state.method_26172((class_1922)world, pos, class_3726.method_16195((class_1297)player)), (double)pos.method_10263() - blockOutlineContext.cameraX(), (double)pos.method_10264() - blockOutlineContext.cameraY(), (double)pos.method_10260() - blockOutlineContext.cameraZ(), 1.0f, 0.0f, 0.0f, 0.8f);
            if (!includesFluid) continue;
            WorldRendererInvoker.drawCuboidShapeOutline(worldRenderContext.matrixStack(), vertexConsumer, state.method_26227().method_17776((class_1922)world, pos), (double)pos.method_10263() - blockOutlineContext.cameraX(), (double)pos.method_10264() - blockOutlineContext.cameraY(), (double)pos.method_10260() - blockOutlineContext.cameraZ(), 1.0f, 0.5f, 0.0f, 0.5f);
        }
        return false;
    }

    @Override
    public void onScroll(int selectedSlot, double scrollAmount, class_3222 player, class_1799 stack) {
        BlockMatchingRule currentRule = this.getMatchingRule(stack);
        int i = RULES_TO_CYCLE.method_10206((Object)currentRule);
        if (i == -1) {
            return;
        }
        int j = (int)class_3532.method_15367((double)((double)i - scrollAmount), (double)RULES_TO_CYCLE.method_10204());
        BlockMatchingRule newRule = (BlockMatchingRule)RULES_TO_CYCLE.method_10200(j);
        if (newRule != null) {
            stack.method_7959("MatchingRule", (class_2520)class_2519.method_23256((String)newRule.getId().toString()));
            class_5250 text = TextBridge.literal("[ ");
            Iterator iterator = RULES_TO_CYCLE.iterator();
            while (iterator.hasNext()) {
                BlockMatchingRule rule = (BlockMatchingRule)iterator.next();
                class_5250 name = rule.getName();
                if (rule == newRule) {
                    name.method_27695(new class_124[]{class_124.field_1054, class_124.field_1073});
                }
                text.method_10852((class_2561)name);
                if (!iterator.hasNext()) continue;
                text.method_27693(" | ");
            }
            text.method_27693(" ]");
            player.method_7353((class_2561)text, true);
        }
    }
}

