/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.item;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.EnvironmentInterface;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.gamerule.v1.rule.EnumRule;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1508;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.MishangucClient;
import pers.solid.mishang.uc.MishangucRules;
import pers.solid.mishang.uc.item.BlockToolItem;
import pers.solid.mishang.uc.item.CarryingToolItem;
import pers.solid.mishang.uc.item.InteractsWithEntity;
import pers.solid.mishang.uc.mixin.WorldRendererInvoker;
import pers.solid.mishang.uc.render.RendersBeforeOutline;
import pers.solid.mishang.uc.util.BlockPlacementContext;
import pers.solid.mishang.uc.util.TextBridge;

@EnvironmentInterface(value=EnvType.CLIENT, itf=RendersBeforeOutline.class)
public class ForcePlacingToolItem
extends BlockToolItem
implements InteractsWithEntity,
RendersBeforeOutline {
    public static boolean suppressOnBlockAdded = false;

    public ForcePlacingToolItem(class_1792.class_1793 settings, @Nullable Boolean includesFluid) {
        super(settings, includesFluid);
    }

    @Override
    public class_1269 useOnBlock(class_1799 stack, class_1657 player, class_1937 world, class_3965 blockHitResult, class_1268 hand, boolean fluidIncluded) {
        if (!ForcePlacingToolItem.hasAccess(player, world, true)) {
            return class_1269.field_5811;
        }
        BlockPlacementContext blockPlacementContext = new BlockPlacementContext(world, blockHitResult.method_17777(), player, player.method_5998(hand), blockHitResult, fluidIncluded);
        blockPlacementContext.playSound();
        int flags = ForcePlacingToolItem.getFlags(stack);
        suppressOnBlockAdded = true;
        blockPlacementContext.setBlockState(flags);
        suppressOnBlockAdded = false;
        blockPlacementContext.setBlockEntity();
        return class_1269.method_29236((boolean)world.field_9236);
    }

    @Override
    public class_1269 beginAttackBlock(class_1799 stack, class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction, boolean fluidIncluded) {
        if (!ForcePlacingToolItem.hasAccess(player, world, true)) {
            return class_1269.field_5811;
        }
        class_2680 blockState = world.method_8320(pos);
        world.method_8444(player, 2001, pos, class_2248.method_9507((class_2680)world.method_8320(pos)));
        class_3610 fluidState = blockState.method_26227();
        world.method_8544(pos);
        int flags = ForcePlacingToolItem.getFlags(stack);
        world.method_8652(pos, fluidIncluded ? class_2246.field_10124.method_9564() : fluidState.method_15759(), flags);
        return class_1269.method_29236((boolean)world.field_9236);
    }

    private static int getFlags(class_1799 stack) {
        return 26;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.force_placing_tool.tooltip.1").method_27692(class_124.field_1080));
        tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.force_placing_tool.tooltip.2").method_27692(class_124.field_1080));
        if (Boolean.TRUE.equals(this.includesFluid(stack))) {
            tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.force_placing_tool.tooltip.fluids").method_27692(class_124.field_1080));
        }
        tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.force_placing_tool.tooltip.3").method_27692(class_124.field_1080));
        if ((ForcePlacingToolItem.getFlags(stack) & 0x80) != 0) {
            tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.force_placing_tool.tooltip.suspends_light").method_27692(class_124.field_1054));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlockOutline(class_1657 player, class_1799 itemStack, WorldRenderContext worldRenderContext, WorldRenderContext.BlockOutlineContext blockOutlineContext, class_1268 hand) {
        class_310 client = class_310.method_1551();
        if (!ForcePlacingToolItem.hasAccess(player, (class_1937)worldRenderContext.world(), false)) {
            return true;
        }
        class_1792 item = player.method_6047().method_7909();
        if (hand == class_1268.field_5810 && (item instanceof class_1747 || item instanceof CarryingToolItem)) {
            return true;
        }
        class_4597 consumers = worldRenderContext.consumers();
        if (consumers == null) {
            return true;
        }
        class_4588 vertexConsumer = consumers.getBuffer((class_1921)class_1921.field_21695);
        class_4587 matrices = worldRenderContext.matrixStack();
        class_239 crosshairTarget = client.field_1765;
        if (!(crosshairTarget instanceof class_3965)) {
            return true;
        }
        class_3965 blockHitResult = (class_3965)crosshairTarget;
        boolean includesFluid = this.includesFluid(itemStack, player.method_5715());
        BlockPlacementContext blockPlacementContext = new BlockPlacementContext((class_1937)worldRenderContext.world(), blockOutlineContext.blockPos(), player, itemStack, blockHitResult, includesFluid);
        WorldRendererInvoker.drawCuboidShapeOutline(matrices, vertexConsumer, blockPlacementContext.stateToPlace.method_26172((class_1922)blockPlacementContext.world, blockPlacementContext.posToPlace, class_3726.method_16195((class_1297)player)), (double)blockPlacementContext.posToPlace.method_10263() - blockOutlineContext.cameraX(), (double)blockPlacementContext.posToPlace.method_10264() - blockOutlineContext.cameraY(), (double)blockPlacementContext.posToPlace.method_10260() - blockOutlineContext.cameraZ(), 0.0f, 1.0f, 1.0f, 0.8f);
        if (includesFluid) {
            WorldRendererInvoker.drawCuboidShapeOutline(matrices, vertexConsumer, blockPlacementContext.stateToPlace.method_26227().method_17776((class_1922)blockPlacementContext.world, blockPlacementContext.posToPlace), (double)blockPlacementContext.posToPlace.method_10263() - blockOutlineContext.cameraX(), (double)blockPlacementContext.posToPlace.method_10264() - blockOutlineContext.cameraY(), (double)blockPlacementContext.posToPlace.method_10260() - blockOutlineContext.cameraZ(), 0.0f, 0.5f, 1.0f, 0.5f);
        }
        if (hand == class_1268.field_5808) {
            WorldRendererInvoker.drawCuboidShapeOutline(matrices, vertexConsumer, blockPlacementContext.hitState.method_26172((class_1922)blockPlacementContext.world, blockPlacementContext.blockPos, class_3726.method_16195((class_1297)player)), (double)blockPlacementContext.blockPos.method_10263() - blockOutlineContext.cameraX(), (double)blockPlacementContext.blockPos.method_10264() - blockOutlineContext.cameraY(), (double)blockPlacementContext.blockPos.method_10260() - blockOutlineContext.cameraZ(), 1.0f, 0.0f, 0.0f, 0.8f);
            if (includesFluid) {
                WorldRendererInvoker.drawCuboidShapeOutline(matrices, vertexConsumer, blockPlacementContext.hitState.method_26227().method_17776((class_1922)blockPlacementContext.world, blockPlacementContext.blockPos), (double)blockPlacementContext.blockPos.method_10263() - blockOutlineContext.cameraX(), (double)blockPlacementContext.blockPos.method_10264() - blockOutlineContext.cameraY(), (double)blockPlacementContext.blockPos.method_10260() - blockOutlineContext.cameraZ(), 1.0f, 0.5f, 0.0f, 0.5f);
            }
        }
        return false;
    }

    @Override
    @NotNull
    public class_1269 attackEntityCallback(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 hitResult) {
        if (!ForcePlacingToolItem.hasAccess(player, world, true)) {
            return class_1269.field_5811;
        }
        if (!world.field_9236) {
            if (entity instanceof class_1657) {
                entity.method_5768();
            } else {
                entity.method_5650(class_1297.class_5529.field_26998);
            }
            if (entity instanceof class_1508) {
                class_1508 enderDragonPart = (class_1508)entity;
                enderDragonPart.field_7007.method_5768();
            }
        }
        return class_1269.field_5812;
    }

    @ApiStatus.AvailableSince(value="1.0.0")
    private static boolean hasAccess(class_1657 player, class_1937 world, boolean warn) {
        if (world.field_9236) {
            return MishangucClient.CLIENT_FORCE_PLACING_TOOL_ACCESS.get().hasAccess(player);
        }
        MishangucRules.ToolAccess toolAccess = (MishangucRules.ToolAccess)((EnumRule)world.method_8450().method_20746(MishangucRules.FORCE_PLACING_TOOL_ACCESS)).get();
        return toolAccess.hasAccess(player, warn);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBeforeOutline(WorldRenderContext context, class_239 hitResult, class_746 player, class_1268 hand) {
        if (hand != class_1268.field_5808 || !ForcePlacingToolItem.hasAccess((class_1657)player, (class_1937)context.world(), false)) {
            return;
        }
        class_4587 matrices = context.matrixStack();
        class_4597 consumers = context.consumers();
        if (consumers == null) {
            return;
        }
        class_4588 vertexConsumer = consumers.getBuffer(class_1921.method_23594());
        class_243 cameraPos = context.camera().method_19326();
        if (hitResult instanceof class_3966) {
            class_3966 entityHitResult = (class_3966)hitResult;
            class_1297 entity = entityHitResult.method_17782();
            WorldRendererInvoker.drawCuboidShapeOutline(matrices, vertexConsumer, class_259.method_1078((class_238)entity.method_5829()), -cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350, 1.0f, 0.0f, 0.0f, 0.8f);
        }
    }
}

