/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.item;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.EnvironmentInterface;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_184;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4597;
import net.minecraft.class_5793;
import net.minecraft.class_5794;
import net.minecraft.class_5797;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.Mishanguc;
import pers.solid.mishang.uc.block.AbstractRoadBlock;
import pers.solid.mishang.uc.blocks.RoadSlabBlocks;
import pers.solid.mishang.uc.item.MishangucItem;
import pers.solid.mishang.uc.mixin.WorldRendererInvoker;
import pers.solid.mishang.uc.render.RendersBlockOutline;
import pers.solid.mishang.uc.util.TextBridge;

@EnvironmentInterface(value=EnvType.CLIENT, itf=RendersBlockOutline.class)
public class SlabToolItem
extends class_1792
implements RendersBlockOutline,
MishangucItem {
    @ApiStatus.AvailableSince(value="0.1.3")
    protected static final BiMap<class_2248, class_2248> BLOCK_TO_SLAB = (BiMap)class_5793.method_33467().filter(blockFamily -> blockFamily.method_33470(class_5794.class_5796.field_28539) != null).map(blockFamily -> {
        class_2248 variant = blockFamily.method_33470(class_5794.class_5796.field_28539);
        class_2248 baseBlock = blockFamily.method_33469();
        return baseBlock == null || variant == null ? null : Maps.immutableEntry((Object)baseBlock, (Object)variant);
    }).filter(Objects::nonNull).collect(ImmutableBiMap.toImmutableBiMap(Map.Entry::getKey, Map.Entry::getValue));
    private static final Map<Pair<class_3218, class_2338>, Runnable> SERVER_BLOCK_BREAKING_BRIDGE = new Object2ObjectOpenHashMap();
    private static final Runnable CAN_MINE_CALLED_FIRST = () -> {};

    public SlabToolItem(class_1792.class_1793 settings) {
        super(settings);
    }

    protected static class_2680 toDoubleSlab(class_2680 baseBlockState, class_2248 slabBlock) {
        class_2680 slabState = slabBlock.method_34725(baseBlockState);
        return slabState.method_28498((class_2769)class_2741.field_12485) ? (class_2680)slabState.method_11657((class_2769)class_2741.field_12485, (Comparable)class_2771.field_12682) : slabState;
    }

    protected static class_2680 tryToDoubleSlab(class_2680 state) {
        class_2248 block = state.method_26204();
        if (BLOCK_TO_SLAB.containsKey((Object)block)) {
            state = SlabToolItem.toDoubleSlab(state, (class_2248)BLOCK_TO_SLAB.get((Object)block));
        } else if (block instanceof AbstractRoadBlock && RoadSlabBlocks.BLOCK_TO_SLABS.containsKey((Object)block)) {
            state = SlabToolItem.toDoubleSlab(state, (class_2248)RoadSlabBlocks.BLOCK_TO_SLABS.get((Object)block));
        } else {
            class_2248 slab = ExtShapeBridge.getExtShapeSlabBlock(block);
            if (slab != null) {
                state = SlabToolItem.toDoubleSlab(state, slab);
            } else {
                class_2960 id = class_7923.field_41175.method_10221((Object)block);
                String idPath = id.method_12832();
                class_2960 slabId = new class_2960(id.method_12836(), idPath + "_slab");
                if (class_7923.field_41175.method_10250(slabId)) {
                    state = SlabToolItem.toDoubleSlab(state, (class_2248)class_7923.field_41175.method_10223(slabId));
                } else {
                    class_2960 slabId2 = idPath.endsWith("_bricks") || idPath.endsWith("_tiles") ? new class_2960(id.method_12836(), idPath.substring(0, idPath.length() - 1) + "_slab") : (idPath.endsWith("_planks") ? new class_2960(id.method_12836(), idPath.substring(0, idPath.length() - 7) + "_slab") : null);
                    if (slabId2 != null && class_7923.field_41175.method_10250(slabId2)) {
                        state = SlabToolItem.toDoubleSlab(state, (class_2248)class_7923.field_41175.method_10223(slabId2));
                    }
                }
            }
        }
        if (state.method_28498((class_2769)class_2741.field_12485) && state.method_11654((class_2769)class_2741.field_12485) == class_2771.field_12682) {
            return state;
        }
        return null;
    }

    private static boolean performBreak(class_1937 world, class_2338 pos, class_1657 miner, boolean isTop) {
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        class_2680 doubleSlabState = SlabToolItem.tryToDoubleSlab(state);
        if (doubleSlabState != null) {
            state = doubleSlabState;
        }
        if (state.method_28498((class_2769)class_2741.field_12485) && state.method_11654((class_2769)class_2741.field_12485) == class_2771.field_12682) {
            class_2487 nbt;
            class_2771 slabTypeToSet = isTop ? class_2771.field_12681 : class_2771.field_12679;
            class_2771 slabTypeBroken = isTop ? class_2771.field_12679 : class_2771.field_12681;
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity != null) {
                nbt = blockEntity.method_38244();
                world.method_8544(pos);
            } else {
                nbt = null;
            }
            boolean bl1 = world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12485, (Comparable)slabTypeToSet));
            class_2586 newBlockEntity = world.method_8321(pos);
            if (newBlockEntity != null && nbt != null) {
                newBlockEntity.method_11014(nbt);
            }
            class_2680 brokenState = (class_2680)state.method_11657((class_2769)class_2741.field_12485, (Comparable)slabTypeBroken);
            block.method_9576(world, pos, brokenState, miner);
            if (bl1) {
                block.method_9585((class_1936)world, pos, brokenState);
                if (!miner.method_7337()) {
                    block.method_9556(world, miner, pos, brokenState, world.method_8321(pos), miner.method_6047().method_7972());
                }
                miner.method_5998(class_1268.field_5808).method_7956(1, (class_1309)miner, player -> player.method_20236(class_1268.field_5808));
            }
            return bl1;
        }
        return false;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)TextBridge.translatable("item.mishanguc.slab_tool.tooltip").method_27692(class_124.field_1080));
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        boolean b;
        if (world.field_9236 && miner instanceof class_746) {
            class_239 raycast = class_310.method_1551().field_1765;
            if (!(raycast instanceof class_3965) || raycast.method_17783() == class_239.class_240.field_1333) {
                return false;
            }
            boolean isTop = raycast.method_17784().field_1351 - (double)((class_3965)raycast).method_17777().method_10264() > 0.5;
            boolean bl1 = SlabToolItem.performBreak(world, pos, miner, isTop);
            class_2540 buf = PacketByteBufs.create();
            buf.method_10807(pos);
            buf.writeBoolean(isTop);
            ClientPlayNetworking.send((class_2960)new class_2960("mishanguc", "slab_tool"), (class_2540)buf);
            return !bl1;
        }
        Runnable remove = SERVER_BLOCK_BREAKING_BRIDGE.remove(Pair.of((Object)world, (Object)pos));
        if (remove instanceof PacketReceivedFirst) {
            remove.run();
            return false;
        }
        boolean bl = b = SlabToolItem.tryToDoubleSlab(state) == null;
        if (remove == null && !b) {
            SERVER_BLOCK_BREAKING_BRIDGE.put((Pair<class_3218, class_2338>)Pair.of((Object)((class_3218)world), (Object)pos), CAN_MINE_CALLED_FIRST);
        }
        return b;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlockOutline(class_1657 player, class_1799 itemStack, WorldRenderContext worldRenderContext, WorldRenderContext.BlockOutlineContext blockOutlineContext, class_1268 hand) {
        class_4597 consumers = worldRenderContext.consumers();
        if (consumers == null || hand != class_1268.field_5808) {
            return true;
        }
        class_638 world = worldRenderContext.world();
        class_2680 state = blockOutlineContext.blockState();
        class_239 crosshairTarget = class_310.method_1551().field_1765;
        if (!(crosshairTarget instanceof class_3965)) {
            return true;
        }
        class_3965 blockHitResult = (class_3965)crosshairTarget;
        boolean isTop = crosshairTarget.method_17784().field_1351 - (double)blockHitResult.method_17777().method_10264() > 0.5;
        state = SlabToolItem.tryToDoubleSlab(state);
        if (state != null) {
            class_2680 halfState = (class_2680)state.method_11657((class_2769)class_2741.field_12485, (Comparable)(isTop ? class_2771.field_12679 : class_2771.field_12681));
            class_2338 blockPos = blockOutlineContext.blockPos();
            WorldRendererInvoker.drawCuboidShapeOutline(worldRenderContext.matrixStack(), consumers.getBuffer((class_1921)class_1921.field_21695), halfState.method_26172((class_1922)world, blockPos, class_3726.method_16195((class_1297)blockOutlineContext.entity())), (double)blockPos.method_10263() - blockOutlineContext.cameraX(), (double)blockPos.method_10264() - blockOutlineContext.cameraY(), (double)blockPos.method_10260() - blockOutlineContext.cameraZ(), 0.0f, 0.0f, 0.0f, 0.4f);
            return false;
        }
        return true;
    }

    @Override
    public class_5797 getCraftingRecipe() {
        return class_2447.method_10437((class_7800)class_7800.field_40638, (class_1935)this).method_10439("SCS").method_10439(" | ").method_10439(" | ").method_10434(Character.valueOf('S'), (class_1935)class_1802.field_8868).method_10434(Character.valueOf('C'), (class_1935)class_1802.field_20391).method_10434(Character.valueOf('|'), (class_1935)class_1802.field_8600).method_10429("has_shears", (class_184)class_2446.method_10426((class_1935)class_1802.field_8868)).method_10429("has_stone", (class_184)class_2446.method_10426((class_1935)class_1802.field_20391));
    }

    @ApiStatus.AvailableSince(value="1.0.4")
    private static final class ExtShapeBridge {
        private static final Class<?> extshape_BlockMappings_class;
        private static final Method extshape_getBlockOf_method;
        private static final Object extshape_slab_shape;

        private ExtShapeBridge() {
        }

        @Nullable
        public static class_2248 getExtShapeSlabBlock(class_2248 baseBlock) {
            if (extshape_BlockMappings_class == null || extshape_getBlockOf_method == null || extshape_slab_shape == null) {
                return null;
            }
            try {
                return (class_2248)extshape_getBlockOf_method.invoke(null, extshape_slab_shape, baseBlock);
            }
            catch (ClassCastException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Mishanguc.MISHANG_LOGGER.error("Unexpected error when trying to get slab of block {}. This should not happen no matter whether you have installed Mishang Urban Construction mod.", (Object)baseBlock, (Object)e);
                return null;
            }
        }

        static {
            Class<?> extshape_BlockMappings_class1;
            Method extshape_getBlockOf_method1;
            Object extshape_slab_shape1;
            block4: {
                extshape_slab_shape1 = null;
                extshape_getBlockOf_method1 = null;
                extshape_BlockMappings_class1 = null;
                if (FabricLoader.getInstance().isModLoaded("extshape")) {
                    try {
                        extshape_BlockMappings_class1 = Class.forName("pers.solid.extshape.util.BlockBiMaps");
                        Class<?> extshape_BlockShape_class = Class.forName("pers.solid.extshape.builder.BlockShape");
                        extshape_getBlockOf_method1 = MethodUtils.getAccessibleMethod(extshape_BlockMappings_class1, (String)"getBlockOf", (Class[])new Class[]{extshape_BlockShape_class, class_2248.class});
                        extshape_slab_shape1 = FieldUtils.getDeclaredField(extshape_BlockShape_class, (String)"SLAB").get(null);
                    }
                    catch (Throwable e) {
                        extshape_BlockMappings_class1 = null;
                        extshape_getBlockOf_method1 = null;
                        if (e instanceof ClassNotFoundException || e instanceof ClassCastException) break block4;
                        Mishanguc.MISHANG_LOGGER.error("Unknown exception when trying to connect with Extended Block Shape mod:", e);
                    }
                }
            }
            extshape_slab_shape = extshape_slab_shape1;
            extshape_getBlockOf_method = extshape_getBlockOf_method1;
            extshape_BlockMappings_class = extshape_BlockMappings_class1;
            if (extshape_slab_shape != null && extshape_getBlockOf_method != null) {
                Mishanguc.MISHANG_LOGGER.info("Mishang Urban Construction mod has successfully created bridged into Extended Block Shapes mod!");
            }
        }
    }

    private static interface PacketReceivedFirst
    extends Runnable {
    }

    @ApiStatus.AvailableSince(value="1.0.3")
    public static enum Handler implements ServerPlayNetworking.PlayChannelHandler
    {
        INSTANCE;


        public void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
            class_2338 blockPos = buf.method_10811();
            boolean isTop = buf.readBoolean();
            server.execute(() -> {
                if (player.method_33571().method_1025(class_243.method_24953((class_2382)blockPos)) > class_3244.field_37280) {
                    return;
                }
                class_1799 stack = player.method_6047();
                if (!(stack.method_7909() instanceof SlabToolItem) || !player.method_31549().field_7476 && !stack.method_7940(server.method_30611().method_30530(class_7924.field_41254), new class_2694((class_4538)player.method_37908(), blockPos, false))) {
                    return;
                }
                Runnable remove = SERVER_BLOCK_BREAKING_BRIDGE.remove(Pair.of((Object)player.method_37908(), (Object)blockPos));
                if (remove == CAN_MINE_CALLED_FIRST) {
                    SlabToolItem.performBreak(player.method_37908(), blockPos, (class_1657)player, isTop);
                } else if (SlabToolItem.tryToDoubleSlab(player.method_51469().method_8320(blockPos)) != null) {
                    SERVER_BLOCK_BREAKING_BRIDGE.put((Pair<class_3218, class_2338>)Pair.of((Object)player.method_51469(), (Object)blockPos), () -> SlabToolItem.performBreak((class_1937)player.method_51469(), blockPos, (class_1657)player, isTop));
                }
            });
        }
    }
}

