/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.screen;

import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_8494;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.MishangUtils;
import pers.solid.mishang.uc.screen.TooltipUpdated;
import pers.solid.mishang.uc.util.TextBridge;

@Environment(value=EnvType.CLIENT)
public class FloatButtonWidget
extends class_4185
implements TooltipUpdated {
    private final Function<FloatButtonWidget, @Nullable Float> valueGetter;
    private final ValueConsumer valueSetter;
    private boolean sliderFocused;
    public float defaultValue = 0.0f;
    public float step = 1.0f;
    public float rightArrowStepMultiplier = 1.0f;
    public float upArrowStepMultiplier = 1.0f;
    public float scrollMultiplier = -1.0f;
    public float min = Float.NEGATIVE_INFINITY;
    public float max = Float.POSITIVE_INFINITY;
    public static final Float2ObjectFunction<class_5250> DEFAULT_VALUE_NARRATOR = value -> TextBridge.literal(MishangUtils.numberToString(value));
    private Float2ObjectFunction<class_5250> valueToText = DEFAULT_VALUE_NARRATOR;
    public NameRenderer renderedNameSupplier = null;

    public FloatButtonWidget(int x, int y, int width, int height, class_2561 message, Function<FloatButtonWidget, Float> valueGetter, ValueConsumer valueSetter, class_4185.class_4241 onPress) {
        super(x, y, width, height, message, onPress, class_4185.field_40754);
        this.valueGetter = valueGetter;
        this.valueSetter = valueSetter;
        this.updateTooltip();
    }

    @Override
    public void updateTooltip() {
        Float value = this.getValue();
        if (value != null) {
            class_5250 valueText = (class_5250)this.valueToText.get(value.floatValue());
            this.method_47400(class_7919.method_47408((class_2561)class_5244.method_32700((class_2561)this.getSummaryMessage(), (class_2561)valueText), (class_2561)TextBridge.translatable("narration.mishanguc.button.current_value", valueText)));
        } else {
            this.method_47400(class_7919.method_47408((class_2561)this.getSummaryMessage(), (class_2561)TextBridge.empty()));
        }
    }

    @Nullable
    public Float getValue() {
        return this.valueGetter.apply(this);
    }

    public void setAllSameValue(float value) {
        this.setValue(n -> value);
    }

    public void setValue(Float2FloatFunction valueFunction) {
        Float original = this.getValue();
        if (original == null) {
            return;
        }
        this.valueSetter.accept(valueFunction.andThenFloat(value -> {
            if (value < this.min) {
                value = Float.isFinite(this.max) ? this.max : this.min;
            } else if (value > this.max) {
                value = Float.isFinite(this.min) ? this.min : this.max;
            }
            return value;
        }), original);
        this.updateTooltip();
    }

    protected void method_49604(class_332 context, class_327 textRenderer, int xMargin, int color) {
        if (!this.sliderFocused || class_156.method_658() % 1000L > 500L) {
            super.method_49604(context, textRenderer, xMargin, color);
        }
    }

    public void method_25306() {
        this.onPress(0);
    }

    public void onPress(int button) {
        switch (button) {
            case 0: 
            case 1: {
                this.setValue(value -> value + (float)(class_437.method_25442() || button == 1 ? -1 : 1) * this.step * (float)(class_437.method_25441() ? 8 : 1) * (class_437.method_25443() ? 0.125f : 1.0f));
                break;
            }
            case 2: {
                this.setAllSameValue(this.defaultValue);
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.field_22763 && this.field_22764 && this.method_25361(mouseX, mouseY)) {
            this.method_25354(class_310.method_1551().method_1483());
            this.onPress(button);
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        this.setValue(value -> (float)((double)value + amount * (double)(class_437.method_25442() ? -1 : 1) * (double)(class_437.method_25441() ? 8 : 1) * (double)this.step * (double)this.scrollMultiplier * (double)(class_437.method_25443() ? 0.125f : 1.0f)));
        super.method_25401(mouseX, mouseY, amount);
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!class_8494.method_51255((int)keyCode)) {
            if (this.sliderFocused) {
                boolean decreases = keyCode == 263 || keyCode == 264;
                long handle = class_310.method_1551().method_22683().method_4490();
                if (keyCode == 263 && class_3675.method_15987((long)handle, (int)262) || keyCode == 262 && class_3675.method_15987((long)handle, (int)263)) {
                    this.setAllSameValue(this.defaultValue);
                    return true;
                }
                if ((decreases || keyCode == 262 || keyCode == 265) && this.getValue() != null) {
                    float multiplier = keyCode == 262 || keyCode == 263 ? this.rightArrowStepMultiplier : this.upArrowStepMultiplier;
                    float sign = decreases ? -1.0f : 1.0f;
                    this.setValue(value -> value + sign * (float)(class_437.method_25442() ? -1 : 1) * (float)(class_437.method_25441() ? 8 : 1) * this.step * multiplier * (class_437.method_25443() ? 0.125f : 1.0f));
                    return true;
                }
            }
            return false;
        }
        this.sliderFocused = this.getValue() != null && !this.sliderFocused;
        this.method_25354(class_310.method_1551().method_1483());
        return true;
    }

    public class_2561 method_25369() {
        class_2561 apply;
        Float value = this.getValue();
        if (this.renderedNameSupplier != null && (apply = this.renderedNameSupplier.apply(value, (class_2561)this.valueToText.apply((Object)value))) != null) {
            return apply;
        }
        if (value == null || value.floatValue() == this.defaultValue) {
            return super.method_25369();
        }
        return TextBridge.empty().method_10852(super.method_25369()).method_27692(class_124.field_1056);
    }

    public FloatButtonWidget setRenderedNameSupplier(NameRenderer renderedNameSupplier) {
        this.renderedNameSupplier = renderedNameSupplier;
        return this;
    }

    public class_2561 getSummaryMessage() {
        return super.method_25369();
    }

    public void method_25365(boolean focused) {
        super.method_25365(focused);
        if (!focused) {
            this.sliderFocused = false;
        }
        this.updateTooltip();
    }

    protected class_5250 method_25360() {
        return FloatButtonWidget.method_32602((class_2561)this.getSummaryMessage());
    }

    protected void method_37021(class_6382 builder) {
        super.method_37021(builder);
        if (this.getValue() == null) {
            builder.method_37034(class_6381.field_33791, (class_2561)TextBridge.translatable("narration.mishanguc.button.null"));
        } else if (this.sliderFocused) {
            builder.method_37034(class_6381.field_33791, (class_2561)TextBridge.translatable("narration.mishanguc.button.float_usage.focused"));
        } else {
            builder.method_37034(class_6381.field_33791, (class_2561)TextBridge.translatable("narration.mishanguc.button.float_usage"));
        }
    }

    @Contract(value="_ -> this", mutates="this")
    protected FloatButtonWidget nameValueAs(Float2ObjectFunction<class_5250> valueToText) {
        this.valueToText = valueToText;
        return this;
    }

    @Environment(value=EnvType.CLIENT)
    public static interface NameRenderer
    extends BiFunction<Float, class_2561, class_2561> {
        @Override
        @Nullable
        public class_2561 apply(@Nullable Float var1, class_2561 var2);
    }

    @FunctionalInterface
    public static interface ValueConsumer
    extends BiConsumer<Float2FloatFunction, Float> {
        @Override
        public void accept(Float2FloatFunction var1, @NotNull Float var2);
    }
}

