/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.text;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.text.SpecialDrawableType;
import pers.solid.mishang.uc.text.SpecialDrawableTypes;
import pers.solid.mishang.uc.text.TextContext;
import pers.solid.mishang.uc.util.TextBridge;

public interface SpecialDrawable
extends Cloneable {
    public static final SpecialDrawable INVALID = new SpecialDrawable(){

        @Override
        @Environment(value=EnvType.CLIENT)
        public void drawExtra(class_327 textRenderer, class_4587 matrixStack, class_4597 vertexConsumers, int light, float x, float y) {
        }

        @Override
        @NotNull
        public String getId() {
            return "invalid";
        }

        @NotNull
        public SpecialDrawableType<SpecialDrawable> getType() {
            return SpecialDrawableTypes.INVALID;
        }

        @Override
        public SpecialDrawable cloneWithNewTextContext(@NotNull TextContext textContext) {
            return INVALID;
        }
    };

    @Environment(value=EnvType.CLIENT)
    public void drawExtra(class_327 var1, class_4587 var2, class_4597 var3, int var4, float var5, float var6);

    @Contract(pure=true)
    @NotNull
    default public String getId() {
        class_2960 id = this.getType().getId();
        if (id.method_12836().equals("mishanguc")) {
            return id.method_12832();
        }
        return id.toString();
    }

    @Contract(pure=true)
    @ApiStatus.AvailableSince(value="0.2.4")
    @NotNull
    public SpecialDrawableType<? extends SpecialDrawable> getType();

    @Contract(mutates="param1")
    default public void writeNbt(class_2487 nbt) {
        nbt.method_10582("id", this.getId());
    }

    @ApiStatus.AvailableSince(value="0.2.4")
    default public class_2487 createNbt() {
        class_2487 nbt = new class_2487();
        this.writeNbt(nbt);
        return nbt;
    }

    @Contract(value="_, _ -> new")
    @Nullable
    public static SpecialDrawable fromNbt(TextContext textContext, @NotNull class_2487 nbt) {
        String id = nbt.method_10558("id");
        if (id == null) {
            return null;
        }
        SpecialDrawableType<SpecialDrawable> type = SpecialDrawableType.tryFromId(id);
        if (type == null) {
            return null;
        }
        return type.fromNbt(textContext, nbt);
    }

    @Contract(pure=true)
    default public String asStringArgs() {
        return "";
    }

    @Nullable
    public static SpecialDrawable fromStringArgs(TextContext textContext, String id, String args) {
        if (id == null) {
            return null;
        }
        SpecialDrawableType<SpecialDrawable> type = SpecialDrawableType.tryFromId(id);
        if (type == null) {
            return null;
        }
        SpecialDrawable specialDrawable = type.fromStringArgs(textContext, args);
        return specialDrawable == null ? INVALID : specialDrawable;
    }

    default public float width() {
        return 0.0f;
    }

    default public float height() {
        return 0.0f;
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.Internal
    public SpecialDrawable cloneWithNewTextContext(@NotNull TextContext var1);

    @NotNull
    default public class_5250 asStyledText() {
        return TextBridge.literal(this.getType().getId().method_12832() + " " + this.asStringArgs());
    }
}

