/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.text;

import com.google.common.collect.ImmutableBiMap;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.chars.Char2CharArrayMap;
import it.unimi.dsi.fastutil.chars.Char2CharMap;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_7417;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Quaternionf;
import pers.solid.mishang.uc.MishangUtils;
import pers.solid.mishang.uc.text.OutlineColorType;
import pers.solid.mishang.uc.text.PatternSpecialDrawable;
import pers.solid.mishang.uc.text.SpecialDrawable;
import pers.solid.mishang.uc.util.HorizontalAlign;
import pers.solid.mishang.uc.util.TextBridge;
import pers.solid.mishang.uc.util.VerticalAlign;

public class TextContext
implements Cloneable {
    private static final Char2CharMap flipStringReplacement = (Char2CharMap)class_156.method_654((Object)new Char2CharArrayMap(), map -> {
        map.put('\u2190', '\u2192');
        map.put('\u2192', '\u2190');
        map.put('\u2196', '\u2197');
        map.put('\u2197', '\u2196');
        map.put('\u2198', '\u2199');
        map.put('\u2199', '\u2198');
    });
    @ApiStatus.AvailableSince(value="0.2.0")
    private static final @Unmodifiable ImmutableBiMap<String, String> flipPatternNameReplacement = new ImmutableBiMap.Builder().put((Object)"al", (Object)"ar").put((Object)"alt", (Object)"art").put((Object)"alb", (Object)"arb").put((Object)"ulb", (Object)"urb").put((Object)"ult", (Object)"urt").build();
    @Nullable
    public class_5250 text;
    public HorizontalAlign horizontalAlign = HorizontalAlign.CENTER;
    public VerticalAlign verticalAlign = VerticalAlign.MIDDLE;
    public int color = 0xFFFFFF;
    public boolean shadow = false;
    public boolean seeThrough = false;
    public float offsetX = 0.0f;
    public float offsetY = 0.0f;
    public float offsetZ = 0.0f;
    public float rotationX = 0.0f;
    public float rotationY = 0.0f;
    public float rotationZ = 0.0f;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public boolean bold = false;
    public boolean italic = false;
    public boolean underline = false;
    public boolean strikethrough = false;
    public boolean obfuscated = false;
    public boolean absolute = false;
    public float size = 8.0f;
    @ApiStatus.AvailableSince(value="0.1.6-mc1.17")
    public int outlineColor = -2;
    @ApiStatus.AvailableSince(value="1.4.2")
    @NotNull
    public OutlineColorType outlineColorType = OutlineColorType.NONE;
    @ApiStatus.AvailableSince(value="0.2.0")
    @Nullable
    public SpecialDrawable extra = null;
    @ApiStatus.AvailableSince(value="0.2.1")
    private transient boolean[] cachedStyles = null;
    @ApiStatus.AvailableSince(value="0.2.1")
    private transient class_2561 cachedText = null;
    @ApiStatus.AvailableSince(value="0.2.1")
    private transient class_5250 formattedText = null;

    @NotNull
    public static TextContext fromNbt(class_2520 nbt) {
        return TextContext.fromNbt(nbt, new TextContext());
    }

    @Contract(value="_, _ -> param2", mutates="param2")
    @NotNull
    public static TextContext fromNbt(class_2520 nbt, TextContext defaults) {
        if (nbt instanceof class_2519 || nbt instanceof class_2514) {
            defaults.text = TextBridge.literal(nbt.method_10714());
        } else if (nbt instanceof class_2487) {
            class_2487 nbtCompound = (class_2487)nbt;
            defaults.readNbt(nbtCompound);
        }
        return defaults;
    }

    private static void putBooleanParam(class_2487 nbt, String name, boolean value) {
        if (value) {
            nbt.method_10556(name, true);
        } else {
            nbt.method_10551(name);
        }
    }

    @Contract(mutates="this")
    public void readNbt(@NotNull class_2487 nbt) {
        @Nullable class_2520 nbtText = nbt.method_10580("text");
        String textJson = nbt.method_10558("textJson");
        if (!textJson.isEmpty()) {
            try {
                this.text = class_2561.class_2562.method_10873((String)textJson);
            }
            catch (JsonParseException e) {
                this.text = TextBridge.translatable("message.mishanguc.invalid_json", e.getMessage());
            }
        } else {
            this.text = nbtText instanceof class_2519 ? TextBridge.literal(nbtText.method_10714()) : null;
        }
        this.horizontalAlign = HorizontalAlign.byName(nbt.method_10558("horizontalAlign"));
        if (this.horizontalAlign == null) {
            this.horizontalAlign = HorizontalAlign.CENTER;
        }
        this.verticalAlign = VerticalAlign.byName(nbt.method_10558("verticalAlign"));
        if (this.verticalAlign == null) {
            this.verticalAlign = VerticalAlign.MIDDLE;
        }
        if (nbt.method_10545("color")) {
            this.color = MishangUtils.readColorFromNbtElement(nbt.method_10580("color"));
        }
        OutlineColorType outlineColorType = nbt.method_10545("outlineColorType") ? (OutlineColorType)OutlineColorType.CODEC.method_42633(nbt.method_10558("outlineColorType")) : null;
        if (nbt.method_10545("outlineColor")) {
            this.outlineColor = MishangUtils.readColorFromNbtElement(nbt.method_10580("outlineColor"));
        }
        this.outlineColorType = outlineColorType == null ? OutlineColorType.fromCompatibilityValue(this.outlineColor) : outlineColorType;
        this.shadow = nbt.method_10577("shadow");
        this.seeThrough = nbt.method_10577("seeThrough");
        this.offsetX = nbt.method_10583("offsetX");
        this.offsetY = nbt.method_10583("offsetY");
        this.offsetZ = nbt.method_10583("offsetZ");
        this.rotationX = nbt.method_10583("rotationX");
        this.rotationY = nbt.method_10583("rotationY");
        this.rotationZ = nbt.method_10583("rotationZ");
        this.scaleX = nbt.method_10583("scaleX");
        if (this.scaleX == 0.0f) {
            this.scaleX = 1.0f;
        }
        this.scaleY = nbt.method_10583("scaleY");
        if (this.scaleY == 0.0f) {
            this.scaleY = 1.0f;
        }
        this.size = nbt.method_10573("size", 99) ? nbt.method_10583("size") : this.size;
        this.bold = nbt.method_10577("bold");
        this.italic = nbt.method_10577("italic");
        this.underline = nbt.method_10577("underline");
        this.strikethrough = nbt.method_10577("strikethrough");
        this.obfuscated = nbt.method_10577("obfuscated");
        this.absolute = nbt.method_10577("absolute");
        this.extra = nbt.method_10573("extra", 10) ? SpecialDrawable.fromNbt(this, nbt.method_10562("extra")) : null;
    }

    @Environment(value=EnvType.CLIENT)
    @Contract(pure=true)
    public void draw(class_327 textRenderer, class_4587 matrixStack, class_4597 vertexConsumers, int light, float width, float height) {
        if (this.text == null && this.extra == null) {
            return;
        }
        if (!Arrays.equals(this.cachedStyles, new boolean[]{this.bold, this.italic, this.underline, this.strikethrough, this.obfuscated}) || this.text != this.cachedText) {
            this.reformatText();
        }
        class_5481 orderedText = this.formattedText == null ? null : this.formattedText.method_30937();
        matrixStack.method_22903();
        matrixStack.method_46416(this.offsetX, this.offsetY, this.offsetZ);
        if (this.rotationX != 0.0f || this.rotationY != 0.0f || this.rotationZ != 0.0f) {
            matrixStack.method_22907(new Quaternionf().rotateXYZ((float)Math.PI / 180 * this.rotationX, (float)Math.PI / 180 * this.rotationY, (float)Math.PI / 180 * this.rotationZ));
        }
        float x = 0.0f;
        switch (this.horizontalAlign == null ? HorizontalAlign.CENTER : this.horizontalAlign) {
            case LEFT: {
                matrixStack.method_46416(-width / 2.0f, 0.0f, 0.0f);
                break;
            }
            case CENTER: {
                matrixStack.method_46416(-this.getWidth(textRenderer, orderedText) / 4.0f, 0.0f, 0.0f);
                break;
            }
            case RIGHT: {
                matrixStack.method_46416(width / 2.0f - this.getWidth(textRenderer, orderedText) / 2.0f, 0.0f, 0.0f);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.horizontalAlign));
            }
        }
        float y = 0.0f;
        switch (this.verticalAlign == null ? VerticalAlign.MIDDLE : this.verticalAlign) {
            case TOP: {
                matrixStack.method_46416(0.0f, -height / 2.0f, 0.0f);
                break;
            }
            case MIDDLE: {
                matrixStack.method_46416(0.0f, -this.getHeight() / 4.0f, 0.0f);
                break;
            }
            case BOTTOM: {
                matrixStack.method_46416(0.0f, height / 2.0f - this.getHeight() / 2.0f, 0.0f);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.verticalAlign));
            }
        }
        matrixStack.method_22905(this.size / 16.0f, this.size / 16.0f, this.size / 16.0f);
        matrixStack.method_22905(this.scaleX, this.scaleY, 1.0f);
        if (orderedText != null) {
            this.drawText(textRenderer, matrixStack, vertexConsumers, light, orderedText, x, y);
        }
        if (this.extra != null) {
            this.extra.drawExtra(textRenderer, matrixStack, vertexConsumers, light, x, y);
        }
        matrixStack.method_22909();
    }

    @Environment(value=EnvType.CLIENT)
    @ApiStatus.AvailableSince(value="0.2.1")
    private void reformatText() {
        if (this.text == null) {
            this.cachedText = null;
            this.formattedText = null;
            return;
        }
        this.cachedText = this.text;
        this.formattedText = this.text.method_27661();
        if (this.bold) {
            this.formattedText.method_27692(class_124.field_1067);
        }
        if (this.italic) {
            this.formattedText.method_27692(class_124.field_1056);
        }
        if (this.underline) {
            this.formattedText.method_27692(class_124.field_1073);
        }
        if (this.strikethrough) {
            this.formattedText.method_27692(class_124.field_1055);
        }
        if (this.obfuscated) {
            this.formattedText.method_27692(class_124.field_1051);
        }
        this.cachedStyles = new boolean[]{this.bold, this.italic, this.underline, this.strikethrough, this.obfuscated};
    }

    private float getWidth(class_327 textRenderer, @Nullable class_5481 text) {
        float width = text == null ? 0.0f : (float)textRenderer.method_30880(text) * this.size / 8.0f * this.scaleX;
        return this.extra != null ? Math.max(width, this.extra.width() * this.size * this.scaleX) : width;
    }

    public float getHeight() {
        return (this.extra != null ? this.extra.height() * this.size : this.size) * this.scaleY;
    }

    public float getMarginTop() {
        return this.extra != null ? 0.0f : this.size / 8.0f;
    }

    @Environment(value=EnvType.CLIENT)
    @Contract(pure=true)
    protected void drawText(class_327 textRenderer, class_4587 matrixStack, class_4597 vertexConsumers, int light, class_5481 text, float x, float y) {
        if (this.outlineColorType == OutlineColorType.NONE) {
            textRenderer.method_22942(text, x, y, this.color, this.shadow, matrixStack.method_23760().method_23761(), vertexConsumers, this.seeThrough ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, 0, light);
        } else {
            textRenderer.method_37296(text, x, y, this.color, this.outlineColorType == OutlineColorType.AUTO ? MishangUtils.toSignOutlineColor(this.color) : this.outlineColor, matrixStack.method_23760().method_23761(), vertexConsumers, light);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Contract(mutates="param1")
    public void writeNbt(@NotNull class_2487 nbt) {
        block25: {
            block24: {
                if (this.text == null) break block24;
                var3_2 = this.text.method_10851();
                if (!(var3_2 instanceof class_2585)) ** GOTO lbl-1000
                literalTextContent = (class_2585)var3_2;
                if (this.text.method_10855().isEmpty() && this.text.method_10866().method_10967()) {
                    nbt.method_10582("text", literalTextContent.comp_737());
                } else lbl-1000:
                // 2 sources

                {
                    nbt.method_10582("textJson", class_2561.class_2562.method_10867((class_2561)this.text));
                }
                break block25;
            }
            nbt.method_10551("text");
        }
        if (this.horizontalAlign != HorizontalAlign.CENTER) {
            nbt.method_10582("horizontalAlign", this.horizontalAlign.method_15434());
        } else {
            nbt.method_10551("horizontalAlign");
        }
        if (this.verticalAlign != VerticalAlign.MIDDLE) {
            nbt.method_10582("verticalAlign", this.verticalAlign.method_15434());
        } else {
            nbt.method_10551("verticalAlign");
        }
        nbt.method_10569("color", this.color);
        nbt.method_10582("outlineColorType", this.outlineColorType.method_15434());
        nbt.method_10569("outlineColor", this.outlineColor);
        TextContext.putBooleanParam(nbt, "shadow", this.shadow);
        TextContext.putBooleanParam(nbt, "seeThrough", this.seeThrough);
        nbt.method_10548("size", this.size);
        if (this.offsetX != 0.0f) {
            nbt.method_10548("offsetX", this.offsetX);
        } else {
            nbt.method_10551("offsetX");
        }
        if (this.offsetY != 0.0f) {
            nbt.method_10548("offsetY", this.offsetY);
        } else {
            nbt.method_10551("offsetY");
        }
        if (this.offsetZ != 0.0f) {
            nbt.method_10548("offsetZ", this.offsetZ);
        } else {
            nbt.method_10551("offsetZ");
        }
        if (this.rotationX != 0.0f) {
            nbt.method_10548("rotationX", this.rotationX);
        } else {
            nbt.method_10551("rotationX");
        }
        if (this.rotationY != 0.0f) {
            nbt.method_10548("rotationY", this.rotationY);
        } else {
            nbt.method_10551("rotationX");
        }
        if (this.rotationZ != 0.0f) {
            nbt.method_10548("rotationZ", this.rotationZ);
        } else {
            nbt.method_10551("rotationX");
        }
        if (this.scaleX != 1.0f) {
            nbt.method_10548("scaleX", this.scaleX);
        } else {
            nbt.method_10551("scaleX");
        }
        if (this.scaleY != 1.0f) {
            nbt.method_10548("scaleY", this.scaleY);
        } else {
            nbt.method_10551("scaleY");
        }
        TextContext.putBooleanParam(nbt, "bold", this.bold);
        TextContext.putBooleanParam(nbt, "italic", this.italic);
        TextContext.putBooleanParam(nbt, "underline", this.underline);
        TextContext.putBooleanParam(nbt, "strikethrough", this.strikethrough);
        TextContext.putBooleanParam(nbt, "obfuscated", this.obfuscated);
        TextContext.putBooleanParam(nbt, "absolute", this.absolute);
        if (this.extra == null) {
            nbt.method_10551("extra");
        } else {
            nbt.method_10566("extra", (class_2520)this.extra.createNbt());
        }
    }

    @Contract(value="-> new")
    public final class_2487 createNbt() {
        class_2487 nbtCompound = new class_2487();
        this.writeNbt(nbtCompound);
        return nbtCompound;
    }

    public TextContext clone() {
        try {
            TextContext clone = (TextContext)super.clone();
            clone.extra = clone.extra != null ? clone.extra.cloneWithNewTextContext(clone) : null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @NotNull
    public class_5250 asStyledText() {
        class_5250 text;
        class_5250 class_52502 = text = this.text == null ? TextBridge.empty() : this.text.method_27661();
        if (this.bold) {
            text.method_27692(class_124.field_1067);
        }
        if (this.italic) {
            text.method_27692(class_124.field_1056);
        }
        if (this.underline) {
            text.method_27692(class_124.field_1073);
        }
        if (this.strikethrough) {
            text.method_27692(class_124.field_1055);
        }
        if (this.obfuscated) {
            text.method_27692(class_124.field_1051);
        }
        if (text.method_10866().method_10973() == null) {
            text.method_27694(style -> style.method_36139(this.color));
        }
        if (this.extra != null) {
            return this.extra.asStyledText();
        }
        return text;
    }

    @Contract(mutates="this")
    public TextContext flip() {
        Object rawString;
        class_7417 class_74172;
        this.offsetX = -this.offsetX;
        this.horizontalAlign = this.horizontalAlign.flip();
        if (this.text != null && (class_74172 = this.text.method_10851()) instanceof class_2585) {
            class_2585 literalTextContent = (class_2585)class_74172;
            rawString = literalTextContent.comp_737();
            StringBuilder stringBuilder = new StringBuilder((String)rawString);
            for (int i = 0; i < stringBuilder.length(); ++i) {
                char c = stringBuilder.charAt(i);
                if (!flipStringReplacement.containsKey(c)) continue;
                stringBuilder.setCharAt(i, flipStringReplacement.get(c));
            }
            this.text = TextBridge.literal(stringBuilder.toString());
        }
        if ((rawString = this.extra) instanceof PatternSpecialDrawable) {
            PatternSpecialDrawable patternTextSpecial = (PatternSpecialDrawable)rawString;
            String shapeName = patternTextSpecial.shapeName();
            if (flipPatternNameReplacement.containsKey((Object)shapeName)) {
                this.extra = PatternSpecialDrawable.fromName(this, (String)flipPatternNameReplacement.get((Object)shapeName));
            } else if (flipPatternNameReplacement.inverse().containsKey((Object)shapeName)) {
                this.extra = PatternSpecialDrawable.fromName(this, (String)flipPatternNameReplacement.inverse().get((Object)shapeName));
            }
        }
        return this;
    }
}

