/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.util;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import org.jetbrains.annotations.NotNull;
import pers.solid.mishang.uc.util.FourHorizontalAxis;
import pers.solid.mishang.uc.util.HorizontalCornerDirection;

public enum EightHorizontalDirection implements class_3542
{
    SOUTH(class_2350.field_11035),
    SOUTH_WEST(HorizontalCornerDirection.SOUTH_WEST, FourHorizontalAxis.NE_SW),
    WEST(class_2350.field_11039),
    NORTH_WEST(HorizontalCornerDirection.NORTH_WEST, FourHorizontalAxis.NW_SE),
    NORTH(class_2350.field_11043),
    NORTH_EAST(HorizontalCornerDirection.NORTH_EAST, FourHorizontalAxis.NE_SW),
    EAST(class_2350.field_11034),
    SOUTH_EAST(HorizontalCornerDirection.SOUTH_EAST, FourHorizontalAxis.NW_SE);

    public final Either<class_2350, HorizontalCornerDirection> either;
    private static final Map<class_2350, EightHorizontalDirection> DIRECTIONS;
    private static final Map<HorizontalCornerDirection, EightHorizontalDirection> CORNER_DIRECTIONS;
    public static final List<EightHorizontalDirection> VALUES;
    public final FourHorizontalAxis axis;

    private EightHorizontalDirection(class_2350 vanillaDirection) {
        this.either = Either.left((Object)vanillaDirection);
        this.axis = FourHorizontalAxis.of(vanillaDirection.method_10166());
    }

    private EightHorizontalDirection(HorizontalCornerDirection cornerDirection, FourHorizontalAxis axis) {
        this.either = Either.right((Object)((Object)cornerDirection));
        this.axis = axis;
    }

    @NotNull
    public static EightHorizontalDirection of(@NotNull class_2350 direction) {
        return DIRECTIONS.get(direction);
    }

    @NotNull
    public static EightHorizontalDirection of(@NotNull HorizontalCornerDirection cornerDirection) {
        return CORNER_DIRECTIONS.get((Object)cornerDirection);
    }

    public EightHorizontalDirection rotate(class_2470 rotation) {
        return (EightHorizontalDirection)((Object)this.either.map(direction -> EightHorizontalDirection.of(rotation.method_10503(direction)), cornerDirection -> EightHorizontalDirection.of(cornerDirection.rotate(rotation))));
    }

    public EightHorizontalDirection mirror(class_2415 mirror) {
        return (EightHorizontalDirection)((Object)this.either.map(direction -> EightHorizontalDirection.of(mirror.method_10343(direction)), cornerDirection -> EightHorizontalDirection.of(cornerDirection.mirror(mirror))));
    }

    public float asRotation() {
        return ((Float)this.either.map(class_2350::method_10144, cornerDirection -> Float.valueOf(cornerDirection.asRotation()))).floatValue();
    }

    public static EightHorizontalDirection fromRotation(float rotation) {
        return VALUES.get(class_3532.method_15357((double)((double)(rotation / 45.0f) + 0.5)) & 7);
    }

    public Optional<class_2350> left() {
        return this.either.left();
    }

    public Optional<HorizontalCornerDirection> right() {
        return this.either.right();
    }

    public String method_15434() {
        return (String)this.either.map(class_2350::method_15434, HorizontalCornerDirection::method_15434);
    }

    static {
        DIRECTIONS = new EnumMap<class_2350, EightHorizontalDirection>(class_2350.class);
        CORNER_DIRECTIONS = new EnumMap<HorizontalCornerDirection, EightHorizontalDirection>(HorizontalCornerDirection.class);
        VALUES = ImmutableList.copyOf((Object[])EightHorizontalDirection.values());
        for (EightHorizontalDirection value : VALUES) {
            value.either.map(left -> DIRECTIONS.put((class_2350)left, value), right -> CORNER_DIRECTIONS.put((HorizontalCornerDirection)((Object)right), value));
        }
    }
}

