/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.util;

import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_3542;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum HorizontalCornerDirection implements class_3542
{
    SOUTH_WEST(0, 45, "south_west", class_2350.field_11035, class_2350.field_11039),
    NORTH_WEST(1, 135, "north_west", class_2350.field_11043, class_2350.field_11039),
    NORTH_EAST(2, 225, "north_east", class_2350.field_11043, class_2350.field_11034),
    SOUTH_EAST(3, -45, "south_east", class_2350.field_11035, class_2350.field_11034);

    private final String name;
    private final class_2350 dir1;
    private final class_2350 dir2;
    private final int id;
    private final int rotation;

    private HorizontalCornerDirection(int id, int rotation, String name, class_2350 dir1, class_2350 dir2) {
        this.rotation = rotation;
        if (dir1 == dir2 || dir1.method_10153() == dir2) {
            throw new IllegalArgumentException("The two directions of a corner direction cannot be same or opposite!");
        }
        this.id = id;
        this.name = name;
        this.dir1 = dir1;
        this.dir2 = dir2;
    }

    @NotNull
    public static HorizontalCornerDirection fromDirections(@NotNull class_2350 dir1, @NotNull class_2350 dir2) throws IllegalArgumentException {
        for (HorizontalCornerDirection direction : HorizontalCornerDirection.values()) {
            if ((direction.dir1 != dir1 || direction.dir2 != dir2) && (direction.dir1 != dir2 || direction.dir2 != dir1)) continue;
            return direction;
        }
        throw new IllegalArgumentException("There is no horizontal corner direction composed of " + dir1.method_15434() + " " + dir2.method_15434() + ".");
    }

    @Contract(value="_, _, !null -> !null", pure=true)
    @Nullable
    public static HorizontalCornerDirection fromDirections(@NotNull class_2350 dir1, @NotNull class_2350 dir2, @Nullable HorizontalCornerDirection defaultValue) {
        try {
            return HorizontalCornerDirection.fromDirections(dir1, dir2);
        }
        catch (IllegalArgumentException ignore) {
            return defaultValue;
        }
    }

    @NotNull
    public static HorizontalCornerDirection fromId(int id) {
        id &= 3;
        for (HorizontalCornerDirection direction : HorizontalCornerDirection.values()) {
            if (direction.id != id) continue;
            return direction;
        }
        throw new IllegalStateException();
    }

    public static HorizontalCornerDirection fromRotation(float rotation) {
        return HorizontalCornerDirection.fromId(Math.floorDiv((int)rotation, 90));
    }

    public String method_15434() {
        return this.name;
    }

    public class_2350 getDirectionInAxis(class_2350.class_2351 axis) {
        if (this.dir1.method_10166() == axis) {
            return this.dir1;
        }
        if (this.dir2.method_10166() == axis) {
            return this.dir2;
        }
        throw new IllegalStateException("Direction " + this.method_15434() + " has no direction in axis " + axis.method_15434() + "!");
    }

    public int asRotation() {
        return this.rotation;
    }

    public boolean hasDirection(class_2350 direction) {
        return direction == this.dir1 || direction == this.dir2;
    }

    @NotNull
    public HorizontalCornerDirection rotateYClockwise() {
        return HorizontalCornerDirection.fromDirections(this.dir1.method_10170(), this.dir2.method_10170());
    }

    @NotNull
    public HorizontalCornerDirection rotateYCounterclockwise() {
        return HorizontalCornerDirection.fromDirections(this.dir1.method_10160(), this.dir2.method_10160());
    }

    @NotNull
    public HorizontalCornerDirection mirror(class_2415 mirror) {
        return HorizontalCornerDirection.fromDirections(mirror.method_10343(this.dir1), mirror.method_10343(this.dir2));
    }

    @NotNull
    public HorizontalCornerDirection mirror(class_2350 direction) {
        class_2415 mirror = switch (direction.method_10166()) {
            case class_2350.class_2351.field_11048 -> class_2415.field_11300;
            case class_2350.class_2351.field_11051 -> class_2415.field_11301;
            default -> class_2415.field_11302;
        };
        return this.mirror(mirror);
    }

    @NotNull
    public HorizontalCornerDirection rotate(class_2470 rotation) {
        return switch (rotation) {
            default -> throw new IncompatibleClassChangeError();
            case class_2470.field_11467 -> this;
            case class_2470.field_11463 -> this.rotateYClockwise();
            case class_2470.field_11465 -> this.rotateYCounterclockwise();
            case class_2470.field_11464 -> this.getOpposite();
        };
    }

    @NotNull
    public HorizontalCornerDirection getOpposite() {
        return HorizontalCornerDirection.fromDirections(this.dir1.method_10153(), this.dir2.method_10153());
    }
}

