/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.mishang.uc.util;

import com.mojang.datafixers.util.Either;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2350;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.mishang.uc.util.EightHorizontalDirection;
import pers.solid.mishang.uc.util.HorizontalCornerDirection;
import pers.solid.mishang.uc.util.LineColor;
import pers.solid.mishang.uc.util.LineOffset;
import pers.solid.mishang.uc.util.LineType;
import pers.solid.mishang.uc.util.TextBridge;

public record RoadConnectionState(WhetherConnected whetherConnected, LineColor lineColor, @Nullable EightHorizontalDirection direction, LineType lineType, @Nullable LineOffset lineOffset) implements Comparable<RoadConnectionState>
{
    public RoadConnectionState(WhetherConnected whetherConnected, LineColor lineColor, @Nullable EightHorizontalDirection direction, LineType lineType, @Nullable LineOffset lineOffset) {
        if (whetherConnected.compareTo(WhetherConnected.MAY_CONNECT) >= 0) {
            Objects.requireNonNull(direction, "direction");
        }
    }

    public RoadConnectionState(WhetherConnected whetherConnected, LineColor lineColor, @Nullable EightHorizontalDirection direction, LineType lineType) {
        this(whetherConnected, lineColor, direction, lineType, null);
    }

    @Contract(value=" -> new")
    public static RoadConnectionState empty() {
        return new RoadConnectionState(WhetherConnected.NOT_CONNECTED, LineColor.NONE, null, LineType.NORMAL, null);
    }

    public static RoadConnectionState of(boolean whetherConnected, LineColor lineColor, EightHorizontalDirection direction, LineType lineType, LineOffset lineOffset) {
        return new RoadConnectionState(whetherConnected ? WhetherConnected.CONNECTED : WhetherConnected.NOT_CONNECTED, lineColor, direction, lineType, lineOffset);
    }

    public static RoadConnectionState or(RoadConnectionState state1, RoadConnectionState state2) {
        return state1.compareTo(state2) > 0 ? state1 : state2;
    }

    public static class_5250 text(@Nullable class_2350 direction) {
        if (direction == null) {
            return TextBridge.translatable("direction.mishanguc.none");
        }
        return TextBridge.translatable("direction.mishanguc." + direction.method_15434());
    }

    public static class_5250 text(@Nullable HorizontalCornerDirection direction) {
        if (direction == null) {
            return TextBridge.translatable("direction.mishanguc.none");
        }
        return TextBridge.translatable("direction.mishanguc." + direction.method_15434());
    }

    public static class_5250 text(@Nullable Either<class_2350, HorizontalCornerDirection> direction) {
        if (direction == null) {
            return TextBridge.translatable("direction.mishanguc.none");
        }
        return (class_5250)direction.map(RoadConnectionState::text, RoadConnectionState::text);
    }

    public static class_5250 text(@Nullable EightHorizontalDirection direction) {
        return direction == null ? RoadConnectionState.text((class_2350)null) : RoadConnectionState.text(direction.either);
    }

    public static class_5250 text(@NotNull WhetherConnected whetherConnected) {
        class_5250 class_52502 = TextBridge.translatable("roadConnectionState.whether." + whetherConnected.method_15434());
        return class_52502.method_27692(switch (whetherConnected.ordinal()) {
            case 0 -> class_124.field_1061;
            case 2 -> class_124.field_1060;
            default -> class_124.field_1054;
        });
    }

    public static class_5250 text(@NotNull LineColor lineColor) {
        class_5250 class_52502 = lineColor.getName();
        return class_52502.method_27692(switch (lineColor) {
            case LineColor.WHITE -> class_124.field_1068;
            case LineColor.YELLOW -> class_124.field_1054;
            default -> class_124.field_1080;
        });
    }

    public static class_5250 text(@NotNull LineType lineType) {
        return lineType.getName();
    }

    @Contract(pure=true)
    public boolean mayConnect() {
        return this.whetherConnected.compareTo(WhetherConnected.MAY_CONNECT) >= 0;
    }

    @ApiStatus.AvailableSince(value="0.2.4")
    @Contract(pure=true)
    public boolean sureConnect() {
        return this.whetherConnected == WhetherConnected.CONNECTED;
    }

    public RoadConnectionState or(RoadConnectionState state) {
        return RoadConnectionState.or(this, state);
    }

    @Override
    public int compareTo(@NotNull RoadConnectionState o) {
        return this.whetherConnected.compareTo(o.whetherConnected);
    }

    @Contract(value="_ -> new")
    public RoadConnectionState createWithOffset(LineOffset lineOffset) {
        return new RoadConnectionState(this.whetherConnected, this.lineColor, this.direction, this.lineType, lineOffset);
    }

    @Contract(pure=true)
    @ApiStatus.AvailableSince(value="1.1.0")
    public class_2350 offsetDirection() {
        return this.lineOffset == null ? null : this.lineOffset.offsetDirection();
    }

    @Contract(pure=true)
    @ApiStatus.AvailableSince(value="1.1.0")
    public int offsetLevel() {
        return this.lineOffset == null ? 0 : this.lineOffset.level();
    }

    public static enum WhetherConnected implements class_3542
    {
        NOT_CONNECTED("not_connected"),
        MAY_CONNECT("may_connect"),
        CONNECTED("connected");

        private final String id;

        private WhetherConnected(String id) {
            this.id = id;
        }

        public String method_15434() {
            return this.id;
        }
    }
}

