/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.block.abstractions;

import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.paw.block.abstractions.IRotatableBlock;
import de.mrjulsen.paw.util.ModMath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2383;
import net.minecraft.class_241;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public abstract class AbstractRotatableBlock
extends class_2248
implements IRotatableBlock {
    protected static final float EPSILON = 1.0E-6f;
    public static final int ROTATIONS = 2;
    public static final int ROTATION_OFFSET = 1;
    public static final int MAX_ROTATION_INDEX = 2;
    public static final int MIN_ROTATION_INDEX = -2;
    public static final int ROTATION_STEPS_PER_SIDE = 4;
    public static final int TOTAL_ROTATION_STEPS = 16;
    public static final int PROPERTY_MAX_ROTATION_INDEX = 3;
    public static final int PROPERTY_BASE_ROTATION_INDEX = 1;
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2758 ROTATION = class_2758.method_11867((String)"rotation", (int)0, (int)3);
    private final Map<Integer, ShapeCacheEntry> shapes = new ConcurrentHashMap<Integer, ShapeCacheEntry>();

    public AbstractRotatableBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(1)));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_3965 checkClickedFace(class_1937 level, class_1657 player, class_3965 hit) {
        class_2338 pos = hit.method_17777();
        class_2680 state = level.method_8320(pos);
        class_2350 targetDir = hit.method_17780();
        if (targetDir.method_10166() != class_2350.class_2351.field_11052) {
            class_241[] points = this.getCubeCorners(state, (class_1922)level, pos, null);
            for (int i = 0; i < points.length; ++i) {
                class_241 pointA = points[i];
                class_241 pointB = points[(i + 1) % points.length];
                class_2350 dir = switch (i) {
                    case 1 -> class_2350.field_11034;
                    case 2 -> class_2350.field_11035;
                    case 3 -> class_2350.field_11039;
                    default -> class_2350.field_11043;
                };
                float minX = Math.min(pointA.field_1343, pointB.field_1343);
                float minZ = Math.min(pointA.field_1342, pointB.field_1342);
                float maxX = Math.max(pointA.field_1343, pointB.field_1343);
                float maxZ = Math.max(pointA.field_1342, pointB.field_1342);
                class_243 clicked = hit.method_17784().method_1020(MathUtils.blockPosToVec3((class_2338)pos));
                if (!(clicked.field_1352 >= (double)minX) || !(clicked.field_1352 <= (double)maxX) || !(clicked.field_1350 >= (double)minZ) || !(clicked.field_1350 <= (double)maxZ)) continue;
                targetDir = dir;
                break;
            }
        }
        return hit.method_17779(targetDir);
    }

    public class_2680 method_9598(class_2680 pState, class_2470 pRotation) {
        return (class_2680)pState.method_11657((class_2769)FACING, (Comparable)pRotation.method_10503((class_2350)pState.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 pState, class_2415 pMirror) {
        return pState.method_26186(pMirror.method_10345((class_2350)pState.method_11654((class_2769)FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder);
        pBuilder.method_11667(new class_2769[]{FACING, ROTATION});
    }

    public class_2680 method_9605(class_1750 context) {
        class_2350 direction = context.method_8038();
        class_2338 clickPos = context.method_8037().method_10093(direction.method_10153());
        class_1937 level = context.method_8045();
        class_2680 clickedState = level.method_8320(clickPos);
        class_2680 state = super.method_9564();
        if (clickedState.method_26204() instanceof AbstractRotatableBlock && direction.method_10166() == class_2350.class_2351.field_11052) {
            state = (class_2680)((class_2680)state.method_11657((class_2769)FACING, (Comparable)((class_2350)clickedState.method_11654((class_2769)FACING)))).method_11657((class_2769)ROTATION, (Comparable)((Integer)clickedState.method_11654((class_2769)ROTATION)));
        } else {
            int rot = class_3532.method_15357((double)((double)((180.0f + context.method_8044()) * 16.0f / 360.0f) + 0.5)) & 0xF;
            int steps = 4;
            class_2350 dir = class_2350.method_10139((int)((rot + 2) / 4));
            state = (class_2680)((class_2680)state.method_11657((class_2769)FACING, (Comparable)dir)).method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(3 - (rot + 2) % 4));
        }
        return state;
    }

    private ShapeCacheEntry getShapeData(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.shapes.computeIfAbsent(this.shapeHash(level, pos, state), x -> this.calcShape(state, level, pos, context));
    }

    protected int shapeHash(class_1922 level, class_2338 pos, class_2680 state) {
        return state.hashCode();
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.getShapeData(state, level, pos, context).shape();
    }

    @Override
    public class_265 getBaseShape(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return class_259.method_1077();
    }

    public class_241[] getCubeCorners(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.getShapeData(state, level, pos, context).corners();
    }

    @Override
    public float getRelativeYRotation(class_2680 state) {
        return AbstractRotatableBlock.rotationOf(AbstractRotatableBlock.propertyIndexToRotIndex((Integer)state.method_11654((class_2769)ROTATION)));
    }

    @Override
    public float getYRotation(class_2680 state) {
        return this.rotationOfFacingDirection(state) + this.getRelativeYRotation(state);
    }

    public float rotationOfFacingDirection(class_2680 state) {
        return switch ((class_2350)state.method_11654((class_2769)FACING)) {
            case class_2350.field_11034 -> 270.0f;
            case class_2350.field_11035 -> 180.0f;
            case class_2350.field_11039 -> 90.0f;
            default -> 0.0f;
        };
    }

    @Override
    public class_241 rotatedPivotPoint(class_2680 state) {
        return ModMath.rotateY(this.getRotationPivotPoint(state), this.rotationOfFacingDirection(state)).method_35585(0.5f);
    }

    private ShapeCacheEntry calcShape(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        class_265 base = this.getBaseShape(state, level, pos, context);
        float angle = -this.getRelativeYRotation(state);
        class_241 pivot = this.rotatedPivotPoint(state);
        class_241 offset = this.getOffset(state);
        List aabbs = base.method_1090();
        ArrayList<class_265> shapes = new ArrayList<class_265>();
        class_241[] finalCorners = new class_241[]{};
        for (class_238 aabb : aabbs) {
            class_241[] corners = AbstractRotatableBlock.rotateCorners(angle, 0.0625f, pivot, aabb, offset);
            if (finalCorners.length <= 0) {
                finalCorners = corners;
            }
            List<class_241[]> rectangles = AbstractRotatableBlock.approximateSquare(corners, angle, 0.0625f);
            for (class_241[] rect : rectangles) {
                shapes.add(class_2248.method_9541((double)(rect[0].field_1343 * 16.0f), (double)(aabb.field_1322 * 16.0), (double)(rect[0].field_1342 * 16.0f), (double)((rect[1].field_1343 + 0.0625f) * 16.0f), (double)(aabb.field_1325 * 16.0), (double)(rect[1].field_1342 * 16.0f)));
            }
        }
        return new ShapeCacheEntry(class_259.method_17786((class_265)class_259.method_1073(), (class_265[])((class_265[])shapes.toArray(class_265[]::new))).method_1097(), finalCorners);
    }

    public static class_241[] rotateCorners(float angle, float minSize, class_241 pivotPoint, class_238 src, class_241 offset) {
        class_241[] square = new class_241[]{new class_241((float)src.field_1323, (float)src.field_1321), new class_241((float)src.field_1320, (float)src.field_1321), new class_241((float)src.field_1320, (float)src.field_1324), new class_241((float)src.field_1323, (float)src.field_1324)};
        float radians = (float)Math.toRadians(angle);
        class_241[] rotatedSquare = new class_241[4];
        for (int i = 0; i < 4; ++i) {
            class_241 v = square[i];
            if (Math.abs(angle) > 1.0E-6f) {
                v = AbstractRotatableBlock.rotatePointAroundPivot(v, pivotPoint, radians);
            }
            rotatedSquare[i] = v = v.method_35586(offset);
        }
        return rotatedSquare;
    }

    public static List<class_241[]> approximateSquare(class_241[] rotatedCorners, float angle, float minSize) {
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        for (class_241 point : rotatedCorners) {
            if (point.field_1343 < minX) {
                minX = point.field_1343;
            }
            if (point.field_1342 < minY) {
                minY = point.field_1342;
            }
            if (point.field_1343 > maxX) {
                maxX = point.field_1343;
            }
            if (!(point.field_1342 > maxY)) continue;
            maxY = point.field_1342;
        }
        ArrayList<class_241[]> rectangles = new ArrayList<class_241[]>();
        if (Math.abs(angle) < 1.0E-6f) {
            rectangles.add(new class_241[]{new class_241(minX, minY), new class_241(maxX, maxY)});
            return rectangles;
        }
        for (float x = minX; x < maxX; x += minSize) {
            for (float y = minY; y < maxY; y += minSize) {
                class_241 rectBottomLeft = new class_241(x, y);
                class_241 rectTopRight = new class_241(x + minSize, y + minSize);
                if (!AbstractRotatableBlock.isRectangleIntersectingPolygon(rotatedCorners, rectBottomLeft, rectTopRight)) continue;
                rectangles.add(new class_241[]{rectBottomLeft, new class_241(rectBottomLeft.field_1343, rectTopRight.field_1342), rectTopRight, new class_241(rectTopRight.field_1343, rectBottomLeft.field_1342)});
            }
        }
        return rectangles;
    }

    private static class_241 rotatePointAroundPivot(class_241 point, class_241 pivot, float radians) {
        float translatedX = point.field_1343 - pivot.field_1343;
        float translatedY = point.field_1342 - pivot.field_1342;
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        float rotatedX = translatedX * cos - translatedY * sin;
        float rotatedY = translatedX * sin + translatedY * cos;
        return new class_241(rotatedX + pivot.field_1343, rotatedY + pivot.field_1342);
    }

    private static boolean isRectangleIntersectingPolygon(class_241[] polygon, class_241 rectBottomLeft, class_241 rectTopRight) {
        class_241[] rectPoints;
        for (class_241 point : rectPoints = new class_241[]{rectBottomLeft, new class_241(rectBottomLeft.field_1343, rectTopRight.field_1342), rectTopRight, new class_241(rectTopRight.field_1343, rectBottomLeft.field_1342)}) {
            if (!AbstractRotatableBlock.isPointInPolygon(polygon, point)) continue;
            return true;
        }
        for (int i = 0; i < polygon.length; ++i) {
            class_241 p1 = polygon[i];
            class_241 p2 = polygon[(i + 1) % polygon.length];
            for (int j = 0; j < rectPoints.length; ++j) {
                class_241 r1 = rectPoints[j];
                class_241 r2 = rectPoints[(j + 1) % rectPoints.length];
                if (!AbstractRotatableBlock.doLinesIntersect(p1, p2, r1, r2)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean doLinesIntersect(class_241 p1, class_241 p2, class_241 q1, class_241 q2) {
        float o1 = AbstractRotatableBlock.orientation(p1, p2, q1);
        float o2 = AbstractRotatableBlock.orientation(p1, p2, q2);
        float o3 = AbstractRotatableBlock.orientation(q1, q2, p1);
        float o4 = AbstractRotatableBlock.orientation(q1, q2, p2);
        return o1 != o2 && o3 != o4;
    }

    private static float orientation(class_241 p, class_241 q, class_241 r) {
        float val = (q.field_1342 - p.field_1342) * (r.field_1343 - q.field_1343) - (q.field_1343 - p.field_1343) * (r.field_1342 - q.field_1342);
        if (Math.abs(val) < 1.0E-6f) {
            return 0.0f;
        }
        return val > 0.0f ? 1.0f : 2.0f;
    }

    private static boolean isPointInPolygon(class_241[] polygon, class_241 point) {
        int crossings = 0;
        for (int i = 0; i < polygon.length; ++i) {
            float t;
            boolean cond2;
            class_241 v1 = polygon[i];
            class_241 v2 = polygon[(i + 1) % polygon.length];
            boolean cond1 = v1.field_1342 <= point.field_1342 + 1.0E-6f && point.field_1342 + 1.0E-6f < v2.field_1342;
            boolean bl = cond2 = v2.field_1342 <= point.field_1342 + 1.0E-6f && point.field_1342 + 1.0E-6f < v1.field_1342;
            if (!cond1 && !cond2 || !(point.field_1343 < v1.field_1343 + (t = (point.field_1342 - v1.field_1342) / (v2.field_1342 - v1.field_1342)) * (v2.field_1343 - v1.field_1343))) continue;
            ++crossings;
        }
        return crossings % 2 != 0;
    }

    public static class_241[] getRotatedSquare(float angle, class_241 pivotPoint, class_238 src) {
        class_241[] square = new class_241[]{new class_241((float)src.field_1323, (float)src.field_1321), new class_241((float)src.field_1320, (float)src.field_1321), new class_241((float)src.field_1320, (float)src.field_1324), new class_241((float)src.field_1323, (float)src.field_1324)};
        float radians = (float)Math.toRadians(angle);
        class_241[] rotatedSquare = new class_241[4];
        for (int i = 0; i < 4; ++i) {
            rotatedSquare[i] = AbstractRotatableBlock.rotatePointAroundPivot(square[i], pivotPoint, radians);
        }
        return rotatedSquare;
    }

    protected static final float m(int rotIdx) {
        return (float)rotIdx / 2.0f;
    }

    protected static final int propertyIndexToRotIndex(int prop) {
        return prop - 1;
    }

    protected static final float rotationOf(int rotationIndex) {
        return (float)Math.toDegrees(Math.atan(AbstractRotatableBlock.m(rotationIndex)));
    }

    protected static final int normalizedPropertyRotationIndex(class_2680 state) {
        int prop = (Integer)state.method_11654((class_2769)ROTATION);
        return prop - 1;
    }

    protected class_2338 relativeTo(class_1920 level, class_2680 state, class_2338 pos, class_2350 direction) {
        class_2338 result = pos.method_10093(direction);
        if (level.method_8320(pos).method_27852(state.method_26204()) && AbstractRotatableBlock.normalizedPropertyRotationIndex(state) >= 2) {
            result = result.method_10093(direction.method_10160());
        }
        return result;
    }

    protected class_2338 getSupportBlockPos(class_1922 level, class_2338 pos, class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 relativePos = pos.method_10093(direction.method_10153());
        if (level.method_8320(pos).method_26204() instanceof AbstractRotatableBlock && this.getRelativeYRotation(state) > 30.0f) {
            relativePos = relativePos.method_10093(direction.method_10170());
        }
        return relativePos;
    }

    private record ShapeCacheEntry(class_265 shape, class_241[] corners) {
    }
}

