/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.block.abstractions;

import de.mrjulsen.mcdragonlib.config.ECachingPriority;
import de.mrjulsen.mcdragonlib.data.MapCache;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.paw.block.abstractions.AbstractRotatableBlock;
import de.mrjulsen.paw.block.extended.BlockPlaceContextExtension;
import de.mrjulsen.paw.data.BlockModificationData;
import java.util.Objects;
import net.minecraft.class_1750;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3620;
import net.minecraft.class_4970;

public abstract class AbstractRotatedConnectableBlock
extends AbstractRotatableBlock {
    public static final int DEFAULT_SEGMENT = 1;
    public static final class_2758 MULTIPART_SEGMENT = AbstractRotatedConnectableBlock.createMultipartSegmentsProperty();
    private final MapCache<class_241, class_2680, class_2680> offsetCache = AbstractRotatedConnectableBlock.createOffsetCache();

    public AbstractRotatedConnectableBlock(class_4970.class_2251 properties) {
        super(properties.method_31710(class_3620.field_16005));
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)MULTIPART_SEGMENT, (Comparable)Integer.valueOf(1)));
    }

    public static MapCache<class_241, class_2680, class_2680> createOffsetCache() {
        return new MapCache(c -> {
            int rawRotationIndex = AbstractRotatedConnectableBlock.normalizedPropertyRotationIndex(c);
            int rotationIndex = Math.abs(rawRotationIndex) + 1;
            int currentPart = (Integer)c.method_11654((class_2769)MULTIPART_SEGMENT);
            float multiplier = 1.0f / (float)rotationIndex * (float)(MathUtils.clamp((int)currentPart, (int)1, (int)rotationIndex) - 1);
            return switch ((class_2350)c.method_11654((class_2769)FACING)) {
                case class_2350.field_11039 -> new class_241(0.0f, 1.0f).method_35582(multiplier);
                case class_2350.field_11034 -> new class_241(0.0f, -1.0f).method_35582(multiplier);
                case class_2350.field_11035 -> new class_241(1.0f, 0.0f).method_35582(multiplier);
                default -> new class_241(-1.0f, 0.0f).method_35582(multiplier);
            };
        }, state -> Objects.hash(state.method_11656().values().toArray(Object[]::new)), ECachingPriority.ALWAYS);
    }

    public static class_2758 createMultipartSegmentsProperty() {
        return class_2758.method_11867((String)"multipart_segment", (int)1, (int)2);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder);
        pBuilder.method_11667(new class_2769[]{MULTIPART_SEGMENT});
    }

    protected int maxSegments(class_2680 state) {
        int rotationIndex = Math.abs(AbstractRotatedConnectableBlock.normalizedPropertyRotationIndex(state)) + 1;
        if (rotationIndex >= 3) {
            rotationIndex = 1;
        }
        return rotationIndex;
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        BlockPlaceContextExtension ctxExt = (BlockPlaceContextExtension)context;
        class_2680 state = super.method_9605(context);
        class_2680 clickedOnState = ctxExt.getPlacedOnState();
        class_2350 clickedFace = context.method_8038();
        if (this.canConnect(context.method_8045(), state, context.method_8037(), clickedOnState, ctxExt.getPlacedOnPos()) && ((class_2350)clickedOnState.method_11654((class_2769)FACING)).method_10166() == clickedFace.method_10166()) {
            int rotationIndex = this.maxSegments(clickedOnState);
            state = (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)MULTIPART_SEGMENT, (Comparable)Integer.valueOf(clickedFace == clickedOnState.method_11654((class_2769)FACING) ? (Integer)clickedOnState.method_11654((class_2769)MULTIPART_SEGMENT) % rotationIndex + 1 : Math.abs(((Integer)clickedOnState.method_11654((class_2769)MULTIPART_SEGMENT) - 2) % rotationIndex) + 1))).method_11657((class_2769)FACING, (Comparable)((class_2350)clickedOnState.method_11654((class_2769)FACING)))).method_11657((class_2769)ROTATION, (Comparable)((Integer)clickedOnState.method_11654((class_2769)ROTATION)));
        }
        return state;
    }

    protected boolean canConnect(class_1937 level, class_2680 state, class_2338 pos, class_2680 otherState, class_2338 otherPos) {
        return state.method_27852(otherState.method_26204());
    }

    @Override
    public class_241 getOffset(class_2680 state) {
        return (class_241)this.offsetCache.get((Object)state, (Object)state);
    }

    @Override
    public class_2350.class_2351 transformOnAxis(class_2680 state) {
        return ((class_2350)state.method_11654((class_2769)FACING)).method_10166();
    }

    @Override
    public BlockModificationData onPlaceOnRotatedBlock(class_1750 context, class_2680 clickedState, class_2338 clickedBlockPos) {
        boolean clickedOnFront;
        BlockModificationData value = super.onPlaceOnRotatedBlock(context, clickedState, clickedBlockPos);
        int rotationValue = AbstractRotatedConnectableBlock.normalizedPropertyRotationIndex(clickedState);
        class_2350 clickedFace = context.method_8038();
        boolean bl = clickedOnFront = clickedFace == clickedState.method_11654((class_2769)FACING);
        if (value == null && clickedFace != null && rotationValue != 0 && (Integer)clickedState.method_11654((class_2769)MULTIPART_SEGMENT) == 1 + (clickedOnFront ^ rotationValue < 0 ? 1 : 0) && clickedFace.method_10166() == this.transformOnAxis(clickedState)) {
            return new BlockModificationData(context.method_8037().method_10093(rotationValue > 0 ? clickedFace.method_10160() : clickedFace.method_10170()), clickedFace);
        }
        return value;
    }

    @Override
    public BlockModificationData onPlaceOnOtherRotatedBlock(BlockModificationData currentModification, class_1750 context, class_2680 clickedState, class_2338 clickedBlockPos) {
        int rotationValue = AbstractRotatedConnectableBlock.normalizedPropertyRotationIndex(clickedState);
        class_2350 clickedFace = context.method_8038();
        if (clickedFace != null && rotationValue < 0 && !(clickedState.method_26204() instanceof AbstractRotatedConnectableBlock)) {
            return new BlockModificationData(context.method_8037().method_10093(clickedFace.method_10170()), clickedFace);
        }
        return currentModification;
    }

    @Override
    protected class_2338 relativeTo(class_1920 level, class_2680 state, class_2338 pos, class_2350 direction) {
        class_2338 result = pos.method_10093(direction);
        if (level.method_8320(pos).method_27852(state.method_26204())) {
            int rot = AbstractRotatedConnectableBlock.normalizedPropertyRotationIndex(state);
            if (rot >= 2) {
                result = result.method_10093(direction.method_10160());
            } else if (rot > 0 && (Integer)state.method_11654((class_2769)MULTIPART_SEGMENT) == 1) {
                result = result.method_10093(direction.method_10160());
            } else if (rot < 0 && (Integer)state.method_11654((class_2769)MULTIPART_SEGMENT) == 2) {
                result = result.method_10093(direction.method_10170());
            }
        }
        return result;
    }

    public static final class BasicRotatedConnectableBlock
    extends AbstractRotatedConnectableBlock {
        public BasicRotatedConnectableBlock(class_4970.class_2251 properties) {
            super(properties);
        }
    }
}

