/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.blockentity;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import de.mrjulsen.wires.WireClientNetwork;
import de.mrjulsen.wires.WireCollision;
import de.mrjulsen.wires.WireNetwork;
import de.mrjulsen.wires.debug.WireDebugRenderer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.molang.MolangParser;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PantographBlockEntity
extends SmartBlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation ANIM_WIRE_CONTACT = RawAnimation.begin().thenPlayAndHold("wire_contact");
    private static final RawAnimation ANIM_EXPAND = RawAnimation.begin().thenPlay("expand").thenPlayAndHold("wire_contact");
    private static final RawAnimation ANIM_COLLAPSE = RawAnimation.begin().thenPlayAndHold("collapse");
    public static final String NBT_EXPANDABLE = "IsExpandable";
    public static final double MAX_HEIGHT = 3.6;
    public static final double MAX_HEIGHT_PIXELS = 57.6;
    public static final double MIN_HEIGHT_PIXELS = 13.0625;
    public static final double MIN_HEIGHT = 0.81640625;
    public static final double FORWARD_OFFSET = 0.25;
    public static final double MAX_WIDTH = 2.5;
    public static final double DELTA_HEIGHT = 2.78359375;
    public static final double DELTA_HEIGHT_PIXELS = 44.5375;
    public static final double ARM_LENGTH = 36.0;
    public static final double ARM_LENGTH_DOUBLE_POW = 2.0 * Math.pow(36.0, 2.0);
    public static final double BASE_ANGLE = Math.toDegrees(Math.acos((ARM_LENGTH_DOUBLE_POW - Math.pow(1.5, 2.0)) / ARM_LENGTH_DOUBLE_POW));
    public static final double START_ANGLE = Math.toDegrees(Math.acos((ARM_LENGTH_DOUBLE_POW - Math.pow(1.7815, 2.0)) / ARM_LENGTH_DOUBLE_POW));
    public static final Vector3d BASE_UP_VECTOR = new Vector3d(0.0, 1.0, 0.0).normalize().mul(3.6);
    public static final Vector3d BASE_RIGHT_VECTOR = new Vector3d(1.0, 0.0, 0.0).normalize().mul(1.25);
    public static final Vector3d BASE_FORWARD_VECTOR = new Vector3d(0.0, 0.0, 1.0).normalize().mul(0.25);
    private Vector3d currentPos;
    private UnaryOperator<Vector3d> rotationFunc = v -> v;
    private double catenaryWireHeight = 2.78359375;
    private final LerpedFloat animationTransition = LerpedFloat.linear().startWithValue(this.catenaryWireHeight);
    private boolean expanded = false;
    private boolean stateChanged = false;
    private boolean expandable = false;
    public Vector3f debug_wireCollisionA = new Vector3f();
    public Vector3f debug_wireCollisionB = new Vector3f();
    public double debug_hitHeight = 0.0;

    public PantographBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public Vector3d getCurrentPos() {
        return this.currentPos;
    }

    public Vector3d rotate(Vector3d vec) {
        return (Vector3d)this.rotationFunc.apply(vec);
    }

    public void toggleExpandable() {
        this.setExpandable(!this.isExpandable());
    }

    public void setExpandable(boolean b) {
        this.expandable = b;
        this.notifyUpdate();
    }

    public boolean isExpandable() {
        return this.expandable;
    }

    protected void setExpanded(boolean b) {
        this.stateChanged = this.expanded != b;
        this.expanded = b;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10556(NBT_EXPANDABLE, this.isExpandable());
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.setExpandable(tag.method_10577(NBT_EXPANDABLE));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> {
            if (state.getController().getCurrentRawAnimation() == null && this.isExpanded()) {
                state.setAnimation(ANIM_WIRE_CONTACT);
            }
            if (this.stateChanged) {
                if (this.isExpanded()) {
                    state.setAnimation(ANIM_EXPAND);
                } else {
                    state.setAnimation(ANIM_COLLAPSE);
                }
                this.stateChanged = false;
            }
            return PlayState.CONTINUE;
        }).setAnimationSpeed(0.25)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public class_238 getRenderBoundingBox() {
        class_238 aabb = new class_238(this.field_11867.method_10069(-2, 0, -2));
        return aabb.method_1012(4.0, 4.0, 4.0);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void tick() {
        this.setExpanded(this.isExpandable());
        this.commonTick();
    }

    public void contraptionTick() {
        this.commonTick();
    }

    protected void commonTick() {
        super.tick();
        this.animationTransition.tickChaser();
    }

    public void updateContraptionValues(Vector3d worldPos, UnaryOperator<Vector3d> rotationFunc) {
        this.currentPos = worldPos;
        this.rotationFunc = rotationFunc;
        Vector3d currPos = this.currentPos == null ? new Vector3d((double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260()) : this.currentPos;
        Vector3d upVec = this.rotationFunc == null ? BASE_UP_VECTOR : (Vector3d)this.rotationFunc.apply(BASE_UP_VECTOR);
        Vector3d rightVec = this.rotationFunc == null ? BASE_RIGHT_VECTOR : (Vector3d)this.rotationFunc.apply(BASE_RIGHT_VECTOR);
        Vector3d forwardVec = this.rotationFunc == null ? BASE_FORWARD_VECTOR : (Vector3d)this.rotationFunc.apply(BASE_FORWARD_VECTOR);
        currPos.add((Vector3dc)forwardVec);
        this.catenaryWireHeight = this.calculateWireContact(currPos, upVec, rightVec);
        this.setExpanded(this.expandable && this.catenaryWireHeight >= 0.0);
        double d = this.catenaryWireHeight = this.catenaryWireHeight < 0.0 ? 0.0 : this.catenaryWireHeight;
        if (this.expanded) {
            this.animationTransition.chase(this.catenaryWireHeight, 1.0, LerpedFloat.Chaser.LINEAR);
        }
    }

    public void applyMolangVariables() {
        MolangParser.INSTANCE.setValue("query.height_percentage", () -> {
            double p = 0.3592478248666854 * (double)this.animationTransition.getValue(AnimationTickHolder.getPartialTicks((class_1936)this.field_11863));
            return p;
        });
        MolangParser.INSTANCE.setValue("query.func", () -> {
            double p = MolangParser.INSTANCE.getVariable("query.height_percentage").get();
            return PantographBlockEntity.getArmAngle(p);
        });
        MolangParser.INSTANCE.setMemoizedValue("query.head_rotation", () -> 0.0);
    }

    public static final double getArmAngle(double heightPercentage) {
        return Math.toDegrees(Math.acos((ARM_LENGTH_DOUBLE_POW - Math.pow((heightPercentage + 0.04) * 44.5375, 2.0)) / ARM_LENGTH_DOUBLE_POW));
    }

    private double calculateWireContact(Vector3d worldPosition, Vector3d upVec, Vector3d rightVec) {
        if (WireDebugRenderer.enabled()) {
            this.debug_hitHeight = 0.0;
            this.debug_wireCollisionA = new Vector3f();
            this.debug_wireCollisionB = new Vector3f();
        }
        Vector3d pA = new Vector3d((Vector3dc)worldPosition).sub((Vector3dc)rightVec);
        Vector3d pB = new Vector3d((Vector3dc)worldPosition).add((Vector3dc)rightVec);
        Iterator<class_2338> poses = PantographBlockEntity.findIntersectingBlocks(pA, pB, upVec).iterator();
        double result = 3.6;
        boolean hasWire = false;
        while (poses.hasNext()) {
            class_2338 pos = poses.next();
            if (!WireClientNetwork.get(this.field_11863).hasConnectionsInBlock(pos)) continue;
            for (WireCollision.WireBlockCollision c : WireClientNetwork.get(this.field_11863).getCollisionsInBlock(pos)) {
                Vector3d d = PantographBlockEntity.checkWireIntersection(new Vector3d((double)c.absA().x, (double)c.absA().y, (double)c.absA().z), new Vector3d((double)c.absB().x, (double)c.absB().y, (double)c.absB().z), pA, pB, upVec);
                if (d == null) continue;
                double rY = d.y - worldPosition.y;
                Vector3d scaledUp = new Vector3d((Vector3dc)upVec).normalize().mul(rY);
                double f = new Vector3d(scaledUp.x(), 0.0, scaledUp.z()).length();
                rY = Math.sqrt(Math.pow(f, 2.0) + Math.pow(rY, 2.0));
                if (rY < result) {
                    result = rY;
                    if (WireDebugRenderer.enabled()) {
                        this.debug_hitHeight = rY;
                        this.debug_wireCollisionA = new Vector3f(c.absA().x, c.absA().y, c.absA().z);
                        this.debug_wireCollisionB = new Vector3f(c.absB().x, c.absB().y, c.absB().z);
                    }
                }
                hasWire = true;
            }
        }
        return hasWire ? result : -1.0;
    }

    private double calculateWireContactSlope(Vector3d worldPosition, Vector3d upVec, Vector3d rightVec) {
        Vector3d pA = new Vector3d((Vector3dc)worldPosition).sub((Vector3dc)rightVec);
        Vector3d pB = new Vector3d((Vector3dc)worldPosition).add((Vector3dc)rightVec);
        for (class_2338 pos : PantographBlockEntity.findIntersectingBlocks(pA, pB, upVec)) {
            if (!WireClientNetwork.get(this.field_11863).hasConnectionsInBlock(pos)) continue;
            for (WireCollision.WireBlockCollision c : WireNetwork.get(this.field_11863).getCollisionsInBlock(pos)) {
                Vector3d d = PantographBlockEntity.checkWireIntersection(new Vector3d((double)c.absA().x, (double)c.absA().y, (double)c.absA().z), new Vector3d((double)c.absB().x, (double)c.absB().y, (double)c.absB().z), pA, pB, upVec);
                if (d == null) continue;
                return PantographBlockEntity.slope(new Vector3d((double)c.absA().x, (double)c.absA().y, (double)c.absA().z), new Vector3d((double)c.absB().x, (double)c.absB().y, (double)c.absB().z));
            }
        }
        return 0.0;
    }

    protected static Vector3d checkWireIntersection(Vector3d c, Vector3d d, Vector3d a, Vector3d b, Vector3d direction) {
        Vector3d AB = new Vector3d((Vector3dc)b).sub((Vector3dc)a);
        Vector3d vDir = new Vector3d((Vector3dc)direction);
        Vector3d normal = new Vector3d();
        AB.cross((Vector3dc)vDir, normal);
        Vector3d CD = new Vector3d((Vector3dc)d).sub((Vector3dc)c);
        double numerator = normal.dot((Vector3dc)new Vector3d((Vector3dc)a).sub((Vector3dc)c));
        double denominator = normal.dot((Vector3dc)CD);
        if (Math.abs(denominator) < 1.0E-8) {
            return null;
        }
        double t = numerator / denominator;
        if (t < 0.0 || t > 1.0) {
            return null;
        }
        Vector3d intersection = new Vector3d((Vector3dc)c).add((Vector3dc)CD.mul(t));
        Vector3d AP = new Vector3d((Vector3dc)intersection).sub((Vector3dc)a);
        double u = AP.dot((Vector3dc)AB) / AB.lengthSquared();
        double v = AP.dot((Vector3dc)vDir) / vDir.lengthSquared();
        if (u < 0.0 || u > 1.0 || v < 0.0 || v > 1.0) {
            return null;
        }
        return intersection;
    }

    private static double slope(Vector3d pointA, Vector3d pointB) {
        Vector3d direction = new Vector3d();
        pointB.sub((Vector3dc)pointA, direction);
        double projectionXY = Math.sqrt(direction.x * direction.x + direction.y * direction.y);
        double slopeAngle = Math.atan2(direction.z, projectionXY);
        return Math.toDegrees(slopeAngle) + 90.0;
    }

    protected static Set<class_2338> findIntersectingBlocks(Vector3d a, Vector3d b, Vector3d v) {
        HashSet<class_2338> intersections = new HashSet<class_2338>();
        Vector3d ab = new Vector3d((Vector3dc)b).sub((Vector3dc)a);
        Vector3d normal = new Vector3d((Vector3dc)ab).cross((Vector3dc)v);
        Vector3d min = new Vector3d((Vector3dc)a);
        Vector3d max = new Vector3d((Vector3dc)a);
        min.min((Vector3dc)b).min((Vector3dc)new Vector3d((Vector3dc)a).add((Vector3dc)v)).min((Vector3dc)new Vector3d((Vector3dc)b).add((Vector3dc)v));
        max.max((Vector3dc)b).max((Vector3dc)new Vector3d((Vector3dc)a).add((Vector3dc)v)).max((Vector3dc)new Vector3d((Vector3dc)b).add((Vector3dc)v));
        int x = (int)Math.floor(min.x);
        while ((double)x <= Math.ceil(max.x)) {
            int y = (int)Math.floor(min.y);
            while ((double)y <= Math.ceil(max.y)) {
                int z = (int)Math.floor(min.z);
                while ((double)z <= Math.ceil(max.z)) {
                    Vector3d blockCenter = new Vector3d((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                    double distance = Math.abs(blockCenter.sub((Vector3dc)a, new Vector3d()).dot((Vector3dc)normal)) / normal.length();
                    if (distance <= Math.sqrt(3.0) / 2.0) {
                        intersections.add(new class_2338(x, y, z));
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return intersections;
    }
}

