/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.client.model;

import com.simibubi.create.foundation.utility.VecHelper;
import de.mrjulsen.paw.block.abstractions.IConicalShape;
import de.mrjulsen.paw.block.abstractions.IRotatableBlock;
import de.mrjulsen.paw.client.model.BakedModelExtension;
import de.mrjulsen.paw.client.model.ETransformationType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_5819;
import net.minecraft.class_777;

public class RotatedBlockModel
extends BakedModelExtension<class_1087> {
    public static final class_293 FORMAT = class_290.field_1590;
    public static final int VERTEX_STRIDE = FORMAT.method_1359();
    public static final int X_OFFSET = 0;
    public static final int Y_OFFSET = 1;
    public static final int Z_OFFSET = 2;

    public RotatedBlockModel(class_1087 originalModel) {
        super(originalModel);
    }

    @Override
    public List<class_777> method_4707(class_2680 state, class_2350 side, class_5819 rand) {
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof IRotatableBlock)) {
            return this.originalModel.method_4707(state, side, rand);
        }
        IRotatableBlock rot = (IRotatableBlock)class_22482;
        List templateQuads = this.originalModel.method_4707(state, side, rand);
        if (templateQuads.isEmpty()) {
            return templateQuads;
        }
        double hAngle = rot.getRelativeYRotation(state);
        class_241 pivot = rot.rotatedPivotPoint(state);
        class_241 offset = rot.getOffset(state);
        class_243 verticalOffset = new class_243(0.5, 0.25, 0.5).method_1023((double)pivot.field_1343, 0.0, (double)pivot.field_1342);
        int size = templateQuads.size();
        ArrayList<class_777> quads = new ArrayList<class_777>();
        for (int i = 0; i < size; ++i) {
            class_777 quad = RotatedBlockModel.clone((class_777)templateQuads.get(i));
            int[] vertexData = quad.method_3357();
            for (int j = 0; j < 4; ++j) {
                class_243 vec = RotatedBlockModel.getXYZ(vertexData, j);
                class_2248 class_22483 = state.method_26204();
                if (class_22483 instanceof IConicalShape) {
                    IConicalShape cone = (IConicalShape)class_22483;
                    class_241 coneTarget = cone.coneTarget(state);
                    class_241 coneOffset = cone.coneOffset(state);
                    double sX = -Math.signum(vec.field_1352 - (double)coneTarget.field_1343);
                    double sZ = -Math.signum(vec.field_1350 - (double)coneTarget.field_1342);
                    vec = vec.method_1031(sX * vec.field_1351 * (double)coneOffset.field_1343, 0.0, sZ * vec.field_1351 * (double)coneOffset.field_1342);
                }
                RotatedBlockModel.setXYZ(vertexData, j, this.transformVector(state, side, rand, rot, vec, hAngle, verticalOffset, quad.method_3359(), offset, pivot));
            }
            quads.add(quad);
        }
        return quads;
    }

    private class_243 transformVector(class_2680 state, class_2350 side, class_5819 rand, IRotatableBlock rot, class_243 v, double rotationAngle, class_243 verticalOffset, int flags, class_241 offset, class_241 pivot) {
        block11: {
            class_2350.class_2351 axis;
            ETransformationType transformationType;
            block12: {
                transformationType = ETransformationType.getByIndex(flags);
                axis = rot.transformOnAxis(state);
                if (axis == null) break block11;
                if (!transformationType.isScale()) break block12;
                switch (axis) {
                    case field_11048: {
                        double distance = v.method_18043(axis) - (double)pivot.field_1343;
                        if (transformationType != ETransformationType.SCALE_POSITIVE && transformationType != ETransformationType.SCALE_NEGATIVE || (!(distance > 0.0) || transformationType == ETransformationType.SCALE_POSITIVE) && (!(distance < 0.0) || transformationType == ETransformationType.SCALE_NEGATIVE)) {
                            double scaledDistance = distance * rot.getScaleForRotation(state);
                            v = new class_243((double)pivot.field_1343 + scaledDistance, v.field_1351, v.field_1350);
                        }
                        break block11;
                    }
                    case field_11051: {
                        double distance = v.method_18043(axis) - (double)pivot.field_1342;
                        if (transformationType != ETransformationType.SCALE_POSITIVE && transformationType != ETransformationType.SCALE_NEGATIVE || (!(distance > 0.0) || transformationType == ETransformationType.SCALE_POSITIVE) && (!(distance < 0.0) || transformationType == ETransformationType.SCALE_NEGATIVE)) {
                            double scaledDistance = distance * rot.getScaleForRotation(state);
                            v = new class_243(v.field_1352, v.field_1351, (double)pivot.field_1342 + scaledDistance);
                        }
                        break block11;
                    }
                    default: {
                        throw new IllegalArgumentException("The scaling axis for block " + String.valueOf(state.method_26204()) + " must be horizontal. " + String.valueOf(axis) + " is not allowed!");
                    }
                }
            }
            if (transformationType == ETransformationType.TRANSLATE) {
                switch (axis) {
                    case field_11048: {
                        double angleRadians = Math.toRadians(rot.getRelativeYRotation(state));
                        float h = 1.0f / (float)Math.cos(angleRadians);
                        v = new class_243(v.field_1352 + (double)((float)((class_2350)state.method_11654((class_2769)class_2383.field_11177)).method_10171().method_10181() * (1.0f - h)), v.field_1351, v.field_1350);
                        break;
                    }
                    case field_11051: {
                        double angleRadians = Math.toRadians(rot.getRelativeYRotation(state));
                        float h = 1.0f / (float)Math.cos(angleRadians);
                        v = new class_243(v.field_1352, v.field_1351, v.field_1350 + (double)((float)((class_2350)state.method_11654((class_2769)class_2383.field_11177)).method_10171().method_10181() * (1.0f - h)));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("The scaling axis for block " + String.valueOf(state.method_26204()) + " must be horizontal. " + String.valueOf(axis) + " is not allowed!");
                    }
                }
            }
        }
        v = v.method_1019(verticalOffset);
        v = VecHelper.rotateCentered((class_243)v, (double)rotationAngle, (class_2350.class_2351)class_2350.class_2351.field_11052);
        v = v.method_1020(verticalOffset);
        v = v.method_1031((double)offset.field_1343, 0.0, (double)offset.field_1342);
        return v;
    }

    public static class_777 clone(class_777 quad) {
        return new class_777(Arrays.copyOf(quad.method_3357(), quad.method_3357().length), quad.method_3359(), quad.method_3358(), quad.method_35788(), quad.method_24874());
    }

    public static class_243 getXYZ(int[] vertexData, int vertex) {
        float x = Float.intBitsToFloat(vertexData[vertex * VERTEX_STRIDE + 0]);
        float y = Float.intBitsToFloat(vertexData[vertex * VERTEX_STRIDE + 1]);
        float z = Float.intBitsToFloat(vertexData[vertex * VERTEX_STRIDE + 2]);
        return new class_243((double)x, (double)y, (double)z);
    }

    public static void setXYZ(int[] vertexData, int vertex, class_243 xyz) {
        vertexData[vertex * RotatedBlockModel.VERTEX_STRIDE + 0] = Float.floatToRawIntBits((float)xyz.field_1352);
        vertexData[vertex * RotatedBlockModel.VERTEX_STRIDE + 1] = Float.floatToRawIntBits((float)xyz.field_1351);
        vertexData[vertex * RotatedBlockModel.VERTEX_STRIDE + 2] = Float.floatToRawIntBits((float)xyz.field_1350);
    }
}

