/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.fabric.client.model.loaders;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.paw.fabric.client.model.loaders.MultipartObjModel;
import de.mrjulsen.paw.fabric.client.model.loaders.MultipartObjParser;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.obj.ObjMaterialLibrary;
import io.github.fabricators_of_create.porting_lib.models.obj.ObjTokenizer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;

public class MultipartObjLoader
implements ModelLoadingPlugin,
IGeometryLoader<MultipartObjModel> {
    public static final class_2960 ID = new class_2960("pantographsandwires", "multipart_obj");
    public static final MultipartObjLoader INSTANCE = new MultipartObjLoader();
    private final Map<MultipartObjModel.ModelSettings, MultipartObjModel> modelCache = Maps.newConcurrentMap();
    private final Map<class_2960, ObjMaterialLibrary> materialCache = Maps.newConcurrentMap();

    public void onInitializeModelLoader(ModelLoadingPlugin.Context pluginContext) {
        this.modelCache.clear();
        this.materialCache.clear();
    }

    public MultipartObjModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
        return this.readInternal(deserializationContext, jsonObject);
    }

    public MultipartObjModel readInternal(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        if (!modelContents.has("model")) {
            throw new JsonParseException("OBJ Loader requires a 'model' key that points to a valid .OBJ model.");
        }
        if (!modelContents.has("loader") || !modelContents.get("loader").getAsString().equals(ID.toString())) {
            throw new RuntimeException("Importing invalid model loader.");
        }
        String modelLocation = modelContents.get("model").getAsString();
        boolean automaticCulling = class_3518.method_15258((JsonObject)modelContents, (String)"automatic_culling", (boolean)true);
        boolean shadeQuads = class_3518.method_15258((JsonObject)modelContents, (String)"shade_quads", (boolean)true);
        boolean flipV = class_3518.method_15258((JsonObject)modelContents, (String)"flip_v", (boolean)false);
        boolean emissiveAmbient = class_3518.method_15258((JsonObject)modelContents, (String)"emissive_ambient", (boolean)true);
        String mtlOverride = class_3518.method_15253((JsonObject)modelContents, (String)"mtl_override", null);
        ArrayList<MultipartObjModel.SubModelSettings> subSettings = new ArrayList<MultipartObjModel.SubModelSettings>();
        if (modelContents.has("add")) {
            for (JsonElement element : class_3518.method_15261((JsonObject)modelContents, (String)"add")) {
                subSettings.add((MultipartObjModel.SubModelSettings)DragonLib.GSON.fromJson(element, MultipartObjModel.SubModelSettings.class));
            }
        }
        MultipartObjModel.ModelSettings settings = new MultipartObjModel.ModelSettings(new class_2960(modelLocation), automaticCulling, shadeQuads, flipV, emissiveAmbient, mtlOverride, subSettings);
        MultipartObjModel model = this.loadModel(settings);
        int i = 0;
        for (MultipartObjModel.SubModelSettings subModelSettings : settings.subSettings()) {
            ++i;
            MultipartObjModel subModel = subModelSettings.isJson() ? this.readSubModel(new class_2960(subModelSettings.model())) : this.loadModel(new MultipartObjModel.ModelSettings(new class_2960(subModelSettings.model()), automaticCulling, shadeQuads, flipV, emissiveAmbient, mtlOverride, List.of()));
            for (MultipartObjModel.ModelObject modelObject : subModel.getParts()) {
                MultipartObjModel.ModelGroup group = (MultipartObjModel.ModelGroup)modelObject;
                if (!group.settings.inheritable()) continue;
                String newName = "m" + i + "_" + modelObject.name();
                group = group.copy(subModelSettings, newName);
                model.addPart(group.name(), group);
            }
        }
        return model;
    }

    private static class_3300 getResourceManager() {
        return class_310.method_1551().method_1478();
    }

    private MultipartObjModel readSubModel(class_2960 location) {
        try {
            class_3298 resource = (class_3298)MultipartObjLoader.getResourceManager().method_14486(location).orElseThrow();
            InputStreamReader reader = new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8);
            JsonObject obj = class_3518.method_15255((Reader)reader);
            return this.readInternal(null, obj);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public MultipartObjModel loadModel(MultipartObjModel.ModelSettings settings) {
        return this.modelCache.computeIfAbsent(settings, data -> {
            MultipartObjModel multipartObjModel;
            class_3298 resource = (class_3298)MultipartObjLoader.getResourceManager().method_14486(settings.modelLocation()).orElseThrow();
            ObjTokenizer tokenizer = new ObjTokenizer(resource.method_14482());
            try {
                multipartObjModel = MultipartObjParser.parse(tokenizer, settings);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        tokenizer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Could not find OBJ model", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read OBJ model", e);
                }
            }
            tokenizer.close();
            return multipartObjModel;
        });
    }

    public ObjMaterialLibrary loadMaterialLibrary(class_2960 materialLocation) {
        return this.materialCache.computeIfAbsent(materialLocation, location -> {
            ObjMaterialLibrary objMaterialLibrary;
            class_3298 resource = (class_3298)MultipartObjLoader.getResourceManager().method_14486(location).orElseThrow();
            ObjTokenizer rdr = new ObjTokenizer(resource.method_14482());
            try {
                objMaterialLibrary = new ObjMaterialLibrary(rdr);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        rdr.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Could not find OBJ material library", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read OBJ material library", e);
                }
            }
            rdr.close();
            return objMaterialLibrary;
        });
    }
}

