/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.item;

import de.mrjulsen.paw.block.abstractions.ICatenaryWireConnector;
import de.mrjulsen.paw.config.ModServerConfig;
import de.mrjulsen.paw.item.AbstractWireType;
import de.mrjulsen.wires.SegmentControl;
import de.mrjulsen.wires.Wire;
import de.mrjulsen.wires.WireBatch;
import de.mrjulsen.wires.WireBuilder;
import de.mrjulsen.wires.WireCreationContext;
import de.mrjulsen.wires.block.IWireConnector;
import de.mrjulsen.wires.network.WireConnectionSyncData;
import de.mrjulsen.wires.render.WireRenderData;
import de.mrjulsen.wires.render.WireRenderPoint;
import de.mrjulsen.wires.util.Utils;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CatenaryWireType
extends AbstractWireType {
    private static final float HANG_FAC = 0.025f;
    private static final float THICKNESS = 0.03125f;

    public CatenaryWireType(class_2960 location) {
        super(location);
    }

    @Override
    public boolean isValidConnector(class_1920 level, class_2338 pos, IWireConnector connector) {
        return connector instanceof ICatenaryWireConnector;
    }

    @Override
    public boolean allowMultiConnections() {
        return false;
    }

    @Override
    public int getMaxLength() {
        return (Integer)ModServerConfig.CATENARY_WIRE_MAX_LENGTH.get();
    }

    @Override
    public WireBatch buildWire(WireCreationContext context, class_1920 level, WireConnectionSyncData data) {
        Vector3f start = data.getStartPos();
        Vector3f end = data.getEndPos();
        Vector3f contactWireAttachPointA = data.getWireAttachPointA();
        Vector3f contactWireAttachPointB = data.getWireAttachPointB();
        Vector3f tensionWireAttachPointA = Utils.getNbtVector3f(data.getConnectorAData(), "TensionWireAttachPoint");
        Vector3f tensionWireAttachPointB = Utils.getNbtVector3f(data.getConnectorBData(), "TensionWireAttachPoint");
        float length = Math.abs(new Vector3f((Vector3fc)end).sub((Vector3fc)start).length());
        float hang = data.getConnectorAData().method_10545("Tension") || data.getConnectorBData().method_10545("Tension") ? 0.5f : 0.025f * length;
        Wire tensionWire = WireBuilder.createWire(context, new Vector3f((Vector3fc)start).add((Vector3fc)tensionWireAttachPointA), new Vector3f((Vector3fc)end).add((Vector3fc)tensionWireAttachPointB), WireBuilder.CableType.TENSION, 0.0234375f, hang, SegmentControl.create(SegmentControl.Config.fixed((int)(length / 5.0f)), SegmentControl.Config.fixed(2)));
        Wire contactWire = WireBuilder.createWire(context, new Vector3f((Vector3fc)start).add((Vector3fc)contactWireAttachPointA), new Vector3f((Vector3fc)end).add((Vector3fc)contactWireAttachPointB), WireBuilder.CableType.TIGHT, 0.03125f, 0.0f, SegmentControl.create(SegmentControl.Config.fixed((int)(length / 5.0f)), SegmentControl.Config.fixed(2)));
        WireBatch batch = WireBatch.of(contactWire, tensionWire);
        if (context.renderingRequired() && tensionWire.getRenderData().isPresent() && contactWire.getRenderData().isPresent()) {
            WireRenderData tensionRenderData = tensionWire.renderData();
            WireRenderData contactRenderData = contactWire.renderData();
            for (int i = 2; i < tensionRenderData.count() - 1 && i < contactRenderData.count() - 1; i += 2) {
                batch.addSubWire(WireBuilder.createWire(WireCreationContext.RENDERING, contactRenderData.getPoint(i).vertex(WireRenderPoint.VertexCorner.CENTER), tensionRenderData.getPoint(i).vertex(WireRenderPoint.VertexCorner.CENTER), WireBuilder.CableType.TIGHT, 0.0125f, 0.0f, SegmentControl.single()));
            }
        }
        return batch;
    }
}

