/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires;

import de.mrjulsen.wires.WireBuilder;
import de.mrjulsen.wires.util.ClientUtils;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class SegmentControl {
    private final Config mainConfig;
    private final Config subConfig;

    private SegmentControl(Config mainConfig, Config subConfig) {
        this.mainConfig = mainConfig;
        this.subConfig = subConfig;
    }

    public static SegmentControl createAuto() {
        return new SegmentControl(Config.auto(), Config.single());
    }

    public static SegmentControl single() {
        return new SegmentControl(Config.single(), Config.single());
    }

    public static SegmentControl fixed(int fixedCount) {
        return new SegmentControl(Config.fixed(fixedCount), Config.single());
    }

    public static SegmentControl maxLength(float maxLength) {
        if (maxLength <= 0.0f) {
            throw new IllegalArgumentException("Max Segment Length cannot be less or equal 0.");
        }
        return new SegmentControl(Config.maxLength(maxLength), Config.single());
    }

    public static SegmentControl custom(float[] customLengths) {
        return new SegmentControl(Config.custom(customLengths), Config.single());
    }

    public static SegmentControl customMax(float[] customLengths, float maxLength) {
        return new SegmentControl(Config.customMax(customLengths, maxLength), Config.single());
    }

    public static SegmentControl configured(Config config) {
        return new SegmentControl(config, Config.single());
    }

    public static SegmentControl create(Config mainConfig, Config subConfig) {
        return new SegmentControl(mainConfig, subConfig);
    }

    int computeSegmentCount(Vector3f start, Vector3f end, WireBuilder.CableType type, float hangFac, boolean rendering) {
        Vector3f diff = new Vector3f((Vector3fc)end).sub((Vector3fc)start);
        float linearLength = diff.length();
        if (type == WireBuilder.CableType.TIGHT) {
            if (this.mainConfig.mode == SegmentationMode.CUSTOM || this.mainConfig.mode == SegmentationMode.CUSTOM_MAX) {
                return this.getCustomSegmentCount(linearLength, this.mainConfig.getCustomLengths(), this.mainConfig.getMaxLength(), this.mainConfig.mode == SegmentationMode.CUSTOM_MAX);
            }
            switch (this.mainConfig.mode.ordinal()) {
                case 1: {
                    return this.mainConfig.fixedCount > 0 ? this.mainConfig.fixedCount : Math.max(1, (int)linearLength);
                }
                case 2: {
                    return Math.max(1, (int)Math.ceil(linearLength / this.mainConfig.maxLength));
                }
            }
            return Math.max(1, (int)linearLength);
        }
        Vector2f p1 = new Vector2f(0.0f, 0.0f);
        Vector2f p2 = new Vector2f(linearLength / 2.0f, diff.y / 2.0f - Math.min(hangFac, linearLength / 2.0f));
        Vector2f p3 = new Vector2f(linearLength, diff.y);
        Vector2f center = SegmentControl.circumcenter(p1, p2, p3);
        float rad = SegmentControl.radius(center, p1);
        float arcLen = SegmentControl.arcLength(center, p1, p3, rad);
        if (this.mainConfig.mode == SegmentationMode.CUSTOM || this.mainConfig.mode == SegmentationMode.CUSTOM_MAX) {
            return this.getCustomSegmentCount(arcLen, this.mainConfig.getCustomLengths(), this.mainConfig.getMaxLength(), this.mainConfig.mode == SegmentationMode.CUSTOM_MAX);
        }
        switch (this.mainConfig.mode.ordinal()) {
            case 1: {
                return this.mainConfig.fixedCount > 0 ? this.mainConfig.fixedCount : this.getCustomSegmentCount(arcLen, this.mainConfig.getCustomLengths(), this.mainConfig.getMaxLength(), false);
            }
            case 2: {
                return Math.max(1, (int)Math.ceil(arcLen / this.mainConfig.maxLength));
            }
        }
        return (int)Math.max(Math.ceil(arcLen * 16.0f / rad), (double)linearLength);
    }

    int computeSubSegmentCount(float segmentLength) {
        if (this.subConfig.mode == SegmentationMode.CUSTOM || this.subConfig.mode == SegmentationMode.CUSTOM_MAX) {
            return this.getCustomSegmentCount(segmentLength, this.subConfig.getCustomLengths(), this.subConfig.getMaxLength(), this.subConfig.mode == SegmentationMode.CUSTOM_MAX);
        }
        switch (this.subConfig.mode.ordinal()) {
            case 1: {
                return this.subConfig.fixedCount > 0 ? this.subConfig.fixedCount : Math.max(1, (int)segmentLength);
            }
            case 2: {
                return Math.max(1, (int)Math.ceil(segmentLength / this.subConfig.maxLength));
            }
        }
        float multiplier = 1.0f;
        if (Platform.getEnvironment() == Env.CLIENT) {
            multiplier = ClientUtils.getMultiplierByGraphicsMode();
        }
        return Math.max(1, (int)(segmentLength * multiplier));
    }

    private int getCustomSegmentCount(float totalLength, float[] custom, float maxLength, boolean useMax) {
        if (custom == null || custom.length == 0) {
            return 1;
        }
        int count = 0;
        float cum = 0.0f;
        block0: for (float len : custom) {
            if (cum >= totalLength) break;
            if (useMax && len > maxLength) {
                int n = (int)Math.ceil(len / maxLength);
                float subLen = len / (float)n;
                for (int i = 0; i < n; ++i) {
                    if (cum + subLen > totalLength) {
                        ++count;
                        cum = totalLength;
                        continue block0;
                    }
                    ++count;
                    cum += subLen;
                }
                continue;
            }
            if (cum + len > totalLength) {
                ++count;
                cum = totalLength;
                break;
            }
            ++count;
            cum += len;
        }
        if (cum < totalLength) {
            float fill = totalLength - cum;
            count = useMax && fill > maxLength ? (count += (int)Math.ceil(fill / maxLength)) : ++count;
        }
        return Math.max(1, count);
    }

    static Vector2f circumcenter(Vector2f a, Vector2f b, Vector2f c) {
        float d = 2.0f * (a.x * (b.y - c.y) + b.x * (c.y - a.y) + c.x * (a.y - b.y));
        if (Math.abs(d) < 1.0E-6f) {
            return new Vector2f(0.0f, 0.0f);
        }
        float ax2ay2 = a.x * a.x + a.y * a.y;
        float bx2by2 = b.x * b.x + b.y * b.y;
        float cx2cy2 = c.x * c.x + c.y * c.y;
        float ux = (ax2ay2 * (b.y - c.y) + bx2by2 * (c.y - a.y) + cx2cy2 * (a.y - b.y)) / d;
        float uy = (ax2ay2 * (c.x - b.x) + bx2by2 * (a.x - c.x) + cx2cy2 * (b.x - a.x)) / d;
        return new Vector2f(ux, uy);
    }

    static float radius(Vector2f center, Vector2f p) {
        return (float)Math.hypot(center.x - p.x, center.y - p.y);
    }

    static float arcLength(Vector2f center, Vector2f a, Vector2f b, float radius) {
        float dot = (a.x - center.x) * (b.x - center.x) + (a.y - center.y) * (b.y - center.y);
        float angle = (float)Math.acos(dot / (radius * radius));
        return radius * angle;
    }

    static Vector2f[] equallyDistributedPointsOnArc(Vector2f center, Vector2f start, Vector2f end, float radius, int segments) {
        Vector2f[] points = new Vector2f[segments];
        float startAngle = (float)Math.atan2(start.y - center.y, start.x - center.x);
        float endAngle = (float)Math.atan2(end.y - center.y, end.x - center.x);
        if (endAngle < startAngle) {
            endAngle = (float)((double)endAngle + Math.PI * 2);
        }
        float angleStep = (endAngle - startAngle) / (float)(segments - 1);
        for (int i = 0; i < segments; ++i) {
            float angle = startAngle + (float)i * angleStep;
            float x = (float)((double)center.x + (double)radius * Math.cos(angle));
            float y = (float)((double)center.y + (double)radius * Math.sin(angle));
            points[i] = new Vector2f(x, y);
        }
        return points;
    }

    static Vector2f[] equallyDistributedPointsOnX(Vector2f center, Vector2f start, Vector2f end, float radius, int segments) {
        Vector2f[] points = new Vector2f[segments];
        float startX = start.x;
        float endX = end.x;
        float stepX = (endX - startX) / (float)(segments - 1);
        for (int i = 0; i < segments; ++i) {
            float y;
            float x = startX + (float)i * stepX;
            float dx = x - center.x;
            float dySquared = radius * radius - dx * dx;
            if (dySquared >= 0.0f) {
                float dy = (float)Math.sqrt(dySquared);
                float candidateY = center.y + dy;
                float candidateY2 = center.y - dy;
                float startAngle = (float)Math.atan2(start.y - center.y, start.x - center.x);
                float candidateAngle = (float)Math.atan2(candidateY - center.y, x - center.x);
                y = candidateAngle >= startAngle && (double)candidateAngle <= Math.atan2(end.y - center.y, end.x - center.x) ? candidateY : candidateY2;
            } else {
                y = center.y;
            }
            points[i] = new Vector2f(x, y);
        }
        return points;
    }

    SegmentationMode getMainMode() {
        return this.mainConfig.mode;
    }

    float[] getMainCustomLengths() {
        return this.mainConfig.customLengths;
    }

    float getMainMaxLength() {
        return this.mainConfig.maxLength;
    }

    public static final class Config {
        private final SegmentationMode mode;
        private final int fixedCount;
        private final float maxLength;
        private final float[] customLengths;

        private Config(SegmentationMode mode, int fixedCount, float maxLength, float[] customLengths) {
            this.mode = mode;
            this.fixedCount = fixedCount;
            this.maxLength = maxLength;
            this.customLengths = customLengths;
        }

        public static Config single() {
            return Config.fixed(1);
        }

        public static Config auto() {
            return new Config(SegmentationMode.AUTO, 0, 0.0f, null);
        }

        public static Config fixed(int fixedCount) {
            return new Config(SegmentationMode.FIXED, fixedCount, 0.0f, null);
        }

        public static Config maxLength(float maxLength) {
            return new Config(SegmentationMode.MAX_LENGTH, 0, maxLength, null);
        }

        public static Config custom(float[] customLengths) {
            return new Config(SegmentationMode.CUSTOM, 0, 0.0f, customLengths);
        }

        public static Config customMax(float[] customLengths, float maxLength) {
            return new Config(SegmentationMode.CUSTOM_MAX, 0, maxLength, customLengths);
        }

        public SegmentationMode getMode() {
            return this.mode;
        }

        public int getFixedCount() {
            return this.fixedCount;
        }

        public float getMaxLength() {
            return this.maxLength;
        }

        public float[] getCustomLengths() {
            return this.customLengths;
        }
    }

    public static enum SegmentationMode {
        AUTO,
        FIXED,
        MAX_LENGTH,
        CUSTOM,
        CUSTOM_MAX;

    }
}

