/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires;

import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.wires.Wire;
import de.mrjulsen.wires.WirePoints;
import de.mrjulsen.wires.render.WireRenderData;
import de.mrjulsen.wires.render.WireSegmentRenderData;
import de.mrjulsen.wires.render.WireSegmentRenderDataBatch;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_4076;

public class WireBatch {
    private final Set<Wire> subWires = new HashSet<Wire>();
    private final Cache<Set<WirePoints>> collisionCache = new Cache(() -> {
        HashSet<WirePoints> points = new HashSet<WirePoints>(this.subWires.size());
        for (Wire wire : this.subWires) {
            if (!wire.getCollisionData().isPresent()) continue;
            points.add(wire.collisionData());
        }
        return points;
    });
    private final Cache<Set<WireRenderData>> renderCache = new Cache(() -> {
        HashSet<WireRenderData> points = new HashSet<WireRenderData>(this.subWires.size());
        for (Wire wire : this.subWires) {
            if (!wire.getRenderData().isPresent()) continue;
            points.add(wire.renderData());
        }
        return points;
    });

    public WireBatch(Wire mainWire) {
        this.subWires.add(mainWire);
    }

    public static WireBatch of(Wire ... wires) {
        if (wires.length <= 0) {
            throw new IllegalArgumentException("At least one wire must be provided!");
        }
        WireBatch batch = new WireBatch(wires[0]);
        for (int i = 1; i < wires.length; ++i) {
            batch.addSubWire(wires[i]);
        }
        return batch;
    }

    public void addSubWire(Wire subWire) {
        this.subWires.add(subWire);
    }

    public int count() {
        return this.subWires.size();
    }

    public Set<Wire> getWires() {
        return this.subWires;
    }

    public Set<WirePoints> getCollisions() {
        return (Set)this.collisionCache.get();
    }

    public Set<WireRenderData> getRenderData() {
        return (Set)this.renderCache.get();
    }

    public Map<class_4076, WireSegmentRenderDataBatch> splitRenderDataInChunkSections(UUID id, class_4076 origin) {
        HashMap<class_4076, WireSegmentRenderDataBatch> result = new HashMap<class_4076, WireSegmentRenderDataBatch>();
        for (Wire wire : this.subWires) {
            Optional<WireRenderData> data = wire.getRenderData();
            if (!data.isPresent()) continue;
            Map<class_4076, WireSegmentRenderData> segments = data.get().splitInChunkSections(origin);
            for (Map.Entry<class_4076, WireSegmentRenderData> segment : segments.entrySet()) {
                result.computeIfAbsent(segment.getKey(), x -> new WireSegmentRenderDataBatch(id, (class_4076)segment.getKey())).addSegment(segment.getValue());
            }
        }
        return result;
    }
}

