/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires;

import de.mrjulsen.wires.SegmentControl;
import de.mrjulsen.wires.Wire;
import de.mrjulsen.wires.WireCreationContext;
import de.mrjulsen.wires.WirePoints;
import de.mrjulsen.wires.render.WireRenderData;
import de.mrjulsen.wires.render.WireRenderPoint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class WireBuilder {
    public static Wire createWire(WireCreationContext context, Vector3f start, Vector3f end, CableType type, float thickness, float hangFac, SegmentControl segControl) {
        WireRenderData renderData = null;
        if (context.renderingRequired()) {
            renderData = WireBuilder.createWireRenderData(start, end, type, thickness, hangFac, segControl);
        }
        WirePoints collisionData = null;
        if (context.collisionRequired()) {
            collisionData = WireBuilder.createWirePoints(start, end, type, hangFac, segControl);
        }
        return new Wire(collisionData, renderData);
    }

    public static WireRenderData createWireRenderData(Vector3f start, Vector3f end, CableType type, float thickness, float hangFac, SegmentControl segControl) {
        Vector3f[] path = WireBuilder.generateWirePath(start, end, type, hangFac, segControl, true);
        int totalPoints = path.length;
        ArrayList<Vector3f> fullPath = new ArrayList<Vector3f>();
        for (int i = 0; i < totalPoints - 1; ++i) {
            Vector3f segStart = path[i];
            Vector3f segEnd = path[i + 1];
            fullPath.add(new Vector3f((Vector3fc)segStart));
            float segLength = new Vector3f((Vector3fc)segEnd).sub((Vector3fc)segStart).length();
            int subCount = segControl.computeSubSegmentCount(segLength);
            for (int j = 1; j < subCount; ++j) {
                float t = (float)j / (float)subCount;
                Vector3f subPoint = new Vector3f((Vector3fc)segStart).lerp((Vector3fc)segEnd, t);
                fullPath.add(subPoint);
            }
        }
        fullPath.add(new Vector3f((Vector3fc)path[totalPoints - 1]));
        Vector3f[] renderPath = fullPath.toArray(new Vector3f[0]);
        int numPoints = renderPath.length;
        WireRenderData wire = new WireRenderData(numPoints);
        for (int i = 0; i < numPoints; ++i) {
            Vector3f point = renderPath[i];
            Vector3f tangent = WireBuilder.calculateTangent(renderPath, i);
            WireRenderPoint vertices = WireBuilder.calcVertices(point, tangent, thickness, point);
            wire.setPoint(vertices, i);
        }
        return wire;
    }

    public static WirePoints createWirePoints(Vector3f start, Vector3f end, CableType type, float hangFac, SegmentControl segControl) {
        Vector3f[] path = WireBuilder.generateWirePath(start, end, type, hangFac, segControl, false);
        return new WirePoints(path);
    }

    private static Vector3f[] generateWirePath(Vector3f start, Vector3f end, CableType type, float hangFac, SegmentControl segControl, boolean rendering) {
        if (segControl.getMainMode() == SegmentControl.SegmentationMode.CUSTOM || segControl.getMainMode() == SegmentControl.SegmentationMode.CUSTOM_MAX) {
            if (type == CableType.TIGHT) {
                return WireBuilder.generateCustomPathLinear(start, end, segControl);
            }
            return WireBuilder.generateCustomPathArc(start, end, hangFac, segControl);
        }
        Vector3f direction = new Vector3f((Vector3fc)end).sub((Vector3fc)start);
        float length = direction.length();
        Vector3f normalized = new Vector3f((Vector3fc)direction).normalize();
        int segCount = segControl.computeSegmentCount(start, end, type, hangFac, rendering);
        int numPoints = segCount + 1;
        Vector3f[] path = new Vector3f[numPoints];
        if (type == CableType.TIGHT) {
            for (int i = 0; i < numPoints; ++i) {
                float t = (float)i / (float)(numPoints - 1);
                path[i] = new Vector3f((Vector3fc)start).add((Vector3fc)new Vector3f((Vector3fc)normalized).mul(t * length));
            }
        } else {
            Vector2f p1 = new Vector2f(0.0f, 0.0f);
            Vector2f p2 = new Vector2f(length / 2.0f, direction.y / 2.0f - Math.min(hangFac, length / 2.0f));
            Vector2f p3 = new Vector2f(length, direction.y);
            Vector2f center = SegmentControl.circumcenter(p1, p2, p3);
            float rad = SegmentControl.radius(center, p1);
            int totalPointsForArc = numPoints;
            Vector2f[] arcPoints = type == CableType.HANGING ? SegmentControl.equallyDistributedPointsOnArc(center, p1, p3, rad, totalPointsForArc) : SegmentControl.equallyDistributedPointsOnX(center, p1, p3, rad, totalPointsForArc);
            for (int i = 0; i < totalPointsForArc; ++i) {
                Vector2f arcPoint = arcPoints[i];
                Vector3f projected = WireBuilder.projectPointOnVectorPlane(normalized, arcPoint);
                path[i] = new Vector3f((Vector3fc)start).add((Vector3fc)projected);
            }
        }
        return path;
    }

    private static Vector3f[] generateCustomPathLinear(Vector3f start, Vector3f end, SegmentControl segControl) {
        float totalLength = new Vector3f((Vector3fc)end).sub((Vector3fc)start).length();
        Vector3f direction = new Vector3f((Vector3fc)end).sub((Vector3fc)start).normalize();
        float[] custom = segControl.getMainCustomLengths();
        ArrayList<Float> segmentLengths = new ArrayList<Float>();
        float cum = 0.0f;
        block0: for (float len : custom) {
            if (cum >= totalLength) break;
            if (segControl.getMainMode() == SegmentControl.SegmentationMode.CUSTOM_MAX && len > segControl.getMainMaxLength()) {
                int n = (int)Math.ceil(len / segControl.getMainMaxLength());
                float subLen = len / (float)n;
                for (int i = 0; i < n; ++i) {
                    if (cum + subLen > totalLength) {
                        subLen = totalLength - cum;
                        segmentLengths.add(Float.valueOf(subLen));
                        cum = totalLength;
                        continue block0;
                    }
                    segmentLengths.add(Float.valueOf(subLen));
                    cum += subLen;
                }
                continue;
            }
            if (cum + len > totalLength) {
                float truncated = totalLength - cum;
                segmentLengths.add(Float.valueOf(truncated));
                cum = totalLength;
                break;
            }
            segmentLengths.add(Float.valueOf(len));
            cum += len;
        }
        if (cum < totalLength) {
            float remaining = totalLength - cum;
            if (segControl.getMainMode() == SegmentControl.SegmentationMode.CUSTOM_MAX && remaining > segControl.getMainMaxLength()) {
                int n = (int)Math.ceil(remaining / segControl.getMainMaxLength());
                float subLen = remaining / (float)n;
                for (int i = 0; i < n; ++i) {
                    segmentLengths.add(Float.valueOf(subLen));
                }
            } else {
                segmentLengths.add(Float.valueOf(remaining));
            }
        }
        ArrayList<Vector3f> points = new ArrayList<Vector3f>();
        points.add(new Vector3f((Vector3fc)start));
        Vector3f current = new Vector3f((Vector3fc)start);
        Iterator iterator = segmentLengths.iterator();
        while (iterator.hasNext()) {
            float segLen = ((Float)iterator.next()).floatValue();
            current = new Vector3f((Vector3fc)current).add((Vector3fc)new Vector3f((Vector3fc)direction).mul(segLen));
            points.add(new Vector3f((Vector3fc)current));
        }
        return points.toArray(new Vector3f[0]);
    }

    private static Vector3f[] generateCustomPathArc(Vector3f start, Vector3f end, float hangFac, SegmentControl segControl) {
        Vector3f diff = new Vector3f((Vector3fc)end).sub((Vector3fc)start);
        float linearLength = diff.length();
        Vector2f p1 = new Vector2f(0.0f, 0.0f);
        Vector2f p2 = new Vector2f(linearLength / 2.0f, diff.y / 2.0f - Math.min(hangFac, linearLength / 2.0f));
        Vector2f p3 = new Vector2f(linearLength, diff.y);
        Vector2f center = SegmentControl.circumcenter(p1, p2, p3);
        float rad = SegmentControl.radius(center, p1);
        float totalArcLength = SegmentControl.arcLength(center, p1, p3, rad);
        float startAngle = (float)Math.atan2(p1.y - center.y, p1.x - center.x);
        float endAngle = (float)Math.atan2(p3.y - center.y, p3.x - center.x);
        if (endAngle < startAngle) {
            endAngle += (float)Math.PI * 2;
        }
        float theta = endAngle - startAngle;
        float[] custom = segControl.getMainCustomLengths();
        ArrayList<Float> segmentLengths = new ArrayList<Float>();
        float cum = 0.0f;
        block0: for (float len : custom) {
            if (cum >= totalArcLength) break;
            if (segControl.getMainMode() == SegmentControl.SegmentationMode.CUSTOM_MAX && len > segControl.getMainMaxLength()) {
                int n = (int)Math.ceil(len / segControl.getMainMaxLength());
                float subLen = len / (float)n;
                for (int i = 0; i < n; ++i) {
                    if (cum + subLen > totalArcLength) {
                        subLen = totalArcLength - cum;
                        segmentLengths.add(Float.valueOf(subLen));
                        cum = totalArcLength;
                        continue block0;
                    }
                    segmentLengths.add(Float.valueOf(subLen));
                    cum += subLen;
                }
                continue;
            }
            if (cum + len > totalArcLength) {
                float truncated = totalArcLength - cum;
                segmentLengths.add(Float.valueOf(truncated));
                cum = totalArcLength;
                break;
            }
            segmentLengths.add(Float.valueOf(len));
            cum += len;
        }
        if (cum < totalArcLength) {
            float remaining = totalArcLength - cum;
            if (segControl.getMainMode() == SegmentControl.SegmentationMode.CUSTOM_MAX && remaining > segControl.getMainMaxLength()) {
                int n = (int)Math.ceil(remaining / segControl.getMainMaxLength());
                float subLen = remaining / (float)n;
                for (int i = 0; i < n; ++i) {
                    segmentLengths.add(Float.valueOf(subLen));
                }
            } else {
                segmentLengths.add(Float.valueOf(remaining));
            }
        }
        ArrayList<Vector3f> points = new ArrayList<Vector3f>();
        points.add(new Vector3f((Vector3fc)start));
        float cumulative = 0.0f;
        Vector3f direction = new Vector3f((Vector3fc)end).sub((Vector3fc)start).normalize();
        Iterator iterator = segmentLengths.iterator();
        while (iterator.hasNext()) {
            float segLen = ((Float)iterator.next()).floatValue();
            float fraction = (cumulative += segLen) / totalArcLength;
            float angle = startAngle + fraction * theta;
            float x2d = center.x + rad * (float)Math.cos(angle);
            float y2d = center.y + rad * (float)Math.sin(angle);
            Vector2f arcPoint = new Vector2f(x2d, y2d);
            Vector3f projected = WireBuilder.projectPointOnVectorPlane(direction, arcPoint);
            Vector3f point = new Vector3f((Vector3fc)start).add((Vector3fc)projected);
            points.add(point);
        }
        return points.toArray(new Vector3f[0]);
    }

    private static Vector3f calculateTangent(Vector3f[] path, int i) {
        if (i == 0 && path.length > 1) {
            return new Vector3f((Vector3fc)path[1]).sub((Vector3fc)path[0]).normalize();
        }
        if (i == path.length - 1 && path.length > 1) {
            return new Vector3f((Vector3fc)path[i]).sub((Vector3fc)path[i - 1]).normalize();
        }
        if (path.length > 2) {
            return new Vector3f((Vector3fc)path[i + 1]).sub((Vector3fc)path[i - 1]).normalize();
        }
        return new Vector3f(0.0f, 1.0f, 0.0f);
    }

    private static WireRenderPoint calcVertices(Vector3f start, Vector3f direction, float thickness, Vector3f customCenter) {
        Vector3f norm = new Vector3f((Vector3fc)direction).normalize();
        Vector3f rightVec = Math.abs(norm.x) < 0.1f && Math.abs(norm.z) < 0.1f ? new Vector3f(1.0f, 0.0f, 0.0f) : new Vector3f(norm.z, 0.0f, -norm.x);
        rightVec.normalize().mul(thickness / 2.0f);
        Vector3f crossVec = new Vector3f((Vector3fc)norm).cross((Vector3fc)rightVec, new Vector3f()).normalize().mul(thickness / 2.0f);
        return new WireRenderPoint(Map.of(WireRenderPoint.VertexCorner.CENTER, customCenter != null ? customCenter : new Vector3f((Vector3fc)start).add((Vector3fc)norm), WireRenderPoint.VertexCorner.TOP_LEFT, new Vector3f((Vector3fc)start).add((Vector3fc)new Vector3f((Vector3fc)rightVec).add((Vector3fc)crossVec)), WireRenderPoint.VertexCorner.BOTTOM_RIGHT, new Vector3f((Vector3fc)start).sub((Vector3fc)new Vector3f((Vector3fc)rightVec).add((Vector3fc)crossVec)), WireRenderPoint.VertexCorner.TOP_RIGHT, new Vector3f((Vector3fc)start).add((Vector3fc)new Vector3f((Vector3fc)crossVec)).sub((Vector3fc)rightVec), WireRenderPoint.VertexCorner.BOTTOM_LEFT, new Vector3f((Vector3fc)start).add((Vector3fc)new Vector3f((Vector3fc)rightVec)).sub((Vector3fc)crossVec)));
    }

    private static Vector3f projectPointOnVectorPlane(Vector3f direction, Vector2f point) {
        Vector3f scaled = new Vector3f((Vector3fc)direction).mul(point.x);
        return new Vector3f(scaled.x, point.y, scaled.z);
    }

    public static enum CableType {
        HANGING,
        TENSION,
        TIGHT;

    }
}

