/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import de.mrjulsen.wires.IWireNetwork;
import de.mrjulsen.wires.IWireType;
import de.mrjulsen.wires.WireBatch;
import de.mrjulsen.wires.WireCollision;
import de.mrjulsen.wires.WireCreationContext;
import de.mrjulsen.wires.WireTypeRegistry;
import de.mrjulsen.wires.network.WireChunkLoadingData;
import de.mrjulsen.wires.network.WiresNetworkSyncData;
import de.mrjulsen.wires.render.WireSegmentRenderDataBatch;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1920;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4076;

public final class WireClientNetwork
implements IWireNetwork {
    private static class_2960 dimension;
    private static WireClientNetwork currentNetwork;
    private final class_1937 level;
    private final Multimap<class_1923, WireCollision> collisionByChunk = MultimapBuilder.hashKeys().hashSetValues().build();
    private final Multimap<class_4076, WireCollision> collisionBySection = MultimapBuilder.hashKeys().hashSetValues().build();
    private final Multimap<class_2338, WireCollision> collisionByBlock = MultimapBuilder.hashKeys().hashSetValues().build();
    private final Multimap<UUID, WireSegmentRenderDataBatch> renderDataById = MultimapBuilder.hashKeys().hashSetValues().build();
    private final Multimap<class_1923, WireSegmentRenderDataBatch> renderDataByChunk = MultimapBuilder.hashKeys().hashSetValues().build();
    private final Multimap<class_4076, WireSegmentRenderDataBatch> renderDataBySection = MultimapBuilder.hashKeys().hashSetValues().build();

    protected WireClientNetwork(class_1937 level) {
        this.level = level;
    }

    public String debug_text() {
        return String.format("Wires[C]: Col: [%s,%s,%s], R: [%s,%s,%s]", this.collisionByChunk.size(), this.collisionBySection.size(), this.collisionByBlock.size(), this.renderDataById.size(), this.renderDataBySection.size(), this.renderDataByChunk.size());
    }

    @Override
    public class_1937 level() {
        return this.level;
    }

    public static void clear() {
        dimension = null;
        currentNetwork = null;
    }

    public static WireClientNetwork get(class_1937 level) {
        if (dimension != level.method_44013().method_29177() || currentNetwork == null) {
            dimension = level.method_44013().method_29177();
            currentNetwork = new WireClientNetwork(level);
            return currentNetwork;
        }
        return currentNetwork;
    }

    public Collection<WireCollision> getCollisionsTroughBlock(class_2338 pos) {
        return this.collisionByBlock.get((Object)pos);
    }

    public Collection<WireCollision> getCollisionsTroughSection(class_4076 pos) {
        return this.collisionBySection.get((Object)pos);
    }

    public Collection<WireCollision> getCollisionsTroughChunk(class_1923 pos) {
        return this.collisionByChunk.get((Object)pos);
    }

    public Collection<WireCollision.WireBlockCollision> getCollisionsInBlock(class_2338 pos) {
        LinkedList<WireCollision.WireBlockCollision> connections = new LinkedList<WireCollision.WireBlockCollision>();
        for (WireCollision c : this.collisionByBlock.get((Object)pos)) {
            connections.addAll(c.collisionsInBlock(pos));
        }
        return connections;
    }

    public synchronized boolean hasConnectionsInSection(class_4076 section) {
        return this.renderDataBySection.containsKey((Object)section);
    }

    public synchronized boolean hasConnectionsInBlock(class_2338 pos) {
        return this.collisionByBlock.containsKey((Object)pos);
    }

    public synchronized Collection<WireSegmentRenderDataBatch> connectionsInSection(class_4076 section) {
        if (!this.hasConnectionsInSection(section)) {
            return List.of();
        }
        return this.renderDataBySection.get((Object)section);
    }

    public void createClientConnection(@Nullable class_1923 chunk, WiresNetworkSyncData.WireSyncDataEntry in) {
        if (in.forceUpdate()) {
            this.removeClientConnection(in.data().getConnectionId());
        } else if (this.renderDataById.containsKey((Object)in.data().getConnectionId())) {
            if (chunk != null && this.renderDataByChunk.containsKey((Object)chunk)) {
                for (WireSegmentRenderDataBatch renderdata : this.renderDataByChunk.get((Object)chunk)) {
                    renderdata.setUnloaded(false);
                }
            }
            return;
        }
        HashSet sectionsIn = new HashSet();
        IWireType renderer = WireTypeRegistry.get(in.data().getWireType());
        WireBatch batch = renderer.buildWire(WireCreationContext.BOTH, (class_1920)class_310.method_1551().field_1687, in.data());
        batch.splitRenderDataInChunkSections(in.data().getConnectionId(), in.data().getOriginChunkSection()).entrySet().forEach(x -> {
            this.renderDataByChunk.put((Object)((class_4076)x.getKey()).method_18692(), (Object)((WireSegmentRenderDataBatch)x.getValue()));
            this.renderDataBySection.put((Object)((class_4076)x.getKey()), (Object)((WireSegmentRenderDataBatch)x.getValue()));
            this.renderDataById.put((Object)in.data().getConnectionId(), (Object)((WireSegmentRenderDataBatch)x.getValue()));
            sectionsIn.add((class_4076)x.getKey());
        });
        new WireCollision(this.collisionByChunk, this.collisionBySection, this.collisionByBlock, in.data().getConnectionId(), in.data().getStartBlockPos(), batch.getCollisions());
        for (class_4076 section : sectionsIn) {
            this.setSectionDirty(section);
        }
    }

    public void removeClientConnections(UUID[] connectionIds) {
        for (UUID id : connectionIds) {
            this.removeClientConnection(id);
        }
    }

    public void removeClientConnection(UUID connectionId) {
        if (!this.renderDataById.containsKey((Object)connectionId)) {
            return;
        }
        Collection renderdata = this.renderDataById.removeAll((Object)connectionId);
        this.renderDataBySection.values().removeAll(renderdata);
        this.renderDataByChunk.values().removeAll(renderdata);
        this.collisionByBlock.values().removeIf(x -> x.getId().equals(connectionId));
        this.collisionByChunk.values().removeIf(x -> x.getId().equals(connectionId));
        this.collisionBySection.values().removeIf(x -> x.getId().equals(connectionId));
        for (WireSegmentRenderDataBatch batch : renderdata) {
            class_4076 section = batch.getSection();
            this.setSectionDirty(section);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClientChunkLoading(WireChunkLoadingData in) {
        Multimap<class_1923, WireSegmentRenderDataBatch> multimap = this.renderDataByChunk;
        synchronized (multimap) {
            HashSet<UUID> emptyConnections = new HashSet<UUID>();
            for (WireSegmentRenderDataBatch renderdata : this.renderDataByChunk.get((Object)in.pos())) {
                renderdata.setUnloaded(!in.load());
                if (this.renderDataById.containsKey((Object)renderdata.getId()) && !this.renderDataById.get((Object)renderdata.getId()).stream().allMatch(WireSegmentRenderDataBatch::isUnloaded)) continue;
                emptyConnections.add(renderdata.getId());
            }
            for (UUID id : emptyConnections) {
                this.removeClientConnection(id);
            }
        }
    }

    private void setSectionDirty(class_4076 pos) {
        class_310.method_1551().execute(() -> class_310.method_1551().field_1769.method_8571(pos.method_10263(), pos.method_10264(), pos.method_10260()));
    }
}

