/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.paw.config.ModServerConfig;
import de.mrjulsen.wires.WirePoints;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_4076;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class WireCollision {
    private final UUID connectionId;
    private final Set<class_1923> chunks = new HashSet<class_1923>();
    private final Multimap<class_2338, WireBlockCollision> blocks = MultimapBuilder.hashKeys().hashSetValues().build();
    private final Set<class_4076> sections = new HashSet<class_4076>();

    public WireCollision(Multimap<class_1923, WireCollision> chunkMap, Multimap<class_4076, WireCollision> sectionMap, Multimap<class_2338, WireCollision> blockMap, UUID connectionId, class_2338 origin, Set<WirePoints> points) {
        chunkMap.values().removeIf(x -> x.getId().equals(connectionId));
        sectionMap.values().removeIf(x -> x.getId().equals(connectionId));
        blockMap.values().removeIf(x -> x.getId().equals(connectionId));
        this.connectionId = connectionId;
        for (WirePoints p : points) {
            Vector3f[] vec = p.vertices();
            Map<class_2338, WireBlockCollision> positions = this.traceAlongWire(vec, (float)(0.0625 * (Double)ModServerConfig.WIRE_COLLISION_TRACER_STEP_SIZE.get()), origin);
            for (Map.Entry<class_2338, WireBlockCollision> pos : positions.entrySet()) {
                DLUtils.doIfNotNull(blockMap, x -> x.put((Object)((class_2338)pos.getKey()), (Object)this));
                class_4076 section = class_4076.method_18682((class_2338)pos.getKey());
                class_1923 chunk = section.method_18692();
                if (this.sections.add(section)) {
                    DLUtils.doIfNotNull(sectionMap, x -> x.put((Object)section, (Object)this));
                }
                if (this.chunks.add(chunk)) {
                    DLUtils.doIfNotNull(chunkMap, x -> x.put((Object)chunk, (Object)this));
                }
                this.blocks.put((Object)pos.getKey(), (Object)pos.getValue());
            }
        }
    }

    public UUID getId() {
        return this.connectionId;
    }

    public Set<class_2338> blocksIn() {
        return this.blocks.keySet();
    }

    public Collection<WireBlockCollision> collisionsInBlock(class_2338 pos) {
        return this.blocks.get((Object)pos);
    }

    public Set<class_4076> sectionsIn() {
        return this.sections;
    }

    public Collection<WireBlockCollision> getAllCollisions() {
        return this.blocks.values();
    }

    private Map<class_2338, WireBlockCollision> traceAlongWire(Vector3f[] points, float step, class_2338 origin) {
        if (points.length <= 1) {
            return Map.of();
        }
        class_2338 originSection = class_4076.method_18682((class_2338)origin).method_19767();
        HashMap<class_2338, WireBlockCollision> blocks = new HashMap<class_2338, WireBlockCollision>();
        Vector3f prevVec = points[0];
        class_2338 lastBlock = null;
        Vector3f lastPoint = null;
        Vector3f currentPoint = null;
        for (int i = 1; i < points.length; ++i) {
            Vector3f vec = points[i];
            Vector3f delta = new Vector3f((Vector3fc)vec).sub((Vector3fc)prevVec);
            Vector3f normalized = new Vector3f((Vector3fc)delta).normalize();
            double length = delta.length();
            int c = (int)Math.ceil(length / (double)step);
            for (int k = 0; k <= c; ++k) {
                Vector3f v = new Vector3f((Vector3fc)prevVec).add((Vector3fc)new Vector3f((Vector3fc)normalized).mul((float)k * step));
                class_2338 newPos = new class_2338((int)Math.floor(v.x), (int)Math.floor(v.y), (int)Math.floor(v.z)).method_10081((class_2382)originSection);
                currentPoint = new Vector3f((float)originSection.method_10263() + v.x, (float)originSection.method_10264() + v.y, (float)originSection.method_10260() + v.z);
                if (lastBlock != null && lastBlock.equals((Object)newPos)) continue;
                if (lastBlock != null && lastPoint != null) {
                    class_2338 fLastPos = lastBlock;
                    Vector3f fLastPoint = lastPoint;
                    Vector3f fCurrentPoint = currentPoint;
                    blocks.computeIfAbsent(fLastPos, x -> new WireBlockCollision(fLastPos, new Vector3f((Vector3fc)fLastPoint).sub((float)fLastPos.method_10263(), (float)fLastPos.method_10264(), (float)fLastPos.method_10260()))).setSecondPoint(new Vector3f((Vector3fc)fCurrentPoint).sub((float)fLastPos.method_10263(), (float)fLastPos.method_10264(), (float)fLastPos.method_10260()));
                }
                lastPoint = currentPoint;
                lastBlock = newPos;
            }
            prevVec = vec;
        }
        if (lastBlock != null && lastPoint != null) {
            class_2338 fLastPos = lastBlock;
            Vector3f fLastPoint = lastPoint;
            Vector3f fCurrentPoint = currentPoint;
            blocks.computeIfAbsent(fLastPos, x -> new WireBlockCollision(fLastPos, new Vector3f((Vector3fc)fLastPoint).sub((float)fLastPos.method_10263(), (float)fLastPos.method_10264(), (float)fLastPos.method_10260()))).setSecondPoint(new Vector3f(fCurrentPoint).sub((float)fLastPos.method_10263(), (float)fLastPos.method_10264(), (float)fLastPos.method_10260()));
        }
        return blocks;
    }

    public static boolean connectionBlocked(class_1937 level, class_2338 pos, class_2680 state, Vector3f a, Vector3f b) {
        class_265 shape = state.method_26220((class_1922)level, pos);
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1077(), (class_247)class_247.field_16896);
        for (class_238 aabb : shape.method_1090()) {
            if (!(aabb = aabb.method_1014(1.0E-5)).method_1006(new class_243(a)) && !aabb.method_1006(new class_243(b)) && !aabb.method_992(new class_243(a), new class_243(b)).isPresent()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WireCollision");
        for (WireBlockCollision c : this.blocks.values()) {
            sb.append("\n");
            sb.append(c.toString());
        }
        return sb.toString();
    }

    public static class WireBlockCollision {
        private final class_2338 pos;
        private final Vector3f entryPointA;
        private Vector3f entryPointB;
        private final Cache<Vector3f> absA;
        private final Cache<Vector3f> absB;

        public WireBlockCollision(class_2338 pos, Vector3f entryPointA) {
            this.pos = pos;
            this.entryPointA = new Vector3f(WireBlockCollision.bounds(entryPointA.x), entryPointA.y, WireBlockCollision.bounds(entryPointA.z));
            this.absA = new Cache(() -> new Vector3f((Vector3fc)this.entryPointA).add((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260()));
            this.absB = new Cache(() -> new Vector3f((Vector3fc)this.entryPointB).add((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260()));
        }

        public WireBlockCollision(class_2338 pos, Vector3f entryPointA, Vector3f entryPointB) {
            this(pos, entryPointA);
            this.entryPointB = new Vector3f(WireBlockCollision.bounds(entryPointB.x), entryPointB.y, WireBlockCollision.bounds(entryPointB.z));
            this.absA.clear();
            this.absB.clear();
        }

        public WireBlockCollision setSecondPoint(Vector3f oEntryPointB) {
            this.entryPointB = new Vector3f(WireBlockCollision.bounds(oEntryPointB.x), oEntryPointB.y, WireBlockCollision.bounds(oEntryPointB.z));
            this.absA.clear();
            this.absB.clear();
            return this;
        }

        private static float bounds(double v) {
            return (float)(v <= 0.0625 ? 0.0 : (v >= 0.9375 ? 1.0 : v));
        }

        public final String toString() {
            return String.format("%s (in: %s, out: %s)", this.pos, this.entryPointA, this.entryPointB);
        }

        public final int hashCode() {
            return Objects.hash(this.pos, this.entryPointA, this.entryPointB);
        }

        public final boolean equals(Object other) {
            if (other instanceof WireBlockCollision) {
                WireBlockCollision o = (WireBlockCollision)other;
                return this.pos.equals((Object)o.pos) && this.entryPointA.equals((Object)o.entryPointA) && this.entryPointB.equals((Object)o.entryPointB);
            }
            return false;
        }

        public class_2338 pos() {
            return this.pos;
        }

        public Vector3f entryPointA() {
            return this.entryPointA;
        }

        public Vector3f entryPointB() {
            return this.entryPointB;
        }

        public Vector3f absA() {
            return (Vector3f)this.absA.get();
        }

        public Vector3f absB() {
            return (Vector3f)this.absB.get();
        }
    }
}

