/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires;

import com.google.common.collect.Multimap;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.wires.IWireType;
import de.mrjulsen.wires.WireCollision;
import de.mrjulsen.wires.WireCreationContext;
import de.mrjulsen.wires.WireNetwork;
import de.mrjulsen.wires.WireTypeRegistry;
import de.mrjulsen.wires.WiresApi;
import de.mrjulsen.wires.block.IWireConnector;
import de.mrjulsen.wires.network.WireConnectionSyncData;
import de.mrjulsen.wires.util.Utils;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1920;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_4076;
import org.joml.Vector3f;

public class WireConnection {
    private static final String NBT_ID = "Id";
    private static final String NBT_POS_A = "PosA";
    private static final String NBT_POS_B = "PosB";
    private static final String NBT_WIRE_TYPE = "WireType";
    private static final String NBT_CONNECTION_DATA_A = "CachedDataA";
    private static final String NBT_CONNECTION_DATA_B = "CachedDataB";
    private static final String NBT_CREATION_DATA = "CreationData";
    private final UUID id;
    private final class_2338 pointA;
    private final class_2338 pointB;
    private final IWireType wireType;
    private class_2487 connectionANbt;
    private class_2487 connectionBNbt;
    private final class_2487 creationData;
    private WireCollision collisionRef;
    private WireConnectionSyncData syncData;
    private final Cache<Integer> hashCache = new Cache(() -> 31 * Objects.hash(this.getPointA(), this.getPointB(), this.getConnectionANbt(), this.getConnectionBNbt(), this.getWireType().getRegistryId()) * Objects.hash(this.getPointB(), this.getPointA(), this.getConnectionBNbt(), this.getConnectionANbt(), this.getWireType().getRegistryId()));

    public WireConnection(UUID id, class_2338 pointA, class_2338 pointB, IWireType type, class_2487 connectionANbt, class_2487 connectionBNbt, class_2487 creationData) {
        this.id = id;
        this.pointA = pointA;
        this.pointB = pointB;
        this.wireType = type;
        this.connectionANbt = connectionANbt;
        this.connectionBNbt = connectionBNbt;
        this.creationData = creationData;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_25927(NBT_ID, this.id);
        DLUtils.putNbtBlockPos((class_2487)nbt, (String)NBT_POS_A, (class_2338)this.pointA);
        DLUtils.putNbtBlockPos((class_2487)nbt, (String)NBT_POS_B, (class_2338)this.pointB);
        nbt.method_10582(NBT_WIRE_TYPE, this.wireType.getRegistryId().toString());
        nbt.method_10566(NBT_CONNECTION_DATA_A, (class_2520)this.connectionANbt);
        nbt.method_10566(NBT_CONNECTION_DATA_B, (class_2520)this.connectionBNbt);
        nbt.method_10566(NBT_CREATION_DATA, (class_2520)this.creationData);
        return nbt;
    }

    public static Optional<WireConnection> fromNbt(class_2487 nbt) {
        class_2960 wireTypeId = Utils.resLoc(nbt.method_10558(NBT_WIRE_TYPE));
        if (WireTypeRegistry.has(wireTypeId)) {
            return Optional.of(new WireConnection(nbt.method_25926(NBT_ID), DLUtils.getNbtBlockPos((class_2487)nbt, (String)NBT_POS_A), DLUtils.getNbtBlockPos((class_2487)nbt, (String)NBT_POS_B), WireTypeRegistry.get(wireTypeId), nbt.method_10562(NBT_CONNECTION_DATA_A), nbt.method_10562(NBT_CONNECTION_DATA_B), nbt.method_10562(NBT_CREATION_DATA)));
        }
        return Optional.empty();
    }

    public boolean recalcAttachPoints(WireNetwork network, Multimap<class_1923, WireCollision> chunkMap, Multimap<class_4076, WireCollision> sectionMap, Multimap<class_2338, WireCollision> blockMap) {
        IWireConnector c;
        class_2248 connectorData;
        class_2248 class_22482;
        boolean hasChanged = false;
        if (network.level().method_8477(this.getPointA()) && (class_22482 = network.level().method_8320(this.getPointA()).method_26204()) instanceof IWireConnector && !this.connectionANbt.equals((Object)(connectorData = (c = (IWireConnector)class_22482).wireRenderData(network.level(), this.getPointA(), network.level().method_8320(this.getPointA()), this.getCreationDataContext(), true)))) {
            this.connectionANbt = connectorData;
            hasChanged = true;
        }
        if (network.level().method_8477(this.getPointB()) && (connectorData = network.level().method_8320(this.getPointB()).method_26204()) instanceof IWireConnector && !this.connectionBNbt.equals((Object)(connectorData = (c = (IWireConnector)connectorData).wireRenderData(network.level(), this.getPointB(), network.level().method_8320(this.getPointB()), this.getCreationDataContext(), false)))) {
            this.connectionBNbt = connectorData;
            hasChanged = true;
        }
        if (!hasChanged) {
            return false;
        }
        WireConnectionSyncData sync = WireConnectionSyncData.of(this);
        WireCollision collision = new WireCollision(chunkMap, sectionMap, blockMap, this.getId(), this.getPointA(), this.getWireType().buildWire(WireCreationContext.COLLISION, (class_1920)network.level(), sync).getCollisions());
        this.setCollisionData(collision);
        this.setWireConnectionSyncData(sync);
        WiresApi.LOGGER.warn("A wire was misaligned! Data has been corrected. ID: {}, PointA: {}, PointB: {}", new Object[]{this.id, this.pointA, this.pointB});
        return true;
    }

    public UUID getId() {
        return this.id;
    }

    public class_2338 getPointA() {
        return this.pointA;
    }

    public class_2338 getPointB() {
        return this.pointB;
    }

    public IWireType getWireType() {
        return this.wireType;
    }

    public class_2487 getConnectionANbt() {
        return this.connectionANbt;
    }

    public class_2487 getConnectionBNbt() {
        return this.connectionBNbt;
    }

    public class_2487 getCreationDataContext() {
        return this.creationData;
    }

    public void setCollisionData(WireCollision data) {
        this.collisionRef = data;
    }

    public WireCollision getCollisionData() {
        return this.collisionRef;
    }

    public void setWireConnectionSyncData(WireConnectionSyncData data) {
        this.syncData = data;
    }

    public WireConnectionSyncData getWireConnectionSyncData() {
        return this.syncData;
    }

    public class_4076 originChunkSection() {
        return class_4076.method_18682((class_2338)this.pointA);
    }

    public Vector3f getRelativeStart() {
        return this.calcRelative(this.pointA);
    }

    public Vector3f getRelativeEnd() {
        return this.calcRelative(this.pointB);
    }

    public Vector3f calcRelative(class_2338 pos) {
        class_2338 sectionPos = this.originChunkSection().method_19767();
        return new Vector3f((float)(pos.method_10263() - sectionPos.method_10263()), (float)(pos.method_10264() - sectionPos.method_10264()), (float)(pos.method_10260() - sectionPos.method_10260()));
    }

    public int hashCode() {
        return (Integer)this.hashCache.get();
    }
}

