/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import de.mrjulsen.paw.config.ModServerConfig;
import de.mrjulsen.wires.IWireNetwork;
import de.mrjulsen.wires.IWireType;
import de.mrjulsen.wires.WireCollision;
import de.mrjulsen.wires.WireConnection;
import de.mrjulsen.wires.WireCreationContext;
import de.mrjulsen.wires.WiresApi;
import de.mrjulsen.wires.block.IWireConnector;
import de.mrjulsen.wires.network.NetworkManager;
import de.mrjulsen.wires.network.WireChunkLoadingData;
import de.mrjulsen.wires.network.WireConnectionSyncData;
import de.mrjulsen.wires.network.WiresNetworkSyncData;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import org.joml.Vector3f;

public final class WireNetwork
extends class_18
implements IWireNetwork {
    private static final Map<class_2960, WireNetwork> NETWORKS = new HashMap<class_2960, WireNetwork>();
    private static final int VERSION = 1;
    private static final String NBT_CONNECTIONS = "Connections";
    private static final String NBT_VERSION = "NetworkVersion";
    private final class_1937 level;
    private final Multimap<class_1923, UUID> playersWatchingChunk = MultimapBuilder.hashKeys().hashSetValues().build();
    private final Map<UUID, WireConnection> connectionsById = new HashMap<UUID, WireConnection>();
    private final Multimap<class_4076, WireConnection> connectionsBySection = MultimapBuilder.hashKeys().hashSetValues().build();
    private final Multimap<class_2338, WireConnection> connectionsByBlock = MultimapBuilder.hashKeys().hashSetValues().build();
    private final Multimap<Integer, WireConnection> connectionsByHash = MultimapBuilder.hashKeys().hashSetValues().build();
    private final Multimap<class_1923, WireCollision> collisionByChunk = MultimapBuilder.hashKeys().hashSetValues().build();
    private final Multimap<class_4076, WireCollision> collisionBySection = MultimapBuilder.hashKeys().hashSetValues().build();
    private final Multimap<class_2338, WireCollision> collisionByBlock = MultimapBuilder.hashKeys().hashSetValues().build();

    protected WireNetwork(class_1937 level) {
        this.level = level;
        NETWORKS.put(level.method_44013().method_29177(), this);
    }

    public String debug_text() {
        return String.format("Wires[S]: Con: [%s,%s,%s], Col: [%s,%s,%s], P: %s, Id: %s", this.connectionsByBlock.size(), this.connectionsBySection.size(), this.connectionsByHash.size(), this.collisionByChunk.size(), this.collisionBySection.size(), this.collisionByBlock.size(), this.playersWatchingChunk.size(), this.connectionsById.size());
    }

    public static void clear() {
        NETWORKS.clear();
    }

    public static WireNetwork get(class_1937 level) {
        if (!NETWORKS.containsKey(level.method_44013().method_29177())) {
            return new WireNetwork(level);
        }
        return NETWORKS.get(level.method_44013().method_29177());
    }

    public static WireNetwork create(class_3218 level) {
        WireNetwork network = new WireNetwork((class_1937)level);
        WireNetwork.loadLegacy(level).ifPresent(x -> {
            WireNetwork.applyData(network, x);
            network.method_80();
        });
        return network;
    }

    public static WireNetwork load(class_3218 level, class_2487 nbt) {
        WireNetwork network = new WireNetwork((class_1937)level);
        WireNetwork.applyData(network, nbt);
        return network;
    }

    private static void applyData(WireNetwork network, class_2487 nbt) {
        nbt.method_10554(NBT_CONNECTIONS, 10).stream().map(x -> WireConnection.fromNbt((class_2487)x)).forEach(x -> {
            if (x.isPresent()) {
                network.setWireConnection(null, (WireConnection)x.get());
            }
        });
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 connections = new class_2499();
        for (WireConnection connection : this.connectionsByHash.values()) {
            connections.add((Object)connection.toNbt());
        }
        nbt.method_10566(NBT_CONNECTIONS, (class_2520)connections);
        nbt.method_10569(NBT_VERSION, 1);
        return nbt;
    }

    public static String getFileId(class_5321<class_2874> dimension) {
        return "wiresapi_wire_network";
    }

    @Deprecated
    private static Optional<class_2487> loadLegacy(class_3218 overworld) {
        if (overworld != overworld.method_8503().method_30002()) {
            return Optional.empty();
        }
        String path = overworld.method_8503().method_27050(new class_5218("data/pantographsandwires_wire_network.nbt")).toString();
        File settingsFile = new File(path);
        if (!settingsFile.exists()) {
            return Optional.empty();
        }
        try {
            Optional<class_2487> nbt = Optional.ofNullable(class_2507.method_30613((File)settingsFile));
            settingsFile.deleteOnExit();
            return nbt;
        }
        catch (Exception e) {
            WiresApi.LOGGER.error("Unable to load legacy wire network data.", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public class_1937 level() {
        return this.level;
    }

    public Collection<WireConnection> getConnectionsTroughBlock(class_2338 pos) {
        LinkedList<WireConnection> connections = new LinkedList<WireConnection>();
        for (WireCollision c : this.collisionByBlock.get((Object)pos)) {
            connections.add(this.connectionsById.get(c.getId()));
        }
        return connections;
    }

    public Collection<WireConnection> getConnectionsTroughSection(class_4076 pos) {
        LinkedList<WireConnection> connections = new LinkedList<WireConnection>();
        for (WireCollision c : this.collisionBySection.get((Object)pos)) {
            connections.add(this.connectionsById.get(c.getId()));
        }
        return connections;
    }

    public Collection<WireConnection> getConnectionsTroughChunk(class_1923 pos) {
        LinkedList<WireConnection> connections = new LinkedList<WireConnection>();
        for (WireCollision c : this.collisionByChunk.get((Object)pos)) {
            connections.add(this.connectionsById.get(c.getId()));
        }
        return connections;
    }

    public Collection<WireCollision> getCollisionsTroughBlock(class_2338 pos) {
        return this.collisionByBlock.get((Object)pos);
    }

    public Collection<WireCollision> getCollisionsTroughSection(class_4076 pos) {
        return this.collisionBySection.get((Object)pos);
    }

    public Collection<WireCollision> getCollisionsTroughChunk(class_1923 pos) {
        return this.collisionByChunk.get((Object)pos);
    }

    public Collection<WireCollision.WireBlockCollision> getCollisionsInBlock(class_2338 pos) {
        LinkedList<WireCollision.WireBlockCollision> connections = new LinkedList<WireCollision.WireBlockCollision>();
        for (WireCollision c : this.collisionByBlock.get((Object)pos)) {
            connections.addAll(c.collisionsInBlock(pos));
        }
        return connections;
    }

    public synchronized boolean addConnection(class_1937 level, class_2487 itemData, class_2338 posA, class_2338 posB, IWireConnector connectorA, IWireConnector connectorB, IWireType wireType) {
        class_2487 connectionANbt = connectorA.wireRenderData(level, posA, level.method_8320(posA), itemData, true);
        class_2487 connectionBNbt = connectorB.wireRenderData(level, posB, level.method_8320(posB), itemData, false);
        WireConnection wireConnection = this.createWireConnection(posA, posB, wireType, connectionANbt, connectionBNbt, itemData);
        if (!wireType.allowMultiConnections() && this.connectionsByHash.containsKey((Object)wireConnection.hashCode())) {
            return false;
        }
        return this.setWireConnection(level, wireConnection);
    }

    protected synchronized boolean setWireConnection(@Nullable class_1937 level, WireConnection wireConnection) {
        this.connectionsById.put(wireConnection.getId(), wireConnection);
        this.connectionsByBlock.put((Object)wireConnection.getPointA(), (Object)wireConnection);
        this.connectionsByBlock.put((Object)wireConnection.getPointB(), (Object)wireConnection);
        this.connectionsBySection.put((Object)class_4076.method_18682((class_2338)wireConnection.getPointA()), (Object)wireConnection);
        this.connectionsBySection.put((Object)class_4076.method_18682((class_2338)wireConnection.getPointB()), (Object)wireConnection);
        this.connectionsByHash.put((Object)wireConnection.hashCode(), (Object)wireConnection);
        WireConnectionSyncData syncData = WireConnectionSyncData.of(wireConnection);
        WireCollision collision = new WireCollision(this.collisionByChunk, this.collisionBySection, this.collisionByBlock, wireConnection.getId(), wireConnection.getPointA(), wireConnection.getWireType().buildWire(WireCreationContext.COLLISION, (class_1920)level, syncData).getCollisions());
        wireConnection.setCollisionData(collision);
        wireConnection.setWireConnectionSyncData(syncData);
        if (level != null) {
            WiresNetworkSyncData netData = new WiresNetworkSyncData(null, List.of(new WiresNetworkSyncData.WireSyncDataEntry(syncData, true)));
            HashSet updatePlayers = new HashSet();
            for (class_4076 section : collision.sectionsIn()) {
                updatePlayers.addAll(this.playersWatchingChunk.get((Object)section.method_18692()));
            }
            for (UUID playerId : updatePlayers) {
                class_1657 class_16572 = level.method_18470(playerId);
                if (!(class_16572 instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)class_16572;
                DataAccessor.getFromClient((class_3222)serverPlayer, (Object)netData, NetworkManager.WIRE_CONNECTOR_DATA_TRANSFER, $ -> {});
            }
        }
        this.method_80();
        return true;
    }

    private synchronized WireConnection createWireConnection(class_2338 posA, class_2338 posB, IWireType wireType, class_2487 connectionANbt, class_2487 connectionBNbt, class_2487 itemData) {
        UUID id;
        while (this.connectionsById.containsKey(id = UUID.randomUUID())) {
        }
        WireConnection wireConnection = new WireConnection(id, posA, posB, wireType, connectionANbt, connectionBNbt, itemData);
        return wireConnection;
    }

    public synchronized void removeConnector(class_1937 level, class_2338 pos) {
        if (!this.connectionsByBlock.containsKey((Object)pos)) {
            return;
        }
        Collection blockConnections = this.connectionsByBlock.removeAll((Object)pos);
        HashSet<UUID> updatePlayers = new HashSet<UUID>();
        for (WireConnection connection : blockConnections) {
            updatePlayers.addAll(this.removeWireConnection(connection));
        }
        for (UUID playerId : updatePlayers) {
            class_1657 class_16572 = level.method_18470(playerId);
            if (!(class_16572 instanceof class_3222)) continue;
            class_3222 serverPlayer = (class_3222)class_16572;
            DataAccessor.getFromClient((class_3222)serverPlayer, (Object)((UUID[])blockConnections.stream().map(x -> x.getId()).toArray(UUID[]::new)), NetworkManager.DELETE_WIRE_CONNECTION, $ -> {});
        }
        this.method_80();
    }

    private synchronized Set<UUID> removeWireConnection(UUID connection) {
        return this.removeWireConnection(this.connectionsById.get(connection));
    }

    private synchronized Set<UUID> removeWireConnection(WireConnection connection) {
        HashSet<UUID> updatePlayers = new HashSet<UUID>();
        this.collisionByBlock.values().removeIf(x -> x.getId().equals(connection.getId()));
        this.collisionByChunk.values().removeIf(x -> x.getId().equals(connection.getId()));
        this.collisionBySection.values().removeIf(x -> x.getId().equals(connection.getId()));
        this.connectionsByBlock.values().removeIf(x -> x == connection);
        this.connectionsBySection.values().removeIf(x -> x == connection);
        this.connectionsByHash.values().removeIf(x -> x == connection);
        this.connectionsById.remove(connection.getId());
        for (class_4076 section : connection.getCollisionData().sectionsIn()) {
            class_1923 chunk = section.method_18692();
            if (!this.playersWatchingChunk.containsKey((Object)chunk)) continue;
            updatePlayers.addAll(this.playersWatchingChunk.get((Object)chunk));
        }
        this.method_80();
        return updatePlayers;
    }

    public synchronized void removeBlockedConnection(class_1937 level, class_2338 pos) {
        if (!this.collisionByBlock.containsKey((Object)pos)) {
            return;
        }
        Collection collisionsByBlock = this.collisionByBlock.removeAll((Object)pos);
        HashSet<UUID> updatePlayers = new HashSet<UUID>();
        for (WireCollision connection : collisionsByBlock) {
            updatePlayers.addAll(this.removeWireConnection(connection.getId()));
        }
        for (UUID playerId : updatePlayers) {
            class_1657 class_16572 = level.method_18470(playerId);
            if (!(class_16572 instanceof class_3222)) continue;
            class_3222 serverPlayer = (class_3222)class_16572;
            DataAccessor.getFromClient((class_3222)serverPlayer, (Object)((UUID[])collisionsByBlock.stream().toArray(UUID[]::new)), NetworkManager.DELETE_WIRE_CONNECTION, $ -> {});
        }
        this.method_80();
    }

    public void notifyBlockUpdate(class_1937 level, class_2338 pos, class_2680 newState, int flags) {
        if (((Boolean)ModServerConfig.BLOCKS_BREAK_WIRES.get()).booleanValue() && !level.method_8608() && !newState.method_26220((class_1922)level, pos).method_1110()) {
            Collection<WireConnection> connections = this.getConnectionsTroughBlock(pos);
            if (connections.isEmpty()) {
                return;
            }
            HashMap<WireConnection, class_2338> connectionsToBreak = new HashMap<WireConnection, class_2338>();
            for (WireConnection connection : connections) {
                Collection<WireCollision.WireBlockCollision> collisions = connection.getCollisionData().collisionsInBlock(pos);
                for (WireCollision.WireBlockCollision collision : collisions) {
                    Vector3f vecA = collision.entryPointA();
                    Vector3f vecB = collision.entryPointB();
                    class_2338 dropPos = pos;
                    if (!WireCollision.connectionBlocked(level, pos, newState, vecA, vecB)) continue;
                    for (class_2350 d : class_2350.values()) {
                        if (!level.method_22347(pos.method_10093(d))) continue;
                        dropPos = dropPos.method_10093(d);
                        break;
                    }
                    connectionsToBreak.put(connection, dropPos);
                }
            }
            HashSet<UUID> updatePlayers = new HashSet<UUID>();
            for (Map.Entry connection : connectionsToBreak.entrySet()) {
                updatePlayers.addAll(this.removeWireConnection((WireConnection)connection.getKey()));
            }
            for (UUID playerId : updatePlayers) {
                class_1657 class_16572 = level.method_18470(playerId);
                if (!(class_16572 instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)class_16572;
                DataAccessor.getFromClient((class_3222)serverPlayer, (Object)((UUID[])connectionsToBreak.keySet().stream().map(x -> x.getId()).toArray(UUID[]::new)), NetworkManager.DELETE_WIRE_CONNECTION, $ -> {});
            }
        }
    }

    public void checkEntityCollision(class_1937 level, class_2338 pos, class_1297 entity) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChunkLoad(class_1937 level, class_1923 pos, class_1657 player) {
        this.playersWatchingChunk.put((Object)pos, (Object)player.method_5667());
        Multimap<class_1923, WireCollision> multimap = this.collisionByChunk;
        synchronized (multimap) {
            if (this.collisionByChunk.containsKey((Object)pos) && player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                ArrayList<WireConnection> connections = new ArrayList<WireConnection>(this.getConnectionsTroughChunk(pos));
                ArrayList<WiresNetworkSyncData.WireSyncDataEntry> syncData = new ArrayList<WiresNetworkSyncData.WireSyncDataEntry>(connections.size());
                for (WireConnection connection : connections) {
                    boolean b = connection.recalcAttachPoints(this, this.collisionByChunk, this.collisionBySection, this.collisionByBlock);
                    syncData.add(new WiresNetworkSyncData.WireSyncDataEntry(connection.getWireConnectionSyncData(), b));
                }
                DataAccessor.getFromClient((class_3222)serverPlayer, (Object)new WiresNetworkSyncData(pos, syncData), NetworkManager.WIRE_CONNECTOR_DATA_TRANSFER, $ -> {});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChunkUnload(class_1937 level, class_1923 pos, class_1657 player) {
        if (this.playersWatchingChunk.containsKey((Object)pos)) {
            this.playersWatchingChunk.get((Object)pos).removeIf(x -> x.equals(player.method_5667()));
        }
        Multimap<class_1923, WireCollision> multimap = this.collisionByChunk;
        synchronized (multimap) {
            if (this.collisionByChunk.containsKey((Object)pos) && player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                Collection<WireConnection> connections = this.getConnectionsTroughChunk(pos);
                if (connections.isEmpty()) {
                    return;
                }
                DataAccessor.getFromClient((class_3222)serverPlayer, (Object)new WireChunkLoadingData(pos, connections.stream().map(WireConnection::getId).collect(Collectors.toSet()), false), NetworkManager.WIRE_CONNECTION_CHUNK_LOADING, $ -> {});
            }
        }
    }
}

