/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires;

import de.mrjulsen.wires.IWireType;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import net.minecraft.class_2960;

public class WireTypeRegistry {
    private static final Map<class_2960, IWireType> registeredTypes = new HashMap<class_2960, IWireType>();

    public static IWireType register(String modid, String name, Function<class_2960, IWireType> type) {
        class_2960 location = new class_2960(modid, name);
        if (registeredTypes.containsKey(location)) {
            throw new IllegalArgumentException("A wire with ID '" + location.toString() + "' is already registered.");
        }
        IWireType wire = type.apply(location);
        registeredTypes.put(location, wire);
        return wire;
    }

    public static IWireType get(class_2960 id) {
        if (!WireTypeRegistry.has(id)) {
            throw new NoSuchElementException("There is no wire type with id '" + String.valueOf(id) + "' registered.");
        }
        return registeredTypes.get(id);
    }

    public static boolean has(class_2960 id) {
        return registeredTypes.containsKey(id);
    }
}

