/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.debug;

import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.wires.WireClientNetwork;
import de.mrjulsen.wires.WireCollision;
import de.mrjulsen.wires.WireConnection;
import de.mrjulsen.wires.WireNetwork;
import de.mrjulsen.wires.util.ClientUtils;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_1923;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class WireDebugRenderer {
    private static final Deque<Pair<Vector3f, Vector3f>> highlightedWires = new ConcurrentLinkedDeque<Pair<Vector3f, Vector3f>>();

    public static boolean enabled() {
        return class_310.method_1551().method_1561().method_3958();
    }

    public static void renderWireCollisions(class_4587 poseStack) {
        if (!WireDebugRenderer.enabled()) {
            if (!highlightedWires.isEmpty()) {
                highlightedWires.clear();
            }
            return;
        }
        class_243 cameraPos = class_310.method_1551().field_1773.method_19418().method_19326();
        class_1297 entity = class_310.method_1551().field_1773.method_19418().method_19331();
        class_1923 chunkPos = entity.method_31476();
        poseStack.method_22903();
        poseStack.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        class_4597.class_4598 mbs = class_310.method_1551().method_22940().method_23000();
        class_4588 buffer = mbs.getBuffer(class_1921.method_23594());
        for (int a = -2; a <= 2; ++a) {
            for (int b = -2; b <= 2; ++b) {
                class_1923 relPos = new class_1923(chunkPos.field_9181 + a, chunkPos.field_9180 + b);
                for (WireConnection connection : WireNetwork.get(ClientUtils.level()).getConnectionsTroughChunk(relPos)) {
                    if (connection == null) continue;
                    for (WireCollision.WireBlockCollision c : connection.getCollisionData().getAllCollisions()) {
                        WireDebugRenderer.renderDebugLine(poseStack, buffer, new Vector3f(c.absA().x(), c.absA().y() + 0.01f, c.absA().z()), new Vector3f(c.absB().x(), c.absB().y() + 0.01f, c.absB().z()), 1.0f, 0.0f, 0.0f, 1.0f);
                    }
                }
                for (WireCollision collision : WireClientNetwork.get(ClientUtils.level()).getCollisionsTroughChunk(relPos)) {
                    for (WireCollision.WireBlockCollision c : collision.getAllCollisions()) {
                        WireDebugRenderer.renderDebugLine(poseStack, buffer, new Vector3f(c.absA().x(), c.absA().y(), c.absA().z()), new Vector3f(c.absB().x(), c.absB().y(), c.absB().z()), 0.0f, 0.0f, 1.0f, 1.0f);
                    }
                }
            }
        }
        while (!highlightedWires.isEmpty()) {
            Pair<Vector3f, Vector3f> p = highlightedWires.pollFirst();
            WireDebugRenderer.renderDebugLine(poseStack, buffer, new Vector3f((Vector3fc)p.getFirst()).sub(0.0f, 0.01f, 0.0f), new Vector3f((Vector3fc)p.getSecond()).sub(0.0f, 0.01f, 0.0f), 0.0f, 1.0f, 0.0f, 1.0f);
        }
        poseStack.method_22909();
    }

    public static void highlightWire(Vector3f a, Vector3f b) {
        if (!WireDebugRenderer.enabled()) {
            return;
        }
        highlightedWires.addLast((Pair<Vector3f, Vector3f>)Pair.of((Object)a, (Object)b));
    }

    public static void renderDebugLine(class_4587 poseStack, class_4588 consumer, Vector3f from, Vector3f to, float r, float g, float b, float a) {
        float dz;
        float dy;
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        Matrix3f matrix3f = poseStack.method_23760().method_23762();
        float dx = to.x() - from.x();
        float length = (float)Math.sqrt(dx * dx + (dy = to.y() - from.y()) * dy + (dz = to.z() - from.z()) * dz);
        if (length > 0.0f) {
            dx /= length;
            dy /= length;
            dz /= length;
        }
        consumer.method_22918(matrix4f, from.x(), from.y(), from.z()).method_22915(r, g, b, a).method_23763(matrix3f, dx, dy, dz).method_1344();
        consumer.method_22918(matrix4f, to.x(), to.y(), to.z()).method_22915(r, g, b, a).method_23763(matrix3f, dx, dy, dz).method_1344();
    }
}

