/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.network;

import de.mrjulsen.wires.WireConnection;
import de.mrjulsen.wires.util.Utils;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_4076;
import org.joml.Vector3f;

public class WireConnectionSyncData {
    private static final String NBT_CONNECTION_ID = "Id";
    private static final String NBT_BLOCK_START = "StartBlock";
    private static final String NBT_BLOCK_END = "EndBlock";
    private static final String NBT_START = "Start";
    private static final String NBT_END = "End";
    private static final String NBT_WIRE_TYPE = "WireType";
    private static final String NBT_CONNECTOR_A_DATA = "ConnectorA";
    private static final String NBT_CONNECTOR_B_DATA = "ConnectorB";
    private static final String NBT_CREATION_DATA = "CreationData";
    private static final String NBT_ORIGIN_CHUNK_SECTION = "OriginChunkSection";
    private final UUID connectionId;
    private final Vector3f startPos;
    private final Vector3f endPos;
    private final class_2338 startBlockPos;
    private final class_2338 endBlockPos;
    private final class_2960 wireType;
    private final class_2487 connectorAData;
    private final class_2487 connectorBData;
    private final class_2487 creationData;
    private final class_4076 originChunkSection;

    public WireConnectionSyncData(UUID connectionId, class_2338 startBlockPos, class_2338 endBlockPos, Vector3f startPos, Vector3f endPos, class_2960 wireType, class_2487 connectorAData, class_2487 connectorBData, class_2487 creationData, class_4076 originChunkSection) {
        this.connectionId = connectionId;
        this.startBlockPos = startBlockPos;
        this.endBlockPos = endBlockPos;
        this.startPos = startPos;
        this.endPos = endPos;
        this.wireType = wireType;
        this.connectorAData = connectorAData;
        this.connectorBData = connectorBData;
        this.creationData = creationData;
        this.originChunkSection = originChunkSection;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_25927(NBT_CONNECTION_ID, this.connectionId);
        Utils.putNbtBlockPos(nbt, NBT_BLOCK_START, this.startBlockPos);
        Utils.putNbtBlockPos(nbt, NBT_BLOCK_END, this.endBlockPos);
        Utils.putNbtVector3f(nbt, NBT_START, this.startPos);
        Utils.putNbtVector3f(nbt, NBT_END, this.endPos);
        nbt.method_10582(NBT_WIRE_TYPE, this.wireType.toString());
        nbt.method_10566(NBT_CONNECTOR_A_DATA, (class_2520)this.connectorAData);
        nbt.method_10566(NBT_CONNECTOR_B_DATA, (class_2520)this.connectorBData);
        nbt.method_10566(NBT_CREATION_DATA, (class_2520)this.creationData);
        Utils.putNbtSectionPos(nbt, NBT_ORIGIN_CHUNK_SECTION, this.originChunkSection);
        return nbt;
    }

    public static WireConnectionSyncData fromNbt(class_2487 nbt) {
        return new WireConnectionSyncData(nbt.method_25926(NBT_CONNECTION_ID), Utils.getNbtBlockPos(nbt, NBT_BLOCK_START), Utils.getNbtBlockPos(nbt, NBT_BLOCK_END), Utils.getNbtVector3f(nbt, NBT_START), Utils.getNbtVector3f(nbt, NBT_END), Utils.resLoc(nbt.method_10558(NBT_WIRE_TYPE)), nbt.method_10562(NBT_CONNECTOR_A_DATA), nbt.method_10562(NBT_CONNECTOR_B_DATA), nbt.method_10562(NBT_CREATION_DATA), Utils.getNbtSectionPos(nbt, NBT_ORIGIN_CHUNK_SECTION));
    }

    public static WireConnectionSyncData of(WireConnection wireConnection) {
        return new WireConnectionSyncData(wireConnection.getId(), wireConnection.getPointA(), wireConnection.getPointB(), wireConnection.getRelativeStart(), wireConnection.getRelativeEnd(), wireConnection.getWireType().getRegistryId(), wireConnection.getConnectionANbt(), wireConnection.getConnectionBNbt(), wireConnection.getCreationDataContext(), wireConnection.originChunkSection());
    }

    public UUID getConnectionId() {
        return this.connectionId;
    }

    public Vector3f getStartPos() {
        return this.startPos;
    }

    public Vector3f getEndPos() {
        return this.endPos;
    }

    public class_2338 getStartBlockPos() {
        return this.startBlockPos;
    }

    public class_2338 getEndBlockPos() {
        return this.endBlockPos;
    }

    public class_2960 getWireType() {
        return this.wireType;
    }

    public class_2487 getConnectorAData() {
        return this.connectorAData;
    }

    public class_2487 getConnectorBData() {
        return this.connectorBData;
    }

    public class_2487 getCreationData() {
        return this.creationData;
    }

    public class_4076 getOriginChunkSection() {
        return this.originChunkSection;
    }

    public Vector3f getWireAttachPointA() {
        return Utils.getNbtVector3f(this.getConnectorAData(), "WireAttachPoint");
    }

    public Vector3f getWireAttachPointB() {
        return Utils.getNbtVector3f(this.getConnectorBData(), "WireAttachPoint");
    }
}

