/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity;

import com.mojang.logging.LogUtils;
import com.yuushya.modelling.blockentity.TransformType;
import com.yuushya.modelling.blockentity.showblock.ShowBlock;
import com.yuushya.modelling.blockentity.showblock.ShowBlockEntity;
import dev.architectury.networking.NetworkChannel;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.slf4j.Logger;

public class TransformDataNetwork {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final class_2960 TRANSFORM_DATA_PACKET_ID = new class_2960("yuushya_modelling", "transform_data_packet");
    public static final NetworkChannel INSTANCE = NetworkChannel.create((class_2960)TRANSFORM_DATA_PACKET_ID);

    public static void sendToServerSide(class_2338 blockPos, int slot, TransformType type, double number) {
        INSTANCE.sendToServer((Object)new TransformDataOncePacket(blockPos, type, slot, number));
    }

    public static void sendToServerSideSuccess(class_2338 blockPos) {
        TransformDataNetwork.sendToServerSide(blockPos, 0, TransformType.SUCCESS, 0.0);
    }

    public static void registerChannel() {
        INSTANCE.register(TransformDataOncePacket.class, TransformDataOncePacket::encoder, TransformDataOncePacket::decoder, TransformDataOncePacket::handler);
    }

    public static void sendToServerSideLegacy(class_2338 blockPos, int slot, TransformType type, double number) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        new TransformDataOncePacket(blockPos, type, slot, number).encoder(buf);
        NetworkManager.sendToServer((class_2960)TRANSFORM_DATA_PACKET_ID, (class_2540)buf);
    }

    public static void registerServerSideReceiverLegacy() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)TRANSFORM_DATA_PACKET_ID, (buf, context) -> {
            TransformDataOncePacket packet = TransformDataOncePacket.decoder(buf);
            packet.handler(() -> context);
        });
    }

    public record TransformDataOncePacket(class_2338 blockPos, TransformType transformType, int slot, double number) {
        public static TransformDataOncePacket decoder(class_2540 buf) {
            return new TransformDataOncePacket(buf.method_10811(), TransformType.from(buf.readByte()), buf.readByte(), buf.readDouble());
        }

        public void encoder(class_2540 buf) {
            buf.method_10807(this.blockPos);
            buf.writeByte(this.transformType.type);
            buf.writeByte(this.slot);
            buf.writeDouble(this.number);
        }

        public void handler(Supplier<NetworkManager.PacketContext> ctx) {
            ctx.get().queue(() -> {
                class_3218 serverLevel;
                class_1937 level = ((NetworkManager.PacketContext)ctx.get()).getPlayer().method_37908();
                if (level instanceof class_3218 && (serverLevel = (class_3218)level).method_22340(this.blockPos) && serverLevel.method_8320(this.blockPos).method_26204() instanceof ShowBlock) {
                    class_2586 blockEntity = serverLevel.method_8321(this.blockPos);
                    if (!(blockEntity instanceof ShowBlockEntity)) {
                        return;
                    }
                    ShowBlockEntity showBlockEntity = (ShowBlockEntity)blockEntity;
                    this.transformType.modify(showBlockEntity, this.slot, this.number);
                }
            });
        }
    }
}

