/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity;

import com.yuushya.modelling.block.blockstate.YuushyaBlockStates;
import com.yuushya.modelling.blockentity.TransformData;
import com.yuushya.modelling.blockentity.showblock.ShowBlockEntity;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public enum TransformType {
    POS_X(0),
    POS_Y(1),
    POS_Z(2),
    ROT_X(3),
    ROT_Y(4),
    ROT_Z(5),
    SCALE_X(6),
    SCALE_Y(7),
    SCALE_Z(8),
    BLOCK_STATE(9),
    SHOWN(10),
    LIT(11),
    REMOVE(12),
    SUCCESS(13),
    FAIL(14);

    public final int type;

    private TransformType(int i) {
        this.type = i;
    }

    public static TransformType from(int i) {
        return switch (i) {
            case 0 -> POS_X;
            case 1 -> POS_Y;
            case 2 -> POS_Z;
            case 3 -> ROT_X;
            case 4 -> ROT_Y;
            case 5 -> ROT_Z;
            case 6 -> SCALE_X;
            case 7 -> SCALE_Y;
            case 8 -> SCALE_Z;
            case 9 -> BLOCK_STATE;
            case 10 -> SHOWN;
            case 11 -> LIT;
            case 12 -> REMOVE;
            case 13 -> SUCCESS;
            default -> FAIL;
        };
    }

    public double extract(TransformData transformData) {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> transformData.pos.x();
            case 1 -> transformData.pos.y();
            case 2 -> transformData.pos.z();
            case 3 -> transformData.rot.x();
            case 4 -> transformData.rot.y();
            case 5 -> transformData.rot.z();
            case 6 -> transformData.scales.x();
            case 7 -> transformData.scales.y();
            case 8 -> transformData.scales.z();
            case 9 -> class_2248.method_9507((class_2680)transformData.blockState);
            case 10 -> {
                if (transformData.isShown) {
                    yield 1.0;
                }
                yield 0.0;
            }
            case 11, 12, 13, 14 -> 0.0;
        };
    }

    public void modify(TransformData transformData, Double number) {
        switch (this.ordinal()) {
            case 0: {
                transformData.pos.set(number.doubleValue(), transformData.pos.y(), transformData.pos.z());
                break;
            }
            case 1: {
                transformData.pos.set(transformData.pos.x(), number.doubleValue(), transformData.pos.z());
                break;
            }
            case 2: {
                transformData.pos.set(transformData.pos.x(), transformData.pos.y(), number.doubleValue());
                break;
            }
            case 3: {
                transformData.rot.set(number.doubleValue(), (double)transformData.rot.y(), (double)transformData.rot.z());
                break;
            }
            case 4: {
                transformData.rot.set((double)transformData.rot.x(), number.doubleValue(), (double)transformData.rot.z());
                break;
            }
            case 5: {
                transformData.rot.set((double)transformData.rot.x(), (double)transformData.rot.y(), number.doubleValue());
                break;
            }
            case 6: {
                transformData.scales.set(number.doubleValue(), (double)transformData.scales.y(), (double)transformData.scales.z());
                break;
            }
            case 7: {
                transformData.scales.set((double)transformData.scales.x(), number.doubleValue(), (double)transformData.scales.z());
                break;
            }
            case 8: {
                transformData.scales.set((double)transformData.scales.x(), (double)transformData.scales.y(), number.doubleValue());
                break;
            }
            case 9: {
                transformData.blockState = class_2248.method_9531((int)((int)Math.round(number)));
                break;
            }
            case 10: {
                transformData.isShown = number != 0.0;
                break;
            }
        }
    }

    public double extract(ShowBlockEntity showBlockEntity, int slot) {
        if (this == LIT) {
            return ((Integer)showBlockEntity.method_11010().method_11654((class_2769)YuushyaBlockStates.LIT)).intValue();
        }
        return this.extract(showBlockEntity.getTransformData(slot));
    }

    public void modify(ShowBlockEntity showBlockEntity, int slot, double number) {
        if (this == SUCCESS) {
            showBlockEntity.saveChanged();
            return;
        }
        if (this == LIT) {
            class_1937 level = showBlockEntity.method_10997();
            level.method_8652(showBlockEntity.method_11016(), (class_2680)showBlockEntity.method_11010().method_11657((class_2769)YuushyaBlockStates.LIT, (Comparable)Integer.valueOf((int)Math.round(number))), 18);
            return;
        }
        if (this == REMOVE) {
            showBlockEntity.removeTransformData(slot);
            return;
        }
        showBlockEntity.setSlot(slot);
        this.modify(showBlockEntity.getTransformData(slot), number);
    }
}

