/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.gui;

import com.yuushya.modelling.gui.validate.ValidateRange;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_5244;
import net.minecraft.class_7172;

public class SliderButton<T extends Comparable<T>>
extends class_357 {
    private final class_7172.class_7303<T> captionBasedToString;
    private final T initialValue;
    private final class_2561 caption;
    private final ValidateRange<T> validateRange;
    private final class_7172.class_7277<T> tooltipSupplier;
    private final Consumer<SliderButton<T>> onMouseOver;
    private final Consumer<T> onValueChanged;

    public class_2561 getCaption() {
        return this.caption;
    }

    public SliderButton(class_2561 caption, int x, int y, int width, int height, class_7172.class_7277<T> tooltipSupplier, class_7172.class_7303<T> captionBasedToString, ValidateRange<T> validateRange, T initialValue, Consumer<SliderButton<T>> onMouseOver, Consumer<T> onValueChanged) {
        super(x, y, width, height, class_5244.field_39003, validateRange.toSliderValue(initialValue));
        this.caption = caption;
        this.initialValue = initialValue;
        this.validateRange = validateRange;
        this.tooltipSupplier = tooltipSupplier;
        this.captionBasedToString = captionBasedToString;
        this.onMouseOver = onMouseOver;
        this.onValueChanged = onValueChanged;
        this.method_25346();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (this.field_22762) {
            this.onMouseOver.accept(this);
        }
    }

    protected void method_25346() {
        Comparable value = (Comparable)this.validateRange.fromSliderValue(this.field_22753);
        Comparable object = this.validateRange.validateValue(value).orElseGet(() -> this.initialValue);
        this.method_25355(this.captionBasedToString.toString(this.caption, (Object)object));
        this.method_47400(this.tooltipSupplier.apply((Object)object));
    }

    protected void method_25344() {
        Comparable value = (Comparable)this.validateRange.fromSliderValue(this.field_22753);
        Comparable object = this.validateRange.validateValue(value).orElseGet(() -> this.initialValue);
        this.onValueChanged.accept(object);
    }

    public static <R extends Comparable<R>> Builder<R> builder(class_2561 caption, ValidateRange<R> validateRange, Consumer<R> onValueChanged) {
        return new Builder<R>(caption, validateRange, onValueChanged);
    }

    public void setValidatedValue(T value) {
        this.setValue(this.validateRange.toSliderValue(value));
    }

    public void setInitialValidatedValue(T value) {
        this.field_22753 = this.validateRange.toSliderValue(value);
        this.method_25346();
    }

    public T getValidatedValue() {
        return (T)((Comparable)this.validateRange.fromSliderValue(this.field_22753));
    }

    public void setValue(double value) {
        double d = this.field_22753;
        this.field_22753 = class_3532.method_15350((double)value, (double)0.0, (double)1.0);
        if (d != this.field_22753) {
            this.method_25344();
        }
        this.method_25346();
    }

    public void setStep(T step) {
        this.validateRange.setStep(step);
    }

    public T getStep() {
        return this.validateRange.getStep();
    }

    public static class Builder<R extends Comparable<R>> {
        private int x;
        private int y;
        private int width = 150;
        private int height = 20;
        private class_7172.class_7303<R> captionBasedToString = (caption, number) -> caption;
        private class_7172.class_7277<R> tooltipSupplier = class_7172.method_42399();
        private R initialValue;
        private final class_2561 caption;
        private final ValidateRange<R> validateRange;
        private final Consumer<R> onValueChanged;
        private Consumer<SliderButton<R>> onMouseOver = btn -> {};
        private R step;

        public Builder(class_2561 caption2, ValidateRange<R> validateRange, Consumer<R> onValueChanged) {
            this.caption = caption2;
            this.onValueChanged = onValueChanged;
            this.validateRange = validateRange;
            this.initialValue = validateRange.defaultValue();
        }

        public Builder<R> pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder<R> width(int width) {
            this.width = width;
            return this;
        }

        public Builder<R> size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder<R> bounds(int x, int y, int width, int height) {
            return this.pos(x, y).size(width, height);
        }

        public Builder<R> text(class_7172.class_7303<R> textCalculate) {
            this.captionBasedToString = textCalculate;
            return this;
        }

        public Builder<R> tooltip(class_7172.class_7277<R> tooltipSupplier) {
            this.tooltipSupplier = tooltipSupplier;
            return this;
        }

        public Builder<R> onMouseOver(Consumer<SliderButton<R>> onMouseOver) {
            this.onMouseOver = onMouseOver;
            return this;
        }

        public Builder<R> initial(R number) {
            this.initialValue = number;
            return this;
        }

        public Builder<R> step(R step) {
            this.step = step;
            return this;
        }

        public SliderButton<R> build() {
            this.validateRange.setStep(this.step);
            return new SliderButton<R>(this.caption, this.x, this.y, this.width, this.height, this.tooltipSupplier, this.captionBasedToString, this.validateRange, this.initialValue, this.onMouseOver, this.onValueChanged);
        }
    }
}

