/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.gui.engrave;

import com.yuushya.modelling.gui.engrave.EngraveItemResult;
import com.yuushya.modelling.gui.engrave.EngraveMenu;
import com.yuushya.modelling.registries.YuushyaRegistries;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class TransformDataListNetwork {
    public static final class_2960 TRANSFORM_DATA_LIST_PACKET_ID = new class_2960("yuushya_modelling", "transform_data_list_packet");
    private static final Map<String, class_1799> HandlingCache = new HashMap<String, class_1799>();
    public static final Set<String> SendingCache = new HashSet<String>();

    public static void updateSendingCache(String name) {
        SendingCache.remove(name);
    }

    public static void sendToServerSide(EngraveItemResult itemResult) {
        class_2487 tag;
        String name = itemResult.getName();
        if (SendingCache.contains(name)) {
            tag = new class_2487();
        } else {
            class_1799 itemStack = itemResult.getResultItem();
            tag = itemStack.method_7911("BlockEntityTag");
        }
        tag.method_10582("ItemName", name);
        class_2540 buf = new class_2540(Unpooled.buffer());
        new TransformDataListPacket(tag).encoder(buf);
        NetworkManager.sendToServer((class_2960)TRANSFORM_DATA_LIST_PACKET_ID, (class_2540)buf);
    }

    public static void registerServerSideReceiver() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)TRANSFORM_DATA_LIST_PACKET_ID, (buf, context) -> {
            TransformDataListPacket packet = TransformDataListPacket.decoder(buf);
            packet.handler(() -> context);
        });
    }

    public record TransformDataListPacket(class_2487 tag) {
        public static TransformDataListPacket decoder(class_2540 buf) {
            return new TransformDataListPacket(buf.method_10798());
        }

        public void encoder(class_2540 buf) {
            buf.method_10794(this.tag);
        }

        public void handler(Supplier<NetworkManager.PacketContext> ctx) {
            ctx.get().queue(() -> {
                class_1657 player = ((NetworkManager.PacketContext)ctx.get()).getPlayer();
                class_1703 abstractContainerMenu = player.field_7512;
                if (abstractContainerMenu instanceof EngraveMenu) {
                    EngraveMenu menu = (EngraveMenu)abstractContainerMenu;
                    if (!menu.method_7597(player)) {
                        return;
                    }
                    String name = this.tag.method_10558("ItemName");
                    String hash = player.method_5845() + name;
                    if (!this.tag.method_10545("Blocks") && HandlingCache.containsKey(hash)) {
                        menu.setupResultSlotServer(HandlingCache.get(hash));
                    } else {
                        class_1799 itemStack = ((class_1792)YuushyaRegistries.ITEMS.get("showblock").get()).method_7854();
                        itemStack.method_7959("BlockEntityTag", (class_2520)this.tag);
                        itemStack.method_7977((class_2561)class_2561.method_43470((String)name));
                        HandlingCache.put(hash, itemStack);
                        menu.setupResultSlotServer(itemStack);
                    }
                }
            });
        }
    }
}

