/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.gui.showblock;

import com.yuushya.modelling.blockentity.TransformData;
import com.yuushya.modelling.gui.showblock.ShowBlockScreen;
import com.yuushya.modelling.registries.YuushyaRegistries;
import com.yuushya.modelling.utils.YuushyaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1087;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;

public class BlockStateIconList
extends class_4280<Entry> {
    protected final List<TransformData> transformDataList;
    protected final List<Entry> chosen = new ArrayList<Entry>();
    protected final ShowBlockScreen screen;
    private int itemHeight;
    private int itemWidth;
    private final Map<Integer, class_5250> rememberDisplayName = new HashMap<Integer, class_5250>();
    private final Map<Integer, List<String>> rememberBlockStateProperties = new HashMap<Integer, List<String>>();
    private final Map<Integer, class_1799> rememberItemStack = new HashMap<Integer, class_1799>();
    private final Map<Integer, Collection<class_2769<?>>> rememberProperties = new HashMap();

    public BlockStateIconList(class_310 minecraft, int width, int height, int x, int y0, int y1, int itemWidth, int itemHeight, List<TransformData> transformDataList, ShowBlockScreen showBlockScreen) {
        super(minecraft, width, height, y0, y1, itemHeight);
        this.method_25333(x);
        this.transformDataList = transformDataList;
        this.screen = showBlockScreen;
        this.field_22744 = false;
        this.method_31323(false);
        this.method_31322(false);
        this.itemWidth = itemWidth;
        this.itemHeight = itemHeight;
        this.updateRenderList();
    }

    public class_5250 updateRenderDisplayName(class_2680 blockState) {
        return this.rememberDisplayName.computeIfAbsent(class_2248.method_9507((class_2680)blockState), id -> {
            class_2680 blockState1 = class_2248.method_9531((int)id);
            class_1792 item = blockState1.method_26204().method_8389();
            return item == class_1802.field_8162 ? blockState1.method_26204().method_9518() : (class_5250)item.method_7864(item.method_7854());
        });
    }

    public List<String> updateRenderBlockStateProperties(class_2680 blockState) {
        return this.rememberBlockStateProperties.computeIfAbsent(class_2248.method_9507((class_2680)blockState), id -> class_2248.method_9531((int)id).method_11656().entrySet().stream().map(YuushyaUtils.PROPERTY_ENTRY_TO_STRING_FUNCTION).toList());
    }

    public class_1799 updateRenderItemstack(class_2680 blockState) {
        return this.rememberItemStack.computeIfAbsent(class_2248.method_9507((class_2680)blockState), id -> {
            class_1799 itemStack = ((class_1792)YuushyaRegistries.ITEMS.get("get_blockstate_item").get()).method_7854();
            class_2487 compoundTag = itemStack.method_7948();
            compoundTag.method_10566("BlockState", (class_2520)class_2512.method_10686((class_2680)class_2248.method_9531((int)id)));
            itemStack.method_7980(compoundTag);
            return itemStack;
        });
    }

    public Collection<class_2769<?>> updateRenderProperties(class_2680 blockState) {
        return this.rememberProperties.computeIfAbsent(class_2248.method_9507((class_2680)blockState), id -> class_2248.method_9531((int)id).method_26204().method_9595().method_11659());
    }

    public int method_25322() {
        return this.itemWidth;
    }

    protected int method_25329() {
        return this.field_19087 - 4;
    }

    public void updateRenderList() {
        this.method_25339();
        for (int i = 0; i < this.transformDataList.size(); ++i) {
            this.method_25321((class_350.class_351)new Entry(this, i));
        }
        this.notifyListUpdated();
    }

    public void addSlot() {
        if (this.method_25334() != null && this.transformDataList.get((int)((Entry)this.method_25334()).slot).blockState.method_26204() == class_2246.field_10124) {
            return;
        }
        if (this.method_25396().size() == this.transformDataList.size()) {
            Entry entry = new Entry(this, this.transformDataList.size());
            this.method_25321((class_350.class_351)entry);
            this.setSelected(entry);
        }
    }

    private void notifyListUpdated() {
    }

    public void setSelectedSlot(int slot) {
        this.setSelected((Entry)((Object)this.method_25396().get(slot)));
    }

    public void setSelected(@Nullable Entry selected) {
        super.method_25313((class_350.class_351)selected);
        if (selected != null) {
            this.screen.setSlot(selected.slot);
        }
    }

    public int getChosenOne() {
        if (!this.chosen.isEmpty()) {
            return this.chosen.get((int)(this.chosen.size() - 1)).slot;
        }
        return -1;
    }

    public void setChosenCurrent() {
        Entry selected = (Entry)this.method_25334();
        if (selected != null) {
            selected.chosen = true;
            this.chosen.add(selected);
        }
    }

    public void clearChosen() {
        for (Entry entry : this.chosen) {
            entry.chosen = false;
        }
        this.chosen.clear();
    }

    public static final class Entry
    extends class_4280.class_4281<Entry> {
        private final BlockStateIconList parent;
        private final int slot;
        private final class_310 minecraft;
        private boolean chosen = false;

        public TransformData getTransformData() {
            return this.parent.transformDataList.size() > this.slot ? this.parent.transformDataList.get(this.slot) : new TransformData();
        }

        public class_2680 updateRenderState() {
            return this.parent.transformDataList.size() > this.slot ? this.parent.transformDataList.get((int)this.slot).blockState : class_2246.field_10124.method_9564();
        }

        public boolean updateRenderShown() {
            return this.parent.transformDataList.size() > this.slot ? this.parent.transformDataList.get((int)this.slot).isShown : true;
        }

        public Entry(BlockStateIconList parent, int slot) {
            this.parent = parent;
            this.minecraft = parent.field_22740;
            this.slot = slot;
        }

        public class_2561 method_37006() {
            class_2680 blockState = this.updateRenderState();
            class_1792 item = blockState.method_26204().method_8389();
            class_5250 displayName = item == class_1802.field_8162 ? blockState.method_26204().method_9518() : (class_5250)item.method_7864(item.method_7854());
            return displayName;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            Entry preSelected = (Entry)this.parent.method_25334();
            this.parent.setSelected(this);
            if (preSelected == this) {
                if (this.chosen) {
                    this.chosen = false;
                    this.parent.chosen.remove((Object)this);
                } else {
                    this.chosen = true;
                    this.parent.chosen.add(this);
                }
            }
            return true;
        }

        public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            class_2680 blockState = this.updateRenderState();
            class_5250 displayName = this.parent.updateRenderDisplayName(blockState);
            class_327 font = this.minecraft.field_1772;
            Objects.requireNonNull(font);
            int fontHeight = 9;
            guiGraphics.method_51439(font, (class_2561)displayName, left + 3, top + 32, 0xFFFFFF, false);
            if (this.updateRenderShown()) {
                guiGraphics.method_25294(left, top, left + 32 + 4, top + fontHeight + 32, -1601138544);
            }
            if (this.chosen) {
                guiGraphics.method_25294(left, top, left + 32 + 4, top + fontHeight + 32, 1608014895);
            }
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416((float)(left + 16), (float)(top + 16), 32.0f);
            guiGraphics.method_51448().method_22905(32.0f, 32.0f, 32.0f);
            guiGraphics.method_51448().method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            class_1799 itemStack = this.parent.updateRenderItemstack(blockState);
            class_1087 model = this.minecraft.method_1480().method_4019(itemStack, (class_1937)this.minecraft.field_1687, null, this.minecraft.field_1724.method_5628());
            this.minecraft.method_1480().method_23179(itemStack, class_811.field_4317, false, guiGraphics.method_51448(), (class_4597)guiGraphics.method_51450(), 0xF000F0, class_4608.field_21444, model);
            guiGraphics.method_51448().method_22909();
        }
    }
}

