/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.utils;

import com.google.common.collect.ImmutableMap;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.yuushya.modelling.blockentity.TransformData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class ShareUtils {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).create();

    public static String transfer(List<TransformData> transformDataList) {
        ShareInformation shareInformation = ShareInformation.from(transformDataList);
        return GSON.toJson((Object)shareInformation, ShareInformation.class);
    }

    public static ShareInformation from(String json) {
        return (ShareInformation)GSON.fromJson(json, ShareInformation.class);
    }

    public record ShareInformation(Set<String> mods, List<ShareData> blocks) {
        public static ShareInformation from(List<TransformData> transformDataList) {
            HashSet<String> modIds = new HashSet<String>();
            ArrayList<ShareData> shareDataList = new ArrayList<ShareData>();
            for (TransformData data : transformDataList) {
                String namespace = class_7923.field_41175.method_10221((Object)data.blockState.method_26204()).method_12836();
                if (!"minecraft".equals(namespace)) {
                    modIds.add(namespace);
                }
                shareDataList.add(ShareData.from(data));
            }
            return new ShareInformation(modIds, shareDataList);
        }

        public void transfer(List<TransformData> transformDataList) {
            if (!transformDataList.isEmpty()) {
                transformDataList.clear();
            }
            for (ShareData data : this.blocks) {
                transformDataList.add(data.transfer());
            }
        }

        public record ShareData(List<Double> pos, List<Float> rot, List<Float> scales, ShareBlockState blockState, boolean isShown) {
            public static ShareData from(TransformData data) {
                return new ShareData(List.of(Double.valueOf(data.pos.x), Double.valueOf(data.pos.y), Double.valueOf(data.pos.z)), List.of(Float.valueOf(data.rot.x), Float.valueOf(data.rot.y), Float.valueOf(data.rot.z)), List.of(Float.valueOf(data.scales.x), Float.valueOf(data.scales.y), Float.valueOf(data.scales.z)), ShareBlockState.from(data.blockState), data.isShown);
            }

            public TransformData transfer() {
                this.pos.add(0.0);
                this.pos.add(0.0);
                this.pos.add(0.0);
                this.rot.add(Float.valueOf(0.0f));
                this.rot.add(Float.valueOf(0.0f));
                this.rot.add(Float.valueOf(0.0f));
                this.scales.add(Float.valueOf(1.0f));
                this.scales.add(Float.valueOf(1.0f));
                this.scales.add(Float.valueOf(1.0f));
                return new TransformData(new Vector3d(this.pos.get(0).doubleValue(), this.pos.get(1).doubleValue(), this.pos.get(2).doubleValue()), new Vector3f(this.rot.get(0).floatValue(), this.rot.get(1).floatValue(), this.rot.get(2).floatValue()), new Vector3f(this.scales.get(0).floatValue(), this.scales.get(1).floatValue(), this.scales.get(2).floatValue()), this.blockState.transfer(), this.isShown);
            }

            public record ShareBlockState(String name, Map<String, String> properties) {
                public static ShareBlockState from(class_2680 state) {
                    String name = class_7923.field_41175.method_10221((Object)state.method_26204()).toString();
                    ImmutableMap map = state.method_11656();
                    HashMap<String, String> properties = new HashMap<String, String>();
                    for (Map.Entry entry : map.entrySet()) {
                        class_2769 property = (class_2769)entry.getKey();
                        Comparable value = (Comparable)entry.getValue();
                        properties.put(property.method_11899(), ShareBlockState.getName(property, value));
                    }
                    return new ShareBlockState(name, properties);
                }

                public class_2680 transfer() {
                    class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960(this.name));
                    class_2680 blockState = block.method_9564();
                    class_2689 stateDefinition = block.method_9595();
                    for (String string : this.properties.keySet()) {
                        class_2769 property = stateDefinition.method_11663(string);
                        if (property == null) continue;
                        blockState = ShareBlockState.setValueHelper(blockState, property, this.properties.get(string));
                    }
                    return blockState;
                }

                private static <S extends class_2688<?, S>, T extends Comparable<T>> S setValueHelper(S stateHolder, class_2769<T> property, String value) {
                    return (S)property.method_11900(value).map(t -> (class_2688)stateHolder.method_11657(property, t)).orElse(stateHolder);
                }

                private static <T extends Comparable<T>> String getName(class_2769<T> property, Comparable<T> value) {
                    return property.method_11901(value);
                }
            }
        }
    }

    public static class StringSerialization {
        public static class_2487 transfer(String string) throws CommandSyntaxException {
            return class_2522.method_10718((String)string);
        }

        public static String from(class_2487 tag) {
            return tag.method_10714();
        }
    }
}

