/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.utils;

import com.yuushya.modelling.blockentity.showblock.ShowBlock;
import com.yuushya.modelling.blockentity.showblock.ShowBlockEntity;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class YuushyaUtils {
    public static final Function<Map.Entry<class_2769<?>, Comparable<?>>, String> PROPERTY_ENTRY_TO_STRING_FUNCTION = new Function<Map.Entry<class_2769<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<class_2769<?>, Comparable<?>> propertyValueMap) {
            if (propertyValueMap == null) {
                return "<NULL>";
            }
            class_2769<?> property = propertyValueMap.getKey();
            return property.method_11899() + "=" + this.getName(property, propertyValueMap.getValue());
        }

        private <T extends Comparable<T>> String getName(class_2769<T> property, Comparable<?> value) {
            return property.method_11901(value);
        }
    };

    public static int vertexSize() {
        return class_290.field_1590.method_1362() / 4;
    }

    public static void scale(class_4587 arg, Vector3f scales) {
        if (scales.x() != 1.0f || scales.y() != 1.0f || scales.z() != 1.0f) {
            arg.method_22904(0.5, 0.5, 0.5);
            arg.method_22905(scales.x(), scales.y(), scales.z());
            arg.method_22904(-0.5, -0.5, -0.5);
        }
    }

    public static void translateAfterScale(class_4587 arg, Vector3d pos, Vector3f scales) {
        if (pos.x != 0.0 || pos.y != 0.0 || pos.z != 0.0) {
            arg.method_22904(pos.x * (double)scales.x() / 16.0, pos.y * (double)scales.y() / 16.0, pos.z * (double)scales.z() / 16.0);
        }
    }

    public static void translate(class_4587 arg, Vector3d pos) {
        if (pos.x != 0.0 || pos.y != 0.0 || pos.z != 0.0) {
            arg.method_22904(pos.x / 16.0, pos.y / 16.0, pos.z / 16.0);
        }
    }

    public static void rotate(class_4587 arg, Vector3f rot) {
        float roll = rot.z();
        float yaw = rot.y();
        float pitch = rot.x();
        if (roll != 0.0f || yaw != 0.0f || pitch != 0.0f) {
            arg.method_22904(0.5, 0.5, 0.5);
            if (roll != 0.0f) {
                arg.method_22907(class_7833.field_40718.rotationDegrees(roll));
            }
            if (yaw != 0.0f) {
                arg.method_22907(class_7833.field_40716.rotationDegrees(yaw));
            }
            if (pitch != 0.0f) {
                arg.method_22907(class_7833.field_40714.rotationDegrees(pitch));
            }
            arg.method_22904(-0.5, -0.5, -0.5);
        }
    }

    public static int encodeTintWithState(int tint, class_2680 state) {
        return class_2248.method_9507((class_2680)state) << 8 | tint;
    }

    public static class_2680 getBlockState(class_2680 blockState, class_1936 world, class_2338 blockPos) {
        if (blockState.method_26204() instanceof ShowBlock) {
            ShowBlockEntity blockEntity = (ShowBlockEntity)world.method_8321(blockPos);
            return blockEntity.getTransFormDataNow().blockState;
        }
        return blockState;
    }

    public static String getBlockStateProperties(class_2680 blockState) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!blockState.method_11656().isEmpty()) {
            stringBuilder.append('[');
            stringBuilder.append(blockState.method_11656().entrySet().stream().map(PROPERTY_ENTRY_TO_STRING_FUNCTION).collect(Collectors.joining(",")));
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    public static <T> class_2499 toListTag(T ... values) {
        class_2499 listTag = new class_2499();
        Arrays.stream(values).toList().forEach(e -> {
            if (e instanceof Float) {
                Float e1 = (Float)e;
                listTag.add((Object)class_2494.method_23244((float)e1.floatValue()));
            } else if (e instanceof Double) {
                Double e1 = (Double)e;
                listTag.add((Object)class_2489.method_23241((double)e1));
            }
        });
        return listTag;
    }

    public static class_2680 readBlockState(class_2487 tag) {
        if (!tag.method_10573("Name", 8)) {
            return class_2246.field_10124.method_9564();
        }
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960(tag.method_10558("Name")));
        class_2680 blockState = block.method_9564();
        if (tag.method_10573("Properties", 10)) {
            class_2487 compoundTag = tag.method_10562("Properties");
            class_2689 stateDefinition = block.method_9595();
            for (String string : compoundTag.method_10541()) {
                class_2769 property = stateDefinition.method_11663(string);
                if (property == null) continue;
                blockState = YuushyaUtils.setValueHelper(blockState, property, string, compoundTag, tag);
            }
        }
        return blockState;
    }

    private static <S extends class_2688<?, S>, T extends Comparable<T>> S setValueHelper(S stateHolder, class_2769<T> property, String propertyName, class_2487 propertiesTag, class_2487 blockStateTag) {
        Optional optional = property.method_11900(propertiesTag.method_10558(propertyName));
        if (optional.isPresent()) {
            return (S)((class_2688)stateHolder.method_11657(property, (Comparable)optional.get()));
        }
        return stateHolder;
    }
}

