/*
 * Decompiled with CFR 0.152.
 */
package me.kous500.curvebuilding.fabric.client.render;

import com.sk89q.worldedit.math.Vector3;
import java.awt.Color;
import java.util.NavigableMap;
import me.kous500.curvebuilding.fabric.CurveBuildingFabric;

public class PosVector {
    public final Vector3 vector;
    public final boolean isStartPos;
    public final boolean isEndPos;
    public final int n;
    public final int h;

    public static PosVector getInstance(NavigableMap<Integer, Vector3[]> p, int n, int h) {
        if (p == null || n <= 0 || h < 0 || h > 2) {
            return null;
        }
        Vector3[] vector3s = (Vector3[])p.get(n);
        if (vector3s == null || vector3s.length != 3 || vector3s[h] == null) {
            return null;
        }
        return new PosVector(p, n, h);
    }

    private PosVector(NavigableMap<Integer, Vector3[]> p, int n, int h) {
        this.vector = ((Vector3[])p.get(n))[h];
        this.isStartPos = n == 1;
        this.isEndPos = n == p.lastEntry().getKey();
        this.n = n;
        this.h = h;
    }

    public Color getLineColor() {
        if (this.h == 1) {
            return CurveBuildingFabric.fabricConfig.posFLineColor;
        }
        if (this.h == 2) {
            return CurveBuildingFabric.fabricConfig.posBLineColor;
        }
        if (this.isStartPos) {
            return CurveBuildingFabric.fabricConfig.posStartLineColor;
        }
        if (this.isEndPos) {
            return CurveBuildingFabric.fabricConfig.posEndLineColor;
        }
        return CurveBuildingFabric.fabricConfig.posLineColor;
    }

    public Color getFillColor() {
        if (this.h == 1) {
            return CurveBuildingFabric.fabricConfig.posFFilledColor;
        }
        if (this.h == 2) {
            return CurveBuildingFabric.fabricConfig.posBFilledColor;
        }
        if (this.isStartPos) {
            return CurveBuildingFabric.fabricConfig.posStartFilledColor;
        }
        if (this.isEndPos) {
            return CurveBuildingFabric.fabricConfig.posEndFilledColor;
        }
        return CurveBuildingFabric.fabricConfig.posFilledColor;
    }
}

