/*
 * Decompiled with CFR 0.152.
 */
package me.kous500.curvebuilding.fabric.client.render;

import com.sk89q.worldedit.math.Vector3;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.NavigableMap;
import me.kous500.curvebuilding.PosData;
import me.kous500.curvebuilding.Util;
import me.kous500.curvebuilding.fabric.CurveBuildingFabric;
import me.kous500.curvebuilding.fabric.client.render.FilledRender;
import me.kous500.curvebuilding.fabric.client.render.LineRender;
import me.kous500.curvebuilding.fabric.client.render.PosVector;
import me.kous500.curvebuilding.fabric.client.render.Render;
import net.minecraft.class_243;
import net.minecraft.class_4587;

public class RenderPreview {
    public static PosData posData;
    private static boolean isError;
    private static ArrayDeque<RenderFilledItem> filledQueue;
    private static final double INCREASE = 0.001;
    private static final class_243 INCREASE_VEC;

    public static void RenderPosData(class_4587 matrix) {
        if (isError || posData == null) {
            return;
        }
        try {
            Render.setRender(CurveBuildingFabric.fabricConfig.lineRenderThroughWalls, LineRender.getInstance(), render -> {
                RenderPreview.renderBezier(matrix, RenderPreview.posData.p, CurveBuildingFabric.fabricConfig.lineCurveColor, render);
                Iterator iterator = RenderPreview.posData.p.keySet().iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    RenderPreview.renderControlLine(matrix, (Vector3[])RenderPreview.posData.p.get(n), render);
                }
            });
            Render.setRender(CurveBuildingFabric.fabricConfig.posRenderThroughWalls, LineRender.getInstance(), render -> {
                Iterator iterator = RenderPreview.posData.p.keySet().iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    for (int h : new int[]{0, 1, 2}) {
                        PosVector pos = PosVector.getInstance(RenderPreview.posData.p, n, h);
                        if (pos == null) continue;
                        RenderPreview.renderPos(matrix, pos, render);
                    }
                }
            });
            Render.setRender(CurveBuildingFabric.fabricConfig.posRenderThroughWalls, FilledRender.getInstance(), render -> {
                for (RenderFilledItem renderItem : filledQueue) {
                    render.renderFilled(matrix, renderItem.color, renderItem.start, renderItem.dimensions);
                }
                filledQueue = new ArrayDeque();
            });
        }
        catch (NoSuchFieldError | NoSuchMethodError e) {
            isError = true;
            e.printStackTrace();
        }
    }

    private static void renderBezier(class_4587 matrices, NavigableMap<Integer, Vector3[]> pos, Color color, LineRender render) {
        if (pos == null) {
            return;
        }
        double totalLen = 0.0;
        Iterator iterator = pos.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (n > 1) {
                totalLen = RenderPreview.bezierBuild(matrices, (Vector3[])pos.get(n), (Vector3[])pos.get(n - 1), color, totalLen, render);
            }
            if (!(totalLen > (double)CurveBuildingFabric.fabricConfig.lineRenderLength)) continue;
            return;
        }
    }

    private static double bezierBuild(class_4587 matrices, Vector3[] p, Vector3[] bp, Color color, double totalLen, LineRender render) {
        if (p == null || p[0] == null || bp == null || bp[0] == null) {
            return CurveBuildingFabric.fabricConfig.lineRenderLength + 1;
        }
        Vector3[] bezierPos = new Vector3[]{Util.copyVector((Vector3)bp[0]), Util.copyVector((Vector3)bp[2]), Util.copyVector((Vector3)p[1]), Util.copyVector((Vector3)p[0])};
        if (bezierPos[1] == null) {
            bezierPos[1] = bezierPos[0];
        }
        if (bezierPos[2] == null) {
            bezierPos[2] = bezierPos[3];
        }
        if (bezierPos[0].distance(bezierPos[3]) > (double)CurveBuildingFabric.fabricConfig.lineRenderLength) {
            return CurveBuildingFabric.fabricConfig.lineRenderLength + 1;
        }
        if (bezierPos[0].distance(bezierPos[1]) > (double)CurveBuildingFabric.fabricConfig.lineRenderLength) {
            return CurveBuildingFabric.fabricConfig.lineRenderLength + 1;
        }
        if (bezierPos[3].distance(bezierPos[2]) > (double)CurveBuildingFabric.fabricConfig.lineRenderLength) {
            return CurveBuildingFabric.fabricConfig.lineRenderLength + 1;
        }
        double length = Util.bezierLength((Vector3[])bezierPos, (double)(bezierPos[0].distance(bezierPos[3]) * 5.0));
        if ((totalLen += length) > (double)CurveBuildingFabric.fabricConfig.lineRenderLength) {
            return totalLen;
        }
        class_243 bc = null;
        for (double i = 0.0; i <= 1.0; i += 1.0 / (length * (double)CurveBuildingFabric.fabricConfig.lineRenderAccuracy)) {
            class_243 c = RenderPreview.adaptVec(Util.bezierCoordinate((Vector3[])bezierPos, (double)i));
            if (bc != null) {
                render.addLine(matrices, color, c, bc);
            }
            bc = c;
        }
        render.addLine(matrices, color, bc, RenderPreview.adaptVec(bezierPos[3].add(0.5, 0.5, 0.5)));
        return totalLen;
    }

    private static void renderControlLine(class_4587 matrix, Vector3[] p, LineRender render) {
        if (p == null || p[0] == null) {
            return;
        }
        if (p[1] != null && p[0].distance(p[1]) <= (double)CurveBuildingFabric.fabricConfig.lineRenderLength) {
            render.addLine(matrix, CurveBuildingFabric.fabricConfig.lineFColor, RenderPreview.adaptVec(p[0]).method_1031(0.5, 0.5, 0.5), RenderPreview.adaptVec(p[1]).method_1031(0.5, 0.5, 0.5));
        }
        if (p[2] != null && p[0].distance(p[2]) <= (double)CurveBuildingFabric.fabricConfig.lineRenderLength) {
            render.addLine(matrix, CurveBuildingFabric.fabricConfig.lineBColor, RenderPreview.adaptVec(p[0]).method_1031(0.5, 0.5, 0.5), RenderPreview.adaptVec(p[2]).method_1031(0.5, 0.5, 0.5));
        }
    }

    private static void renderPos(class_4587 matrix, PosVector pos, LineRender render) {
        Color colorLine = pos.getLineColor();
        Color colorFill = pos.getFillColor();
        class_243 start = RenderPreview.adaptVec(pos.vector).method_1020(INCREASE_VEC);
        class_243 dimensions = new class_243(1.0, 1.0, 1.0).method_1019(INCREASE_VEC).method_1019(INCREASE_VEC);
        if (pos.h != 0) {
            render.addCrossing(matrix, colorLine, start, dimensions);
        }
        render.addOutline(matrix, colorLine, start, dimensions);
        filledQueue.add(new RenderFilledItem(colorFill, start, dimensions));
    }

    private static class_243 adaptVec(Vector3 vec) {
        return new class_243(vec.getX(), vec.getY(), vec.getZ());
    }

    static {
        isError = false;
        filledQueue = new ArrayDeque();
        INCREASE_VEC = new class_243(0.001, 0.001, 0.001);
    }

    private static class RenderFilledItem {
        Color color;
        class_243 start;
        class_243 dimensions;

        RenderFilledItem(Color color, class_243 start, class_243 dimensions) {
            this.color = color;
            this.start = start;
            this.dimensions = dimensions;
        }
    }
}

