/*
 * Decompiled with CFR 0.152.
 */
package ru.weryskok.mtrrumetro.mod.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_2248;
import net.minecraft.class_2769;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Entity;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.Random;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.SoundEvent;
import org.mtr.mapping.holder.StringIdentifiable;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.BlockTicketBarrier;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.TicketSystem;
import ru.weryskok.mtrrumetro.mod.SoundEvents;

public class BlockMoscowOldTicketBarrier
extends BlockTicketBarrier {
    private final boolean isEntrance;
    public static final EnumProperty<EnumNormallyOpenedTicketBarrier> NORMAL_OPEN = EnumProperty.of((String)"normal_open", EnumNormallyOpenedTicketBarrier.class);

    public BlockMoscowOldTicketBarrier(boolean isEntrance) {
        super(isEntrance);
        this.isEntrance = isEntrance;
    }

    public void onEntityCollision2(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!world.isClient() && PlayerEntity.isInstance((HolderBase)entity)) {
            Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
            Vector3d playerPosRotated = entity.getPos().subtract((double)pos.getX() + 0.5, 0.0, (double)pos.getZ() + 0.5).rotateY((float)Math.toRadians(facing.asRotation()));
            TicketSystem.EnumTicketBarrierOpen open = (TicketSystem.EnumTicketBarrierOpen)IBlock.getStatePropertySafe((BlockState)state, (Property)new Property((class_2769)BlockMoscowOldTicketBarrier.OPEN.data));
            if (BlockMoscowOldTicketBarrier.isOpen(open) && playerPosRotated.getZMapped() > 0.0) {
                world.setBlockState(pos, state.with(new Property((class_2769)BlockMoscowOldTicketBarrier.OPEN.data), (Comparable)TicketSystem.EnumTicketBarrierOpen.CLOSED));
            } else if (open == TicketSystem.EnumTicketBarrierOpen.CLOSED && playerPosRotated.getZMapped() < 0.0 && !BlockMoscowOldTicketBarrier.hasScheduledBlockTick((World)world, (BlockPos)pos, (Block)new Block((class_2248)this))) {
                BlockPos posCopy = new BlockPos(pos.getX(), pos.getY(), pos.getZ());
                world.setBlockState(posCopy, state.with(new Property((class_2769)BlockMoscowOldTicketBarrier.OPEN.data), (Comparable)TicketSystem.EnumTicketBarrierOpen.PENDING));
                TicketSystem.passThrough((World)world, (BlockPos)posCopy, (PlayerEntity)PlayerEntity.cast((HolderBase)entity), (boolean)this.isEntrance, (!this.isEntrance ? 1 : 0) != 0, (SoundEvent)org.mtr.mod.SoundEvents.TICKET_BARRIER.get(), (SoundEvent)org.mtr.mod.SoundEvents.TICKET_BARRIER_CONCESSIONARY.get(), (SoundEvent)org.mtr.mod.SoundEvents.TICKET_BARRIER.get(), (SoundEvent)org.mtr.mod.SoundEvents.TICKET_BARRIER_CONCESSIONARY.get(), (SoundEvent)SoundEvents.MOSCOW_OLD_TICKET_BARRIER_FAIL.get(), (boolean)false, newOpen -> {
                    world.setBlockState(posCopy, state.with(new Property((class_2769)BlockMoscowOldTicketBarrier.OPEN.data), (Comparable)newOpen));
                    switch (newOpen) {
                        case OPEN_CONCESSIONARY: 
                        case OPEN: {
                            world.setBlockState(posCopy, state.with(new Property((class_2769)BlockMoscowOldTicketBarrier.NORMAL_OPEN.data), (Comparable)((Object)EnumNormallyOpenedTicketBarrier.OPEN)));
                            break;
                        }
                        case CLOSED: {
                            world.setBlockState(posCopy, state.with(new Property((class_2769)BlockMoscowOldTicketBarrier.NORMAL_OPEN.data), (Comparable)((Object)EnumNormallyOpenedTicketBarrier.CLOSED)));
                        }
                    }
                });
                BlockMoscowOldTicketBarrier.scheduleBlockTick((World)world, (BlockPos)posCopy, (Block)new Block((class_2248)this), (int)40);
            }
        }
    }

    public void scheduledTick2(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        world.setBlockState(pos, state.with(new Property((class_2769)BlockMoscowOldTicketBarrier.OPEN.data), (Comparable)TicketSystem.EnumTicketBarrierOpen.CLOSED));
        world.setBlockState(pos, state.with(new Property((class_2769)BlockMoscowOldTicketBarrier.NORMAL_OPEN.data), (Comparable)((Object)EnumNormallyOpenedTicketBarrier.NEUTRAL)));
    }

    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        return this.getDefaultState2().with(new Property((class_2769)BlockMoscowOldTicketBarrier.FACING.data), (Comparable)ctx.getPlayerFacing().data).with(new Property((class_2769)BlockMoscowOldTicketBarrier.OPEN.data), (Comparable)TicketSystem.EnumTicketBarrierOpen.CLOSED).with(new Property((class_2769)BlockMoscowOldTicketBarrier.NORMAL_OPEN.data), (Comparable)((Object)EnumNormallyOpenedTicketBarrier.NEUTRAL));
    }

    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        return IBlock.getVoxelShapeByDirection((double)10.9, (double)0.0, (double)-2.0, (double)16.0, (double)24.1, (double)19.5, (Direction)facing);
    }

    @Nonnull
    public VoxelShape getCollisionShape2(BlockState state, BlockView world, BlockPos blockPos, ShapeContext context) {
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        EnumNormallyOpenedTicketBarrier normal_open = (EnumNormallyOpenedTicketBarrier)IBlock.getStatePropertySafe((BlockState)state, NORMAL_OPEN);
        VoxelShape base = IBlock.getVoxelShapeByDirection((double)10.9, (double)0.0, (double)-2.0, (double)16.0, (double)24.1, (double)19.5, (Direction)facing);
        return normal_open == EnumNormallyOpenedTicketBarrier.OPEN ? base : VoxelShapes.union((VoxelShape)IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)3.5, (double)16.0, (double)24.0, (double)8.0, (Direction)facing), (VoxelShape)base);
    }

    public void addBlockProperties(List<HolderBase<?>> builder) {
        builder.add((HolderBase<?>)FACING);
        builder.add((HolderBase<?>)OPEN);
        builder.add((HolderBase<?>)NORMAL_OPEN);
    }

    public static boolean isOpen(TicketSystem.EnumTicketBarrierOpen open) {
        return open == TicketSystem.EnumTicketBarrierOpen.OPEN || open == TicketSystem.EnumTicketBarrierOpen.OPEN_CONCESSIONARY;
    }

    public static enum EnumNormallyOpenedTicketBarrier implements StringIdentifiable
    {
        NEUTRAL("neutral"),
        CLOSED("closed"),
        OPEN("open");

        private final String name;

        private EnumNormallyOpenedTicketBarrier(String name) {
            this.name = name;
        }

        @Nonnull
        public String asString2() {
            return this.name;
        }
    }
}

