/*
 * Decompiled with CFR 0.152.
 */
package ru.weryskok.mtrrumetro.mod.items;

import javax.annotation.Nonnull;
import net.minecraft.class_2769;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemUsageContext;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.ItemExtension;
import org.mtr.mapping.registry.BlockRegistryObject;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.item.ItemPSDAPGBase;
import ru.weryskok.mtrrumetro.mod.Blocks;
import ru.weryskok.mtrrumetro.mod.blocks.BlockSPBHorizontalElevatorDoor;

public class ItemSPBHorizontalElevatorDoor
extends ItemExtension
implements IBlock {
    private final boolean isOdd;

    public ItemSPBHorizontalElevatorDoor(ItemSettings itemSettings, boolean isOdd) {
        super(itemSettings);
        this.isOdd = isOdd;
    }

    @Nonnull
    public ActionResult useOnBlock2(ItemUsageContext context) {
        int horizontalBlocks;
        int n = horizontalBlocks = this.isOdd ? 1 : 2;
        if (ItemPSDAPGBase.blocksNotReplaceable((ItemUsageContext)context, (int)horizontalBlocks, (int)2, (Block)this.getBlockStateFromItem().getBlock())) {
            return ActionResult.FAIL;
        }
        World world = context.getWorld();
        Direction playerFacing = context.getPlayerFacing();
        BlockPos pos = context.getBlockPos().offset(context.getSide());
        for (int x = 0; x < horizontalBlocks; ++x) {
            BlockPos newPos = pos.offset(playerFacing.rotateYClockwise(), x);
            for (int y = 0; y < 2; ++y) {
                BlockState state = this.getBlockStateFromItem().with(new Property((class_2769)BlockSPBHorizontalElevatorDoor.FACING.data), (Comparable)playerFacing.data).with(new Property((class_2769)ItemSPBHorizontalElevatorDoor.HALF.data), (Comparable)(y == 1 ? IBlock.DoubleBlockHalf.UPPER : IBlock.DoubleBlockHalf.LOWER));
                if (!this.isOdd) {
                    state = state.with(new Property((class_2769)ItemSPBHorizontalElevatorDoor.SIDE.data), (Comparable)(x == 0 ? IBlock.EnumSide.LEFT : IBlock.EnumSide.RIGHT));
                }
                world.setBlockState(newPos.up(y), state);
            }
        }
        context.getStack().decrement(1);
        return ActionResult.SUCCESS;
    }

    private BlockState getBlockStateFromItem() {
        BlockRegistryObject block = this.isOdd ? Blocks.SPB_HORIZONTAL_ELEVATOR_DOOR_ODD : Blocks.SPB_HORIZONTAL_ELEVATOR_DOOR;
        return block.get().getDefaultState();
    }
}

