/*
 * Decompiled with CFR 0.152.
 */
package ru.weryskok.mtrrumetro.mod.render;

import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.EntityAbstractMapping;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.EntityModelExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ModelPartExtension;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import ru.weryskok.mtrrumetro.mod.blocks.BlockSPBHorizontalElevatorDoor;

public class RenderSPBHorizontalElevatorDoor
extends BlockEntityRenderer<BlockSPBHorizontalElevatorDoor.BlockEntitySPBHorizontalElevatorDoor>
implements IGui,
IBlock {
    private static final ModelSingleCube MODEL_PSD = new ModelSingleCube(36, 18, 0.0f, 0.0f, 0.0f, 16, 16, 2);
    private static final ModelSingleCube MODEL_PSD_DOOR_LOCKED = new ModelSingleCube(6, 6, 5.0f, 6.0f, 2.1f, 6, 6, 0);
    private final boolean isOdd;

    public RenderSPBHorizontalElevatorDoor(BlockEntityRenderer.Argument dispatcher, boolean isOdd) {
        super(dispatcher);
        this.isOdd = isOdd;
    }

    public void render(BlockSPBHorizontalElevatorDoor.BlockEntitySPBHorizontalElevatorDoor entity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        World world = entity.getWorld2();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.getPos2();
        Direction facing = IBlock.getStatePropertySafe((World)world, (BlockPos)pos, (DirectionProperty)BlockSPBHorizontalElevatorDoor.FACING);
        boolean side = IBlock.getStatePropertySafe((World)world, (BlockPos)pos, (EnumProperty)BlockSPBHorizontalElevatorDoor.SIDE) == IBlock.EnumSide.RIGHT;
        boolean half = IBlock.getStatePropertySafe((World)world, (BlockPos)pos, (EnumProperty)BlockSPBHorizontalElevatorDoor.HALF) == IBlock.DoubleBlockHalf.UPPER;
        boolean unlocked = IBlock.getStatePropertySafe((World)world, (BlockPos)pos, (BooleanProperty)BlockSPBHorizontalElevatorDoor.UNLOCKED);
        double open = Math.min(entity.getDoorValue(), 1.0);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)entity.getPos2().getX(), (double)entity.getPos2().getY(), 0.5 + (double)entity.getPos2().getZ());
        storedMatrixTransformations.add(graphicsHolderNew -> {
            graphicsHolderNew.rotateYDegrees(-facing.asRotation());
            graphicsHolderNew.rotateXDegrees(180.0f);
        });
        if (this.isOdd) {
            StoredMatrixTransformations rightStoredMatrixTransformations = storedMatrixTransformations.copy();
            rightStoredMatrixTransformations.add(matricesNew -> matricesNew.translate(open * (double)(!side ? -1 : 1), 0.0, 0.0));
            rightStoredMatrixTransformations.add(matricesNew -> matricesNew.translate(-0.5, 0.0, 0.0));
            MainRenderer.scheduleRender((Identifier)new Identifier(String.format("russianmetro:textures/block/spb_horizontal_elevator_door_%s_%s.png", half ? "top" : "bottom", !side ? "right" : "left")), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                rightStoredMatrixTransformations.transform(graphicsHolderNew, offset);
                MODEL_PSD.render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                graphicsHolderNew.pop();
            });
            if (half && !unlocked) {
                MainRenderer.scheduleRender((Identifier)new Identifier("mtr:textures/block/sign/door_not_in_use.png"), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                    rightStoredMatrixTransformations.transform(graphicsHolderNew, offset);
                    MODEL_PSD_DOOR_LOCKED.render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    graphicsHolderNew.pop();
                });
            }
            storedMatrixTransformations.add(matricesNew -> matricesNew.translate(0.5, 0.0, 0.0));
        }
        storedMatrixTransformations.add(matricesNew -> matricesNew.translate(open * (double)(side ? -1 : 1), 0.0, 0.0));
        MainRenderer.scheduleRender((Identifier)new Identifier(String.format("russianmetro:textures/block/spb_horizontal_elevator_door_%s_%s.png", half ? "top" : "bottom", side ? "right" : "left")), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
            storedMatrixTransformations.transform(graphicsHolderNew, offset);
            MODEL_PSD.render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            graphicsHolderNew.pop();
        });
        if (half && !unlocked) {
            MainRenderer.scheduleRender((Identifier)new Identifier("mtr:textures/block/sign/door_not_in_use.png"), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                storedMatrixTransformations.transform(graphicsHolderNew, offset);
                MODEL_PSD_DOOR_LOCKED.render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                graphicsHolderNew.pop();
            });
        }
    }

    public boolean rendersOutsideBoundingBox2(BlockSPBHorizontalElevatorDoor.BlockEntitySPBHorizontalElevatorDoor blockEntity) {
        return true;
    }

    private static class ModelSingleCube
    extends EntityModelExtension<EntityAbstractMapping> {
        private final ModelPartExtension cube = this.createModelPart();

        private ModelSingleCube(int textureWidth, int textureHeight, float x, float y, float z, int length, int height, int depth) {
            super(textureWidth, textureHeight);
            this.cube.setTextureUVOffset(0, 0).addCuboid(x - 8.0f, y - 16.0f, z - 8.0f, length, height, depth, 0.0f, false);
            this.buildModel();
        }

        public void render(GraphicsHolder graphicsHolder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.cube.render(graphicsHolder, 0.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        }

        public void setAngles2(EntityAbstractMapping entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        }
    }
}

