/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.taterzens;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.class_7157;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.samo_lego.taterzens.api.professions.TaterzenProfession;
import org.samo_lego.taterzens.commands.NpcCommand;
import org.samo_lego.taterzens.commands.NpcGUICommand;
import org.samo_lego.taterzens.commands.ProfessionCommand;
import org.samo_lego.taterzens.commands.TaterzensCommand;
import org.samo_lego.taterzens.compatibility.ModDiscovery;
import org.samo_lego.taterzens.npc.TaterzenNPC;
import org.samo_lego.taterzens.platform.Platform;
import org.samo_lego.taterzens.storage.TaterConfig;
import org.samo_lego.taterzens.util.LanguageUtil;

public class Taterzens {
    public static final String MOD_ID = "taterzens";
    public static final Logger LOGGER = (Logger)LogManager.getLogger((String)"taterzens");
    private static Taterzens INSTANCE;
    public static TaterConfig config;
    public static JsonObject lang;
    public static final Map<UUID, TaterzenNPC> TATERZEN_NPCS;
    public static final HashMap<class_2960, Function<TaterzenNPC, TaterzenProfession>> PROFESSION_TYPES;
    public static final Gson GSON;
    public static Supplier<class_1299<TaterzenNPC>> TATERZEN_TYPE;
    public static final class_2960 NPC_ID;
    private final File configFile;
    public final File presetsDir;
    private final Platform platform;

    public Taterzens(Platform platform) {
        INSTANCE = this;
        platform.registerTaterzenType();
        ModDiscovery.checkLoadedMods(platform);
        this.presetsDir = new File(platform.getConfigDirPath() + "/Taterzens/presets");
        this.platform = platform;
        if (!this.presetsDir.exists() && !this.presetsDir.mkdirs()) {
            throw new RuntimeException(String.format("[%s] Error creating directory!", MOD_ID));
        }
        File taterDir = this.presetsDir.getParentFile();
        this.configFile = new File(taterDir + "/config.json");
        config = TaterConfig.loadConfigFile(this.configFile);
        LanguageUtil.setupLanguage();
    }

    public File getPresetDirectory() {
        return this.presetsDir;
    }

    public static Taterzens getInstance() {
        return INSTANCE;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 context) {
        NpcCommand.register(dispatcher, context);
        TaterzensCommand.register(dispatcher);
        NpcGUICommand.register(dispatcher);
        ProfessionCommand.register(dispatcher);
    }

    static {
        TATERZEN_NPCS = Collections.synchronizedMap(new LinkedHashMap());
        PROFESSION_TYPES = new HashMap();
        NPC_ID = new class_2960(MOD_ID, "npc");
        GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
    }
}

