/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.taterzens.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2631;
import net.minecraft.class_270;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import org.samo_lego.taterzens.Taterzens;
import org.samo_lego.taterzens.api.professions.TaterzenProfession;
import org.samo_lego.taterzens.npc.TaterzenNPC;

public class TaterzensAPI {
    @Nullable
    public static TaterzenNPC loadTaterzenFromPreset(File preset, class_1937 world) {
        if (preset.exists()) {
            String name = preset.getName();
            TaterzenNPC taterzenNPC = new TaterzenNPC(world);
            taterzenNPC.loadFromPresetFile(preset, name.substring(0, name.lastIndexOf(46)));
            return taterzenNPC;
        }
        return null;
    }

    public static class_2487 loadPresetTag(File preset) {
        JsonObject element = null;
        try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(preset), StandardCharsets.UTF_8));){
            element = JsonParser.parseReader((Reader)fileReader).getAsJsonObject();
        }
        catch (IOException e) {
            Taterzens.LOGGER.error("taterzens Problem occurred when trying to load Taterzen preset: ", (Throwable)e);
        }
        if (element != null) {
            try {
                class_2520 tag = (class_2520)JsonOps.INSTANCE.convertTo((DynamicOps)class_2509.field_11560, element);
                if (tag instanceof class_2487) {
                    class_2487 saveTag = (class_2487)tag;
                    return saveTag;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return new class_2487();
    }

    public static void saveTaterzenToPreset(TaterzenNPC taterzen, File preset) {
        class_2487 saveTag = new class_2487();
        taterzen.method_5647(saveTag);
        saveTag.method_10551("ArmorDropChances");
        saveTag.method_10551("HandDropChances");
        saveTag.method_10551("UUID");
        saveTag.method_10551("Pos");
        saveTag.method_10551("Motion");
        saveTag.method_10551("Rotation");
        class_270 team = taterzen.method_5781();
        if (team != null) {
            String teamName = team.method_1197();
            class_2487 npcTag = (class_2487)saveTag.method_10580("TaterzenNPCTag");
            if (npcTag != null) {
                npcTag.method_10582("SavedTeam", teamName);
            }
        }
        JsonElement element = (JsonElement)class_2509.field_11560.method_29146((DynamicOps)JsonOps.INSTANCE, (class_2520)saveTag);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(preset), StandardCharsets.UTF_8);){
            Taterzens.GSON.toJson(element, (Appendable)writer);
        }
        catch (IOException e) {
            Taterzens.LOGGER.error("Problem occurred when saving Taterzen preset file: " + e.getMessage());
        }
    }

    public static TaterzenNPC createTaterzen(class_3218 world, String displayName, class_243 pos, float[] rotations) {
        TaterzenNPC taterzen = new TaterzenNPC((class_1937)world);
        taterzen.method_5808(pos.method_10216(), pos.method_10214(), pos.method_10215(), rotations[1], rotations[2]);
        taterzen.method_5847(rotations[0]);
        taterzen.method_5665((class_2561)class_2561.method_43470((String)displayName));
        class_2631.method_11335((GameProfile)taterzen.getGameProfile(), taterzen::applySkin);
        return taterzen;
    }

    public static TaterzenNPC createTaterzen(class_3222 owner, String displayName) {
        return TaterzensAPI.createTaterzen(owner.method_51469(), displayName, owner.method_19538(), new float[]{owner.field_6241, owner.method_36454(), owner.method_36455()});
    }

    public static void registerProfession(class_2960 professionId, Function<TaterzenNPC, TaterzenProfession> professionInitilizer) {
        if (!Taterzens.PROFESSION_TYPES.containsKey(professionId)) {
            Taterzens.PROFESSION_TYPES.put(professionId, professionInitilizer);
        } else {
            Taterzens.LOGGER.warn("[Taterzens] A mod {} tried to register the profession {} which is already present. Ignoring.", (Object)professionId.method_12836(), (Object)professionId.method_12832());
        }
    }

    public static List<String> getPresets() {
        ArrayList<String> files = new ArrayList<String>();
        File[] presets = Taterzens.getInstance().getPresetDirectory().listFiles();
        if (presets != null) {
            String ending = ".json";
            for (File preset : presets) {
                if (!preset.isFile() || !preset.getName().endsWith(".json")) continue;
                files.add(preset.getName().substring(0, preset.getName().length() - ".json".length()));
            }
        }
        return files;
    }
}

