/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.taterzens.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1675;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2196;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;
import org.samo_lego.taterzens.Taterzens;
import org.samo_lego.taterzens.api.TaterzensAPI;
import org.samo_lego.taterzens.commands.ActionCommand;
import org.samo_lego.taterzens.commands.LockCommand;
import org.samo_lego.taterzens.commands.PresetCommand;
import org.samo_lego.taterzens.commands.TeleportCommand;
import org.samo_lego.taterzens.commands.edit.EditCommand;
import org.samo_lego.taterzens.interfaces.ITaterzenEditor;
import org.samo_lego.taterzens.mixin.accessors.ACommandSourceStack;
import org.samo_lego.taterzens.npc.TaterzenNPC;
import org.samo_lego.taterzens.util.TextUtil;

public class NpcCommand {
    public static LiteralCommandNode<class_2168> npcNode;
    private static final double MAX_DISTANCE = 8.02;
    private static final double SQRD_DIST = 64.32039999999999;

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext) {
        npcNode = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"npc").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc", Taterzens.config.perms.npcCommandPermissionLevel))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"create").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.create", Taterzens.config.perms.npcCommandPermissionLevel))).then(class_2170.method_9244((String)"name", (ArgumentType)class_2196.method_9340()).suggests((context, builder) -> class_2172.method_9265(NpcCommand.getOnlinePlayers((CommandContext<class_2168>)context), (SuggestionsBuilder)builder)).executes(NpcCommand::spawnTaterzen))).executes(NpcCommand::spawnTaterzen))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"select").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.select", Taterzens.config.perms.npcCommandPermissionLevel))).then(class_2170.method_9247((String)"id").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.select.id", Taterzens.config.perms.npcCommandPermissionLevel))).suggests((context, builder) -> class_2172.method_9265(NpcCommand.getAvailableTaterzenIndices(), (SuggestionsBuilder)builder)).executes(NpcCommand::selectTaterzenById)))).then(class_2170.method_9247((String)"name").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.select.name", Taterzens.config.perms.npcCommandPermissionLevel))).suggests((context, builder) -> class_2172.method_9265(NpcCommand.getAvailableTaterzenNames(), (SuggestionsBuilder)builder)).executes(NpcCommand::selectTaterzenByName)))).then(class_2170.method_9247((String)"uuid").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"uuid", (ArgumentType)StringArgumentType.string()).requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.select.uuid", Taterzens.config.perms.npcCommandPermissionLevel))).suggests((context, builder) -> class_2172.method_9265(NpcCommand.getAvailableTaterzenUUIDs(), (SuggestionsBuilder)builder)).executes(NpcCommand::selectTaterzenByUUID)))).executes(NpcCommand::selectTaterzen))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"deselect").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.select.deselect", Taterzens.config.perms.npcCommandPermissionLevel))).executes(NpcCommand::deselectTaterzen))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.list", Taterzens.config.perms.npcCommandPermissionLevel))).executes(NpcCommand::listTaterzens))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.remove", Taterzens.config.perms.npcCommandPermissionLevel))).executes(NpcCommand::removeTaterzen)));
        EditCommand.registerNode(dispatcher, npcNode, commandBuildContext);
        PresetCommand.registerNode(npcNode);
        TeleportCommand.registerNode(npcNode);
        ActionCommand.registerNode(npcNode);
        LockCommand.registerNode(npcNode);
    }

    public static class_5250 noSelectedTaterzenError() {
        return TextUtil.translate("taterzens.error.select", new Object[0]).method_27692(class_124.field_1061).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextUtil.translate("taterzens.command.list", new Object[0]))).method_10958(new class_2558(class_2558.class_2559.field_11745, "/npc list")));
    }

    public static int selectedTaterzenExecutor(@NotNull class_1297 entity, Consumer<TaterzenNPC> npcConsumer) {
        Optional<Object> taterzen = Optional.empty();
        if (entity instanceof ITaterzenEditor) {
            ITaterzenEditor player = (ITaterzenEditor)entity;
            taterzen = player.getSelectedNpc();
        } else if (entity instanceof TaterzenNPC) {
            TaterzenNPC taterzenNPC = (TaterzenNPC)entity;
            taterzen = Optional.of(taterzenNPC);
        }
        if (taterzen.isPresent()) {
            npcConsumer.accept((TaterzenNPC)((Object)taterzen.get()));
            return 1;
        }
        entity.method_43496((class_2561)NpcCommand.noSelectedTaterzenError());
        return 0;
    }

    private static int deselectTaterzen(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        ((ITaterzenEditor)player).selectNpc(null);
        source.method_9226(() -> TextUtil.translate("taterzens.command.deselect", new Object[0]).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int listTaterzens(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        boolean console = source.method_9228() == null;
        Optional<Object> npc = Optional.empty();
        if (!console) {
            npc = ((ITaterzenEditor)source.method_9207()).getSelectedNpc();
        }
        class_5250 response = TextUtil.translate("taterzens.command.list", new Object[0]).method_27692(class_124.field_1075);
        int i = 1;
        for (TaterzenNPC taterzenNPC : Taterzens.TATERZEN_NPCS.values()) {
            String name = taterzenNPC.method_5477().getString();
            boolean sel = Optional.of(taterzenNPC).equals(npc);
            response.method_10852((class_2561)class_2561.method_43470((String)("\n" + i + "-> " + name)).method_27692(sel ? class_124.field_1067 : class_124.field_1070).method_27692(sel ? class_124.field_1060 : (i % 2 == 0 ? class_124.field_1054 : class_124.field_1065)).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/npc select uuid " + taterzenNPC.method_5667())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextUtil.translate(sel ? "taterzens.tooltip.current_selection" : "taterzens.tooltip.new_selection", name))))).method_10852((class_2561)class_2561.method_43470((String)(" (" + (console ? taterzenNPC.method_5845() : "uuid") + ")")).method_27692(class_124.field_1080).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextUtil.translate("taterzens.tooltip.see_uuid", new Object[0]))).method_10958(new class_2558(class_2558.class_2559.field_11745, taterzenNPC.method_5845()))));
            ++i;
        }
        source.method_9226(() -> response, false);
        return 1;
    }

    private static List<String> getAvailableTaterzenIndices() {
        return IntStream.range(0, Taterzens.TATERZEN_NPCS.size()).mapToObj(i -> String.valueOf(i + 1)).toList();
    }

    private static int selectTaterzenById(CommandContext<class_2168> context) throws CommandSyntaxException {
        int id = IntegerArgumentType.getInteger(context, (String)"id");
        class_2168 source = (class_2168)context.getSource();
        if (id > Taterzens.TATERZEN_NPCS.size()) {
            source.method_9213((class_2561)TextUtil.errorText("taterzens.error.404.id", String.valueOf(id)));
        } else {
            boolean selected;
            TaterzenNPC taterzen = (TaterzenNPC)((Object)Taterzens.TATERZEN_NPCS.values().toArray()[id - 1]);
            class_3222 player = source.method_9207();
            Optional<TaterzenNPC> npc = ((ITaterzenEditor)player).getSelectedNpc();
            if (npc.isPresent()) {
                ((ITaterzenEditor)player).selectNpc(null);
            }
            if (selected = ((ITaterzenEditor)player).selectNpc(taterzen)) {
                source.method_9226(() -> TextUtil.successText("taterzens.command.select", taterzen.method_5477().getString()), false);
            } else {
                source.method_9213((class_2561)TextUtil.errorText("taterzens.command.error.locked", taterzen.method_5477().getString()));
            }
        }
        return 1;
    }

    private static List<String> getAvailableTaterzenNames() {
        return Taterzens.TATERZEN_NPCS.values().stream().map(npc -> "\"" + npc.method_5477().getString() + "\"").toList();
    }

    private static int selectTaterzenByName(CommandContext<class_2168> context) throws CommandSyntaxException {
        boolean selected;
        class_2168 source = (class_2168)context.getSource();
        String name = StringArgumentType.getString(context, (String)"name");
        TaterzenNPC taterzen = null;
        int count = 0;
        for (TaterzenNPC npcIt : Taterzens.TATERZEN_NPCS.values()) {
            if (!npcIt.method_5477().getString().equals(name)) continue;
            taterzen = npcIt;
            if (++count <= 1) continue;
            source.method_9213((class_2561)TextUtil.errorText("taterzens.error.multiple.name", name));
            return 0;
        }
        if (count == 0) {
            source.method_9213((class_2561)TextUtil.errorText("taterzens.error.404.name", name));
            return 0;
        }
        class_3222 player = source.method_9207();
        Optional<TaterzenNPC> npc = ((ITaterzenEditor)player).getSelectedNpc();
        if (npc.isPresent()) {
            ((ITaterzenEditor)player).selectNpc(null);
        }
        if (selected = ((ITaterzenEditor)player).selectNpc(taterzen)) {
            TaterzenNPC finalTaterzen = taterzen;
            source.method_9226(() -> TextUtil.successText("taterzens.command.select", finalTaterzen.method_5477().getString()), false);
            return 1;
        }
        source.method_9213((class_2561)TextUtil.errorText("taterzens.command.error.locked", taterzen.method_5477().getString()));
        return 0;
    }

    private static List<String> getAvailableTaterzenUUIDs() {
        return Taterzens.TATERZEN_NPCS.keySet().stream().map(UUID::toString).toList();
    }

    private static int selectTaterzenByUUID(CommandContext<class_2168> context) throws CommandSyntaxException {
        boolean selected;
        UUID uuid;
        class_2168 source = (class_2168)context.getSource();
        try {
            uuid = UUID.fromString(StringArgumentType.getString(context, (String)"uuid"));
        }
        catch (IllegalArgumentException ex) {
            source.method_9213((class_2561)TextUtil.errorText("argument.uuid.invalid", new String[0]));
            return 0;
        }
        TaterzenNPC taterzen = Taterzens.TATERZEN_NPCS.get(uuid);
        if (taterzen == null) {
            source.method_9213((class_2561)TextUtil.errorText("taterzens.error.404.uuid", uuid.toString()));
            return 0;
        }
        class_3222 player = source.method_9207();
        Optional<TaterzenNPC> npc = ((ITaterzenEditor)player).getSelectedNpc();
        if (npc.isPresent()) {
            ((ITaterzenEditor)player).selectNpc(null);
        }
        if (selected = ((ITaterzenEditor)player).selectNpc(taterzen)) {
            source.method_9226(() -> TextUtil.successText("taterzens.command.select", taterzen.method_5477().getString()), false);
            return 1;
        }
        source.method_9213((class_2561)TextUtil.errorText("taterzens.command.error.locked", taterzen.method_5477().getString()));
        return 0;
    }

    private static int removeTaterzen(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        return NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> {
            taterzen.method_5768();
            source.method_9226(() -> TextUtil.successText("taterzens.command.remove", taterzen.method_5477().getString()), false);
            ((ITaterzenEditor)player).selectNpc(null);
        });
    }

    private static int selectTaterzen(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_238 box;
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        class_243 min = player.method_5836(0.0f);
        class_243 vec3d2 = player.method_5828(1.0f);
        class_243 max = min.method_1031(vec3d2.field_1352 * 8.02, vec3d2.field_1351 * 8.02, vec3d2.field_1350 * 8.02);
        class_3966 hit = class_1675.method_18075((class_1297)player, (class_243)min, (class_243)max, (class_238)(box = player.method_5829().method_18804(vec3d2.method_1021(8.02)).method_1014(1.0)), entity -> entity.method_5863() && entity instanceof TaterzenNPC, (double)64.32039999999999);
        if (hit != null) {
            TaterzenNPC taterzen = (TaterzenNPC)hit.method_17782();
            boolean selected = ((ITaterzenEditor)player).selectNpc(taterzen);
            if (selected) {
                source.method_9226(() -> TextUtil.successText("taterzens.command.select", taterzen.method_5477().getString()), false);
            } else {
                source.method_9213((class_2561)TextUtil.errorText("taterzens.command.error.locked", taterzen.method_5477().getString()));
            }
        } else {
            source.method_9213((class_2561)TextUtil.translate("taterzens.error.404.detected", new Object[0]).method_27692(class_124.field_1061));
        }
        return 1;
    }

    private static Collection<String> getOnlinePlayers(CommandContext<class_2168> context) {
        ArrayList<String> names = new ArrayList<String>();
        ((class_2168)context.getSource()).method_9211().method_3760().method_14571().forEach(player -> names.add(player.method_7334().getName()));
        return names;
    }

    private static int spawnTaterzen(CommandContext<class_2168> context) throws CommandSyntaxException {
        String taterzenName;
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        Optional<TaterzenNPC> npc = ((ITaterzenEditor)player).getSelectedNpc();
        if (npc.isPresent()) {
            ((ITaterzenEditor)player).selectNpc(null);
        }
        try {
            taterzenName = class_2196.method_9339(context, (String)"name").getString();
        }
        catch (IllegalArgumentException ignored) {
            taterzenName = player.method_7334().getName();
        }
        TaterzenNPC taterzen = TaterzensAPI.createTaterzen(player, taterzenName);
        taterzen.setPermissionLevel(((ACommandSourceStack)source).getPermissionLevel());
        if (Taterzens.config.lockAfterCreation) {
            taterzen.setLocked((class_1297)player);
        }
        player.method_37908().method_8649((class_1297)taterzen);
        ((ITaterzenEditor)player).selectNpc(taterzen);
        player.method_43496((class_2561)TextUtil.successText("taterzens.command.create", taterzen.method_5477().getString()));
        return 1;
    }
}

