/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.taterzens.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.io.File;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import org.samo_lego.taterzens.Taterzens;
import org.samo_lego.taterzens.api.TaterzensAPI;
import org.samo_lego.taterzens.commands.NpcCommand;
import org.samo_lego.taterzens.interfaces.ITaterzenEditor;
import org.samo_lego.taterzens.npc.TaterzenNPC;
import org.samo_lego.taterzens.util.TextUtil;

public class PresetCommand {
    public static void registerNode(LiteralCommandNode<class_2168> npcNode) {
        LiteralCommandNode presetNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"preset").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"save").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.preset.save", Taterzens.config.perms.npcCommandPermissionLevel))).then(class_2170.method_9244((String)"preset name", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(TaterzensAPI.getPresets(), (SuggestionsBuilder)builder)).executes(PresetCommand::saveTaterzenToPreset)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"load").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.preset.load", Taterzens.config.perms.npcCommandPermissionLevel))).then(class_2170.method_9244((String)"preset name", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(TaterzensAPI.getPresets(), (SuggestionsBuilder)builder)).executes(PresetCommand::loadTaterzenFromPreset)))).build();
        npcNode.addChild((CommandNode)presetNode);
    }

    private static int loadTaterzenFromPreset(CommandContext<class_2168> context) throws CommandSyntaxException {
        String filename = StringArgumentType.getString(context, (String)"preset name") + ".json";
        File preset = new File(Taterzens.getInstance().getPresetDirectory() + "/" + filename);
        class_2168 source = (class_2168)context.getSource();
        if (preset.exists()) {
            TaterzenNPC taterzenNPC = TaterzensAPI.loadTaterzenFromPreset(preset, (class_1937)source.method_9225());
            if (taterzenNPC != null) {
                class_243 pos = source.method_9222();
                class_241 rotation = source.method_9210();
                taterzenNPC.method_5808(pos.method_10216(), pos.method_10214(), pos.method_10215(), rotation.field_1343, rotation.field_1342);
                source.method_9225().method_8649((class_1297)taterzenNPC);
                ((ITaterzenEditor)source.method_9207()).selectNpc(taterzenNPC);
                taterzenNPC.sendProfileUpdates();
                source.method_9226(() -> TextUtil.successText("taterzens.command.preset.import.success", filename), false);
            }
        } else {
            source.method_9213((class_2561)TextUtil.errorText("taterzens.command.preset.import.error.404", filename));
        }
        return -1;
    }

    private static int saveTaterzenToPreset(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            String filename = StringArgumentType.getString((CommandContext)context, (String)"preset name") + ".json";
            File preset = new File(Taterzens.getInstance().getPresetDirectory() + "/" + filename);
            TaterzensAPI.saveTaterzenToPreset(taterzen, preset);
            source.method_9226(() -> TextUtil.successText("taterzens.command.preset.export.success", filename), false);
        });
    }
}

