/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.taterzens.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2321;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import org.samo_lego.config2brigadier.util.TranslatedText;
import org.samo_lego.taterzens.Taterzens;
import org.samo_lego.taterzens.compatibility.ModDiscovery;
import org.samo_lego.taterzens.util.LanguageUtil;
import org.samo_lego.taterzens.util.TextUtil;

public class TaterzensCommand {
    private static final SuggestionProvider<class_2168> AVAILABLE_LANGUAGES = class_2321.method_10022((class_2960)new class_2960("taterzens", "languages"), (context, builder) -> class_2172.method_9265(LanguageUtil.LANG_LIST, (SuggestionsBuilder)builder));
    private static final String DOCS_URL = "https://samolego.github.io/Taterzens/";

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralCommandNode taterzensNode = dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"taterzens").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"wiki").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.wiki_info", Taterzens.config.perms.taterzensCommandPermissionLevel))).executes(TaterzensCommand::wikiInfo)));
        LiteralCommandNode configNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.config", Taterzens.config.perms.taterzensCommandPermissionLevel))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.config.reload", Taterzens.config.perms.taterzensCommandPermissionLevel))).executes(TaterzensCommand::reloadConfig))).build();
        LiteralCommandNode editNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"edit").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.config.edit", Taterzens.config.perms.taterzensCommandPermissionLevel))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"language").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.config.edit.lang", Taterzens.config.perms.taterzensCommandPermissionLevel))).then(class_2170.method_9244((String)"language", (ArgumentType)StringArgumentType.word()).suggests(AVAILABLE_LANGUAGES).executes(TaterzensCommand::setLang)))).build();
        Taterzens.config.generateCommand(editNode);
        configNode.addChild((CommandNode)editNode);
        taterzensNode.addChild((CommandNode)configNode);
    }

    private static int setLang(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String language = StringArgumentType.getString(context, (String)"language");
        TranslatedText.setLang((String)language);
        if (LanguageUtil.LANG_LIST.contains(language)) {
            Taterzens.config.language = language;
            Taterzens.config.save();
            LanguageUtil.setupLanguage();
            source.method_9226(() -> TextUtil.successText("taterzens.command.language.success", language), false);
            if (ModDiscovery.SERVER_TRANSLATIONS_LOADED) {
                source.method_9226(() -> TextUtil.successText("taterzens.command.language.server_translations_hint.1", new String[0]), false);
                source.method_9226(() -> TextUtil.successText("taterzens.command.language.server_translations_hint.2", new String[0]), false);
            }
        } else {
            String url = "https://github.com/samolego/Taterzens#translation-contributions";
            source.method_9213((class_2561)TextUtil.errorText("taterzens.command.language.404", language, url).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, url))));
        }
        return 1;
    }

    private static int wikiInfo(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> TextUtil.successText("taterzens.command.wiki", DOCS_URL).method_27692(class_124.field_1060).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, DOCS_URL)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextUtil.translate("taterzens.tooltip.see_docs", new Object[0])))), false);
        return 1;
    }

    private static int reloadConfig(CommandContext<class_2168> context) {
        TaterzensCommand.reloadConfig();
        ((class_2168)context.getSource()).method_9226(() -> TextUtil.translate("taterzens.command.config.success", new Object[0]).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static void reloadConfig() {
        Taterzens.config.reload();
        LanguageUtil.setupLanguage();
    }
}

