/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.taterzens.commands.edit;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2321;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.samo_lego.taterzens.Taterzens;
import org.samo_lego.taterzens.commands.NpcCommand;
import org.samo_lego.taterzens.commands.edit.TagsCommand;
import org.samo_lego.taterzens.npc.NPCData;
import org.samo_lego.taterzens.util.TextUtil;

public class MovementCommand {
    private static final SuggestionProvider<class_2168> MOVEMENT_TYPES = class_2321.method_10022((class_2960)new class_2960("taterzens", "movement_types"), (context, builder) -> class_2172.method_9265((Iterable)Stream.of(NPCData.Movement.values()).map(Enum::name).collect(Collectors.toList()), (SuggestionsBuilder)builder));
    private static final SuggestionProvider<class_2168> FOLLOW_TYPES = class_2321.method_10022((class_2960)new class_2960("taterzens", "follow_types"), (context, builder) -> class_2172.method_9265((Iterable)Stream.of(NPCData.FollowTypes.values()).map(Enum::name).collect(Collectors.toList()), (SuggestionsBuilder)builder));

    public static void registerNode(LiteralCommandNode<class_2168> editNode) {
        LiteralCommandNode movementNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"movement").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.movement", Taterzens.config.perms.npcCommandPermissionLevel))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"follow").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.movement.follow", Taterzens.config.perms.npcCommandPermissionLevel))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"follow type", (ArgumentType)StringArgumentType.word()).suggests(FOLLOW_TYPES).executes(ctx -> MovementCommand.setFollowType((CommandContext<class_2168>)ctx, NPCData.FollowTypes.valueOf(StringArgumentType.getString((CommandContext)ctx, (String)"follow type"))))).then(class_2170.method_9244((String)"uuid", (ArgumentType)class_2186.method_9309()).executes(ctx -> MovementCommand.setFollowType((CommandContext<class_2168>)ctx, NPCData.FollowTypes.valueOf(StringArgumentType.getString((CommandContext)ctx, (String)"follow type")))))))).then(class_2170.method_9244((String)"movement type", (ArgumentType)StringArgumentType.word()).suggests(MOVEMENT_TYPES).executes(context -> MovementCommand.changeMovement((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"movement type"))))).then(class_2170.method_9247((String)"allowFlight").then(class_2170.method_9244((String)"allowFlight", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean allowFlight = BoolArgumentType.getBool((CommandContext)context, (String)"allowFlight");
            return TagsCommand.setTag((CommandContext<class_2168>)context, "allowFlight", allowFlight, npc -> npc.setAllowFlight(allowFlight));
        })))).build();
        LiteralCommandNode lookNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"look").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.movement", Taterzens.config.perms.npcCommandPermissionLevel))).executes(context -> MovementCommand.changeMovement((CommandContext<class_2168>)context, "FORCED_LOOK"))).build();
        editNode.addChild((CommandNode)movementNode);
        editNode.addChild((CommandNode)lookNode);
    }

    private static int changeMovement(CommandContext<class_2168> context, String movement) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            taterzen.setMovement(NPCData.Movement.valueOf(movement));
            source.method_9226(() -> TextUtil.successText("taterzens.command.movement.set", movement), false);
        });
    }

    private static int setFollowType(CommandContext<class_2168> context, NPCData.FollowTypes followType) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            taterzen.setFollowType(followType);
            if (followType == NPCData.FollowTypes.UUID) {
                try {
                    UUID uuid = class_2186.method_9313((CommandContext)context, (String)"uuid").method_5667();
                    taterzen.setFollowUuid(uuid);
                }
                catch (CommandSyntaxException ignored) {
                    source.method_9213((class_2561)TextUtil.errorText("taterzens.command.movement.follow.error.uuid", followType.toString()));
                }
            }
            source.method_9226(() -> TextUtil.successText("taterzens.command.movement.follow.set", followType.toString()), false);
        });
    }
}

