/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.taterzens.commands.edit;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2196;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.samo_lego.taterzens.Taterzens;
import org.samo_lego.taterzens.commands.NpcCommand;
import org.samo_lego.taterzens.interfaces.ITaterzenEditor;
import org.samo_lego.taterzens.npc.TaterzenNPC;
import org.samo_lego.taterzens.util.TextUtil;

public class ProfessionsCommand {
    private static final SuggestionProvider<class_2168> PROFESSION_SUGESTIONS;

    public static void registerNode(LiteralCommandNode<class_2168> editNode) {
        LiteralCommandNode professionsNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"professions").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.professions", Taterzens.config.perms.npcCommandPermissionLevel))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.professions.remove", Taterzens.config.perms.npcCommandPermissionLevel))).then(class_2170.method_9244((String)"profession type", (ArgumentType)class_2196.method_9340()).suggests(ProfessionsCommand::suggestRemovableProfessions).executes(ctx -> ProfessionsCommand.removeProfession((CommandContext<class_2168>)ctx, new class_2960(class_2196.method_9339((CommandContext)ctx, (String)"profession type").getString())))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.professions.add", Taterzens.config.perms.npcCommandPermissionLevel))).then(class_2170.method_9244((String)"profession type", (ArgumentType)class_2196.method_9340()).suggests(PROFESSION_SUGESTIONS).executes(ctx -> ProfessionsCommand.setProfession((CommandContext<class_2168>)ctx, new class_2960(class_2196.method_9339((CommandContext)ctx, (String)"profession type").getString())))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.professions.list", Taterzens.config.perms.npcCommandPermissionLevel))).executes(ProfessionsCommand::listTaterzenProfessions))).build();
        editNode.addChild((CommandNode)professionsNode);
    }

    private static int listTaterzenProfessions(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            Collection<class_2960> professionIds = taterzen.getProfessionIds();
            class_5250 response = TextUtil.joinText("taterzens.command.profession.list", class_124.field_1075, class_124.field_1054, taterzen.method_5477().getString());
            AtomicInteger i = new AtomicInteger();
            professionIds.forEach(ResourceLocation -> {
                int index = i.get() + 1;
                response.method_10852((class_2561)class_2561.method_43470((String)("\n" + index + "-> " + ResourceLocation.toString() + " (")).method_27692(index % 2 == 0 ? class_124.field_1054 : class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)"X").method_27692(class_124.field_1061).method_27692(class_124.field_1067).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextUtil.translate("taterzens.tooltip.delete", ResourceLocation.method_12832()))).method_10958(new class_2558(class_2558.class_2559.field_11745, "/npc edit professions remove " + ResourceLocation)))).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1070)));
                i.incrementAndGet();
            });
            source.method_9226(() -> response, false);
        });
    }

    private static int removeProfession(CommandContext<class_2168> context, class_2960 id) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            if (taterzen.getProfessionIds().contains(id)) {
                taterzen.removeProfession(id);
                source.method_9226(() -> TextUtil.successText("taterzens.command.profession.remove", id.toString()), false);
            } else {
                ((class_2168)context.getSource()).method_9213((class_2561)TextUtil.errorText("taterzens.command.profession.error.404", id.toString()));
            }
        });
    }

    private static int setProfession(CommandContext<class_2168> context, class_2960 id) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            if (Taterzens.PROFESSION_TYPES.containsKey(id)) {
                taterzen.addProfession(id);
                source.method_9226(() -> TextUtil.successText("taterzens.command.profession.add", id.toString()), false);
            } else {
                ((class_2168)context.getSource()).method_9213((class_2561)TextUtil.errorText("taterzens.command.profession.error.404", id.toString()));
            }
        });
    }

    private static CompletableFuture<Suggestions> suggestRemovableProfessions(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        Collection<Object> professions = new HashSet();
        try {
            Optional<TaterzenNPC> taterzen = ((ITaterzenEditor)((class_2168)ctx.getSource()).method_9207()).getSelectedNpc();
            if (taterzen.isPresent()) {
                professions = taterzen.get().getProfessionIds();
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return class_2172.method_9264(professions.stream().map(class_2960::toString), (SuggestionsBuilder)builder);
    }

    static {
        HashSet<class_2960> availableProfessions = new HashSet<class_2960>(Taterzens.PROFESSION_TYPES.keySet());
        List<String> professions = availableProfessions.stream().map(class_2960::toString).toList();
        PROFESSION_SUGESTIONS = (context, builder) -> class_2172.method_9265((Iterable)professions, (SuggestionsBuilder)builder);
    }
}

