/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.taterzens.commands.edit;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2196;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import org.samo_lego.taterzens.Taterzens;
import org.samo_lego.taterzens.commands.NpcCommand;
import org.samo_lego.taterzens.compatibility.ModDiscovery;
import org.samo_lego.taterzens.mixin.accessors.APlayer;
import org.samo_lego.taterzens.util.TextUtil;
import org.samo_lego.taterzens.util.WebUtil;

public class SkinCommand {
    private static final String MINESKIN_API_URL = "https://api.mineskin.org/get/uuid/";
    private static final String MOJANG_NAME2UUID = "https://api.mojang.com/users/profiles/minecraft/";
    private static final String MOJANG_UUID2SKIN = "https://sessionserver.mojang.com/session/minecraft/profile/%s?unsigned=false";
    private static final ExecutorService THREADPOOL = Executors.newCachedThreadPool();

    public static void registerNode(LiteralCommandNode<class_2168> editNode) {
        LiteralCommandNode skinNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"skin").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.skin", Taterzens.config.perms.npcCommandPermissionLevel))).then(class_2170.method_9244((String)"mineskin|player", (ArgumentType)class_2196.method_9340()).executes(SkinCommand::setCustomSkin))).executes(SkinCommand::copySkinLayers)).build();
        editNode.addChild((CommandNode)skinNode);
    }

    private static int setCustomSkin(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        String id = class_2196.method_9339(context, (String)"mineskin|player").getString();
        class_1297 entity = source.method_9229();
        return NpcCommand.selectedTaterzenExecutor(entity, taterzen -> {
            if (Taterzens.config.fabricTailorAdvert) {
                if (ModDiscovery.FABRICTAILOR_LOADED) {
                    source.method_9226(() -> TextUtil.translate("advert.fabrictailor.skin_command", new Object[0]).method_27692(class_124.field_1065).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/skin set"))), false);
                } else {
                    source.method_9226(() -> TextUtil.translate("advert.fabrictailor", new Object[0]).method_27692(class_124.field_1056).method_27692(class_124.field_1065).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://modrinth.com/mod/FabricTailor")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextUtil.translate("advert.tooltip.install", "FabricTailor")))), false);
                }
            }
            THREADPOOL.submit(() -> {
                URL url = null;
                if (id.contains(":")) {
                    String param = id.substring(id.lastIndexOf(47) + 1);
                    String mineskinUrl = MINESKIN_API_URL + param;
                    try {
                        url = new URL(mineskinUrl);
                    }
                    catch (MalformedURLException e) {
                        source.method_9213((class_2561)TextUtil.errorText("taterzens.error.invalid.url", mineskinUrl));
                    }
                } else {
                    try {
                        String uuidReply = WebUtil.urlRequest(new URL(MOJANG_NAME2UUID + id));
                        if (uuidReply != null) {
                            JsonObject replyJson = (JsonObject)Taterzens.GSON.fromJson(uuidReply, JsonObject.class);
                            String uuid = replyJson.get("id").getAsString();
                            url = new URL(String.format(MOJANG_UUID2SKIN, uuid));
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (url != null) {
                    try {
                        String reply = WebUtil.urlRequest(url);
                        if (reply != null && !reply.contains("error") && !reply.isEmpty()) {
                            String value = reply.split("\"value\":\"")[1].split("\"")[0];
                            String signature = reply.split("\"signature\":\"")[1].split("\"")[0];
                            if (!value.isEmpty() && !signature.isEmpty()) {
                                class_2487 skinTag = new class_2487();
                                skinTag.method_10582("value", value);
                                skinTag.method_10582("signature", signature);
                                taterzen.setSkinFromTag(skinTag);
                                taterzen.sendProfileUpdates();
                                ((class_2168)context.getSource()).method_9226(() -> TextUtil.successText("taterzens.command.skin.fetched", id), false);
                            }
                        } else {
                            ((class_2168)context.getSource()).method_9213((class_2561)TextUtil.errorText("taterzens.command.skin.error", id));
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        });
    }

    private static int copySkinLayers(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        return NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> {
            Byte skinLayers = (Byte)player.method_5841().method_12789(APlayer.getPLAYER_MODE_CUSTOMISATION());
            taterzen.setSkinLayers(skinLayers);
            taterzen.sendProfileUpdates();
            source.method_9226(() -> TextUtil.successText("taterzens.command.skin.mirrored", taterzen.method_5477().getString()), false);
        });
    }
}

