/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.taterzens.commands.edit;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2321;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.samo_lego.taterzens.Taterzens;
import org.samo_lego.taterzens.commands.NpcCommand;
import org.samo_lego.taterzens.npc.TaterzenNPC;
import org.samo_lego.taterzens.util.TextUtil;

public class SoundCommand {
    public static void registerNode(LiteralCommandNode<class_2168> editNode) {
        LiteralCommandNode soundNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sounds").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.sounds", Taterzens.config.perms.npcCommandPermissionLevel))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzen.npc.edit.sounds.list", Taterzens.config.perms.npcCommandPermissionLevel))).then(class_2170.method_9247((String)"all").executes(SoundCommand::listAllSounds))).then(class_2170.method_9247((String)"ambient").executes(SoundCommand::listAmbientSounds))).then(class_2170.method_9247((String)"hurt").executes(SoundCommand::listHurtSounds))).then(class_2170.method_9247((String)"death").executes(SoundCommand::listDeathSounds)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzen.npc.edit.sounds.add", Taterzens.config.perms.npcCommandPermissionLevel))).then(class_2170.method_9247((String)"ambient").then(class_2170.method_9244((String)"ambientSound", (ArgumentType)class_2232.method_9441()).suggests(class_2321.field_10934).executes(SoundCommand::addAmbientSound)))).then(class_2170.method_9247((String)"hurt").then(class_2170.method_9244((String)"hurtSound", (ArgumentType)class_2232.method_9441()).suggests(class_2321.field_10934).executes(SoundCommand::addHurtSound)))).then(class_2170.method_9247((String)"death").then(class_2170.method_9244((String)"deathSound", (ArgumentType)class_2232.method_9441()).suggests(class_2321.field_10934).executes(SoundCommand::addDeathSound))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzen.npc.edit.sounds.remove", Taterzens.config.perms.npcCommandPermissionLevel))).then(class_2170.method_9247((String)"all").executes(SoundCommand::removeAllSounds))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ambient").then(class_2170.method_9247((String)"all").executes(SoundCommand::removeAllAmbientSounds))).then(class_2170.method_9247((String)"index").then(class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((context, builder) -> class_2172.method_9253((String[])SoundCommand.getAvailableAmbientSoundIndices((CommandContext<class_2168>)context), (SuggestionsBuilder)builder)).executes(SoundCommand::removeAmbientSoundByIndex)))).then(class_2170.method_9247((String)"resource").then(class_2170.method_9244((String)"resource", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> class_2172.method_9253((String[])SoundCommand.getAvailableAmbientSounds((CommandContext<class_2168>)context), (SuggestionsBuilder)builder)).executes(SoundCommand::removeAmbientSoundByResource))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"hurt").then(class_2170.method_9247((String)"all").executes(SoundCommand::removeAllHurtSounds))).then(class_2170.method_9247((String)"index").then(class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((context, builder) -> class_2172.method_9253((String[])SoundCommand.getAvailableHurtSoundIndices((CommandContext<class_2168>)context), (SuggestionsBuilder)builder)).executes(SoundCommand::removeHurtSoundByIndex)))).then(class_2170.method_9247((String)"resource").then(class_2170.method_9244((String)"resource", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> class_2172.method_9253((String[])SoundCommand.getAvailableHurtSounds((CommandContext<class_2168>)context), (SuggestionsBuilder)builder)).executes(SoundCommand::removeHurtSoundByResource))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"death").then(class_2170.method_9247((String)"all").executes(SoundCommand::removeAllDeathSounds))).then(class_2170.method_9247((String)"index").then(class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((context, builder) -> class_2172.method_9253((String[])SoundCommand.getAvailableDeathSoundIndices((CommandContext<class_2168>)context), (SuggestionsBuilder)builder)).executes(SoundCommand::removeDeathSoundByIndex)))).then(class_2170.method_9247((String)"resource").then(class_2170.method_9244((String)"resource", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> class_2172.method_9253((String[])SoundCommand.getAvailableDeathSounds((CommandContext<class_2168>)context), (SuggestionsBuilder)builder)).executes(SoundCommand::removeDeathSoundByResource)))))).build();
        editNode.addChild((CommandNode)soundNode);
    }

    private static String[] getAvailableAmbientSoundIndices(CommandContext<class_2168> context) throws CommandSyntaxException {
        AtomicReference ambientSounds;
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        int result = NpcCommand.selectedTaterzenExecutor((class_1297)player, arg_0 -> SoundCommand.lambda$getAvailableAmbientSoundIndices$10(ambientSounds = new AtomicReference(), arg_0));
        if (result == 1) {
            String[] availableIndices = new String[((ArrayList)ambientSounds.get()).size()];
            for (int i = 0; i < ((ArrayList)ambientSounds.get()).size(); ++i) {
                availableIndices[i] = Integer.toString(i + 1);
            }
            return availableIndices;
        }
        return new String[0];
    }

    private static String[] getAvailableHurtSoundIndices(CommandContext<class_2168> context) throws CommandSyntaxException {
        AtomicReference hurtSounds;
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        int result = NpcCommand.selectedTaterzenExecutor((class_1297)player, arg_0 -> SoundCommand.lambda$getAvailableHurtSoundIndices$11(hurtSounds = new AtomicReference(), arg_0));
        if (result == 1) {
            String[] availableIndices = new String[((ArrayList)hurtSounds.get()).size()];
            for (int i = 0; i < ((ArrayList)hurtSounds.get()).size(); ++i) {
                availableIndices[i] = Integer.toString(i + 1);
            }
            return availableIndices;
        }
        return new String[0];
    }

    private static String[] getAvailableDeathSoundIndices(CommandContext<class_2168> context) throws CommandSyntaxException {
        AtomicReference deathSounds;
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        int result = NpcCommand.selectedTaterzenExecutor((class_1297)player, arg_0 -> SoundCommand.lambda$getAvailableDeathSoundIndices$12(deathSounds = new AtomicReference(), arg_0));
        if (result == 1) {
            String[] availableIndices = new String[((ArrayList)deathSounds.get()).size()];
            for (int i = 0; i < ((ArrayList)deathSounds.get()).size(); ++i) {
                availableIndices[i] = Integer.toString(i + 1);
            }
            return availableIndices;
        }
        return new String[0];
    }

    private static String[] getAvailableAmbientSounds(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        AtomicReference ambientSounds = new AtomicReference();
        NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> ambientSounds.set(taterzen.getAmbientSoundData()));
        return ((ArrayList)ambientSounds.get()).toArray(new String[0]);
    }

    private static String[] getAvailableHurtSounds(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        AtomicReference hurtSounds = new AtomicReference();
        NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> hurtSounds.set(taterzen.getHurtSoundData()));
        return ((ArrayList)hurtSounds.get()).toArray(new String[0]);
    }

    private static String[] getAvailableDeathSounds(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        AtomicReference deathSounds = new AtomicReference();
        NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> deathSounds.set(taterzen.getDeathSoundData()));
        return ((ArrayList)deathSounds.get()).toArray(new String[0]);
    }

    private static int removeAllSounds(CommandContext<class_2168> context) throws CommandSyntaxException {
        return SoundCommand.removeAllAmbientSounds(context) + SoundCommand.removeAllHurtSounds(context) + SoundCommand.removeAllDeathSounds(context) == 3 ? 1 : 0;
    }

    private static int removeAllAmbientSounds(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        int result = NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> taterzen.setAmbientSoundData(new ArrayList<String>()));
        if (result == 1) {
            source.method_9226(() -> TextUtil.successText("taterzens.command.sounds.remove.all.success", TextUtil.translate("taterzens.command.sounds.ambient", new Object[0]).getString()), false);
        } else {
            source.method_9213((class_2561)TextUtil.errorText("taterzens.command.sounds.remove.all.failure", TextUtil.translate("taterzens.command.sounds.ambient", new Object[0]).getString()));
        }
        return result;
    }

    private static int removeAmbientSoundByIndex(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        int idx = IntegerArgumentType.getInteger(context, (String)"index") - 1;
        AtomicReference<String> soundResource = new AtomicReference<String>("");
        AtomicBoolean success = new AtomicBoolean(false);
        NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> {
            try {
                if (!taterzen.getAmbientSoundData().isEmpty()) {
                    soundResource.set(taterzen.getAmbientSoundData().get(idx));
                    taterzen.removeAmbientSound(idx);
                    source.method_9226(() -> TextUtil.successText("taterzens.command.sounds.remove.success", (String)soundResource.get()), false);
                } else {
                    source.method_9226(() -> TextUtil.successText("taterzens.command.sounds.list.empty", new String[0]), false);
                }
                success.set(true);
            }
            catch (IndexOutOfBoundsException err) {
                source.method_9213((class_2561)TextUtil.errorText("taterzens.command.sounds.remove.outofbounds", Integer.toString(idx + 1), "1", Integer.toString(taterzen.getAmbientSoundData().size())));
                success.set(false);
            }
        });
        if (success.get()) {
            return 1;
        }
        source.method_9213((class_2561)TextUtil.errorText("taterzens.command.sounds.remove.failure", soundResource.get()));
        return 0;
    }

    private static int removeAmbientSoundByResource(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        String resource = class_2232.method_9443(context, (String)"resource").toString();
        AtomicReference soundData = new AtomicReference();
        AtomicBoolean success = new AtomicBoolean(false);
        NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> {
            soundData.set(taterzen.getAmbientSoundData());
            int idx = SoundCommand.indexOfStringInArrayList(resource, (ArrayList)soundData.get());
            if (idx >= 0) {
                taterzen.removeAmbientSound(idx);
                source.method_9226(() -> TextUtil.successText("taterzens.command.sounds.remove.success", resource), false);
                success.set(true);
            } else {
                source.method_9213((class_2561)TextUtil.errorText("taterzens.command.sounds.404", resource, TextUtil.translate("taterzens.command.sounds.ambient", new Object[0]).getString()));
                success.set(false);
            }
        });
        if (success.get()) {
            return 1;
        }
        source.method_9213((class_2561)TextUtil.errorText("taterzens.command.sounds.remove.failure", resource));
        return 0;
    }

    private static int removeAllHurtSounds(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        int result = NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> taterzen.setHurtSoundData(new ArrayList<String>()));
        if (result == 1) {
            source.method_9226(() -> TextUtil.successText("taterzens.command.sounds.remove.all.success", TextUtil.translate("taterzens.command.sounds.hurt", new Object[0]).getString()), false);
        } else {
            source.method_9213((class_2561)TextUtil.errorText("taterzens.command.sounds.remove.all.failure", TextUtil.translate("taterzens.command.sounds.hurt", new Object[0]).getString()));
        }
        return result;
    }

    private static int removeHurtSoundByIndex(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        int idx = IntegerArgumentType.getInteger(context, (String)"index") - 1;
        AtomicReference<String> soundResource = new AtomicReference<String>("");
        AtomicBoolean success = new AtomicBoolean(false);
        NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> {
            try {
                if (!taterzen.getHurtSoundData().isEmpty()) {
                    soundResource.set(taterzen.getHurtSoundData().get(idx));
                    taterzen.removeHurtSound(idx);
                    source.method_9226(() -> TextUtil.successText("taterzens.command.sounds.remove.success", (String)soundResource.get()), false);
                } else {
                    source.method_9226(() -> TextUtil.successText("taterzens.command.sounds.list.empty", new String[0]), false);
                }
                success.set(true);
            }
            catch (IndexOutOfBoundsException err) {
                source.method_9213((class_2561)TextUtil.errorText("taterzens.command.sounds.remove.outofbounds", Integer.toString(idx + 1), "1", Integer.toString(taterzen.getHurtSoundData().size())));
                success.set(false);
            }
        });
        if (success.get()) {
            return 1;
        }
        source.method_9213((class_2561)TextUtil.errorText("taterzens.command.sounds.remove.failure", soundResource.get()));
        return 0;
    }

    private static int removeHurtSoundByResource(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        String resource = class_2232.method_9443(context, (String)"resource").toString();
        AtomicReference soundData = new AtomicReference();
        AtomicBoolean success = new AtomicBoolean(false);
        NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> {
            soundData.set(taterzen.getHurtSoundData());
            int idx = SoundCommand.indexOfStringInArrayList(resource, (ArrayList)soundData.get());
            if (idx >= 0) {
                taterzen.removeHurtSound(idx);
                source.method_9226(() -> TextUtil.successText("taterzens.command.sounds.remove.success", resource), false);
                success.set(true);
            } else {
                source.method_9213((class_2561)TextUtil.errorText("taterzens.command.sounds.404", resource, TextUtil.translate("taterzens.command.sounds.hurt", new Object[0]).getString()));
                success.set(false);
            }
        });
        if (success.get()) {
            return 1;
        }
        source.method_9213((class_2561)TextUtil.errorText("taterzens.command.sounds.remove.failure", resource));
        return 0;
    }

    private static int removeAllDeathSounds(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        int result = NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> taterzen.setDeathSoundData(new ArrayList<String>()));
        if (result == 1) {
            source.method_9226(() -> TextUtil.successText("taterzens.command.sounds.remove.all.success", TextUtil.translate("taterzens.command.sounds.death", new Object[0]).getString()), false);
        } else {
            source.method_9213((class_2561)TextUtil.errorText("taterzens.command.sounds.remove.all.failure", TextUtil.translate("taterzens.command.sounds.death", new Object[0]).getString()));
        }
        return result;
    }

    private static int removeDeathSoundByIndex(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        int idx = IntegerArgumentType.getInteger(context, (String)"index") - 1;
        AtomicReference<String> soundResource = new AtomicReference<String>("");
        AtomicBoolean success = new AtomicBoolean(false);
        NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> {
            try {
                if (!taterzen.getDeathSoundData().isEmpty()) {
                    soundResource.set(taterzen.getDeathSoundData().get(idx));
                    taterzen.removeDeathSound(idx);
                    source.method_9226(() -> TextUtil.successText("taterzens.command.sounds.remove.success", (String)soundResource.get()), false);
                } else {
                    source.method_9226(() -> TextUtil.successText("taterzens.command.sounds.list.empty", new String[0]), false);
                }
                success.set(true);
            }
            catch (IndexOutOfBoundsException err) {
                source.method_9213((class_2561)TextUtil.errorText("taterzens.command.sounds.remove.outofbounds", Integer.toString(idx + 1), "1", Integer.toString(taterzen.getDeathSoundData().size())));
                success.set(false);
            }
        });
        if (success.get()) {
            return 1;
        }
        source.method_9213((class_2561)TextUtil.errorText("taterzens.command.sounds.remove.failure", soundResource.get()));
        return 0;
    }

    private static int removeDeathSoundByResource(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        String resource = class_2232.method_9443(context, (String)"resource").toString();
        AtomicReference soundData = new AtomicReference();
        AtomicBoolean success = new AtomicBoolean(false);
        NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> {
            soundData.set(taterzen.getDeathSoundData());
            int idx = SoundCommand.indexOfStringInArrayList(resource, (ArrayList)soundData.get());
            if (idx >= 0) {
                taterzen.removeDeathSound(idx);
                source.method_9226(() -> TextUtil.successText("taterzens.command.sounds.remove.success", resource), false);
                success.set(true);
            } else {
                source.method_9213((class_2561)TextUtil.errorText("taterzens.command.sounds.404", resource, TextUtil.translate("taterzens.command.sounds.death", new Object[0]).getString()));
                success.set(false);
            }
        });
        if (success.get()) {
            return 1;
        }
        source.method_9213((class_2561)TextUtil.errorText("taterzens.command.sounds.remove.failure", resource));
        return 0;
    }

    private static int addAmbientSound(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        String soundResource = class_2232.method_9443(context, (String)"ambientSound").toString();
        if (!class_2960.method_20207((String)soundResource)) {
            source.method_9213((class_2561)TextUtil.errorText("taterzens.command.sounds.invalid", new String[0]));
            return 0;
        }
        int result = NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> taterzen.addAmbientSound(soundResource));
        if (result == 1) {
            source.method_9226(() -> TextUtil.successText("taterzens.command.sounds.add.success", soundResource), false);
        } else {
            source.method_9213((class_2561)TextUtil.errorText("taterzens.command.sounds.add.failure", soundResource));
        }
        return result;
    }

    private static int addHurtSound(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        String soundResource = class_2232.method_9443(context, (String)"hurtSound").toString();
        if (!class_2960.method_20207((String)soundResource)) {
            source.method_9213((class_2561)TextUtil.errorText("taterzens.command.sounds.invalid", new String[0]));
            return 0;
        }
        int result = NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> taterzen.addHurtSound(soundResource));
        if (result == 1) {
            source.method_9226(() -> TextUtil.successText("taterzens.command.sounds.add.success", soundResource), false);
        } else {
            source.method_9213((class_2561)TextUtil.errorText("taterzens.command.sounds.add.failure", soundResource));
        }
        return result;
    }

    private static int addDeathSound(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        String soundResource = class_2232.method_9443(context, (String)"deathSound").toString();
        if (!class_2960.method_20207((String)soundResource)) {
            source.method_9213((class_2561)TextUtil.errorText("taterzens.command.sounds.invalid", new String[0]));
            return 0;
        }
        int result = NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> taterzen.addDeathSound(soundResource));
        if (result == 1) {
            source.method_9226(() -> TextUtil.successText("taterzens.command.sounds.add.success", soundResource), false);
        } else {
            source.method_9213((class_2561)TextUtil.errorText("taterzens.command.sounds.add.failure", soundResource));
        }
        return result;
    }

    private static int listAllSounds(CommandContext<class_2168> context) throws CommandSyntaxException {
        return SoundCommand.listAmbientSounds(context) + SoundCommand.listHurtSounds(context) + SoundCommand.listDeathSounds(context) == 3 ? 1 : 0;
    }

    private static int listAmbientSounds(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        class_5250 response = TextUtil.translate("taterzens.command.sounds.list.ambient", new Object[0]).method_27692(class_124.field_1075);
        return NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> {
            ArrayList<String> ambientSounds = taterzen.getAmbientSoundData();
            if (!ambientSounds.isEmpty()) {
                for (int i = 0; i < ambientSounds.size(); ++i) {
                    int idx = i + 1;
                    response.method_10852((class_2561)class_2561.method_43470((String)("\n" + idx + ": " + ambientSounds.get(i))).method_27692(i % 2 == 0 ? class_124.field_1077 : class_124.field_1058));
                }
            } else {
                response.method_10852((class_2561)class_2561.method_43470((String)(" " + TextUtil.translate("taterzens.command.sounds.list.empty", new Object[0]).getString())).method_27692(class_124.field_1054));
            }
            source.method_9226(() -> response, false);
        });
    }

    private static int listHurtSounds(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        class_5250 response = TextUtil.translate("taterzens.command.sounds.list.hurt", new Object[0]).method_27692(class_124.field_1075);
        return NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> {
            ArrayList<String> hurtSounds = taterzen.getHurtSoundData();
            if (!hurtSounds.isEmpty()) {
                for (int i = 0; i < hurtSounds.size(); ++i) {
                    int idx = i + 1;
                    response.method_10852((class_2561)class_2561.method_43470((String)("\n" + idx + ": " + hurtSounds.get(i))).method_27692(i % 2 == 0 ? class_124.field_1077 : class_124.field_1058));
                }
            } else {
                response.method_10852((class_2561)class_2561.method_43470((String)(" " + TextUtil.translate("taterzens.command.sounds.list.empty", new Object[0]).getString())).method_27692(class_124.field_1054));
            }
            source.method_9226(() -> response, false);
        });
    }

    private static int listDeathSounds(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        class_5250 response = TextUtil.translate("taterzens.command.sounds.list.death", new Object[0]).method_27692(class_124.field_1075);
        return NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> {
            ArrayList<String> deathSounds = taterzen.getDeathSoundData();
            if (!deathSounds.isEmpty()) {
                for (int i = 0; i < deathSounds.size(); ++i) {
                    int idx = i + 1;
                    response.method_10852((class_2561)class_2561.method_43470((String)("\n" + idx + ": " + deathSounds.get(i))).method_27692(i % 2 == 0 ? class_124.field_1077 : class_124.field_1058));
                }
            } else {
                response.method_10852((class_2561)class_2561.method_43470((String)(" " + TextUtil.translate("taterzens.command.sounds.list.empty", new Object[0]).getString())).method_27692(class_124.field_1054));
            }
            source.method_9226(() -> response, false);
        });
    }

    private static int indexOfStringInArrayList(String term, ArrayList<String> list) {
        for (int c = 0; c < list.size(); ++c) {
            if (!term.equals(list.get(c))) continue;
            return c;
        }
        return -1;
    }

    private static /* synthetic */ void lambda$getAvailableDeathSoundIndices$12(AtomicReference deathSounds, TaterzenNPC taterzen) {
        deathSounds.set(taterzen.getDeathSoundData());
    }

    private static /* synthetic */ void lambda$getAvailableHurtSoundIndices$11(AtomicReference hurtSounds, TaterzenNPC taterzen) {
        hurtSounds.set(taterzen.getHurtSoundData());
    }

    private static /* synthetic */ void lambda$getAvailableAmbientSoundIndices$10(AtomicReference ambientSounds, TaterzenNPC taterzen) {
        ambientSounds.set(taterzen.getAmbientSoundData());
    }
}

