/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.taterzens.commands.edit.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2321;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.samo_lego.taterzens.Taterzens;
import org.samo_lego.taterzens.commands.NpcCommand;
import org.samo_lego.taterzens.commands.edit.commands.CooldownCommand;
import org.samo_lego.taterzens.npc.commands.AbstractTaterzenCommand;
import org.samo_lego.taterzens.npc.commands.BungeeCommand;
import org.samo_lego.taterzens.npc.commands.CommandGroups;
import org.samo_lego.taterzens.npc.commands.MinecraftCommand;
import org.samo_lego.taterzens.util.TextUtil;

public class CommandsCommand {
    private static final SuggestionProvider<class_2168> BUNGEE_COMMANDS = class_2321.method_10022((class_2960)new class_2960("taterzens", "bungee_commands"), (context, builder) -> class_2172.method_9265((Iterable)Stream.of(BungeeCommand.BungeeMessage.values()).map(cmd -> cmd.toString().toLowerCase()).collect(Collectors.toList()), (SuggestionsBuilder)builder));
    private static final SuggestionProvider<class_2168> PLAYERS = class_2321.method_10022((class_2960)new class_2960("taterzens", "players"), (context, builder) -> {
        Collection names = ((class_2172)context.getSource()).method_9262();
        names.add("--clicker--");
        return class_2172.method_9265((Iterable)names, (SuggestionsBuilder)builder);
    });

    public static void registerNode(CommandDispatcher<class_2168> dispatcher, LiteralCommandNode<class_2168> editNode) {
        LiteralCommandNode commandsNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"commands").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setPermissionLevel").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.commands.set_permission_level", Taterzens.config.perms.npcCommandPermissionLevel))).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)4)).executes(CommandsCommand::setPermissionLevel)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"group").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.commands.group", Taterzens.config.perms.npcCommandPermissionLevel))).then(class_2170.method_9247((String)"new").executes(CommandsCommand::newGroup))).then(class_2170.method_9247((String)"id").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"group number", (ArgumentType)IntegerArgumentType.integer((int)0)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"delete").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.commands.group.delete", Taterzens.config.perms.npcCommandPermissionLevel))).executes(CommandsCommand::deleteGroup))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"removeCommand").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.commands.remove", Taterzens.config.perms.npcCommandPermissionLevel))).then(class_2170.method_9244((String)"command id", (ArgumentType)IntegerArgumentType.integer()).executes(CommandsCommand::removeCommandFromGroup)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.commands.add", Taterzens.config.perms.npcCommandPermissionLevel))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"minecraft").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.commands.add.minecraft", Taterzens.config.perms.npcCommandPermissionLevel))).redirect((CommandNode)dispatcher.getRoot(), context -> {
            String cmd = CommandsCommand.addCommand((CommandContext<class_2168>)context);
            throw new SimpleCommandExceptionType((Message)(cmd == null ? NpcCommand.noSelectedTaterzenError() : TextUtil.joinText("taterzens.command.commands.set", class_124.field_1065, class_124.field_1080, "/" + cmd))).create();
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"bungee").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.commands.add.bungee", Taterzens.config.perms.npcCommandPermissionLevel))).then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.string()).suggests(BUNGEE_COMMANDS).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).suggests(PLAYERS).then(class_2170.method_9244((String)"argument", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(BungeeCommand.AVAILABLE_SERVERS, (SuggestionsBuilder)builder)).executes(CommandsCommand::addBungeeCommand))).executes(CommandsCommand::addBungeeCommand)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.commands.clear", Taterzens.config.perms.npcCommandPermissionLevel))).executes(CommandsCommand::clearGroupCommands))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.commands.list", Taterzens.config.perms.npcCommandPermissionLevel))).executes(CommandsCommand::listGroupCommands)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.commands.add", Taterzens.config.perms.npcCommandPermissionLevel))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"minecraft").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.commands.add.minecraft", Taterzens.config.perms.npcCommandPermissionLevel))).redirect((CommandNode)dispatcher.getRoot(), context -> {
            String cmd = CommandsCommand.addCommand((CommandContext<class_2168>)context);
            throw new SimpleCommandExceptionType((Message)(cmd == null ? NpcCommand.noSelectedTaterzenError() : TextUtil.joinText("taterzens.command.commands.set", class_124.field_1065, class_124.field_1080, "/" + cmd))).create();
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"bungee").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.commands.add.bungee", Taterzens.config.perms.npcCommandPermissionLevel))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.string()).suggests(BUNGEE_COMMANDS).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).suggests(PLAYERS).then(class_2170.method_9244((String)"argument", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(BungeeCommand.AVAILABLE_SERVERS, (SuggestionsBuilder)builder)).executes(CommandsCommand::addBungeeCommand)))).executes(CommandsCommand::addBungeeCommand))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.commands.clear", Taterzens.config.perms.npcCommandPermissionLevel))).executes(CommandsCommand::clearAllCommands))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.commands.list", Taterzens.config.perms.npcCommandPermissionLevel))).executes(CommandsCommand::listAllTaterzenCommands))).build();
        CooldownCommand.registerNode((LiteralCommandNode<class_2168>)commandsNode);
        editNode.addChild((CommandNode)commandsNode);
    }

    private static int newGroup(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            int ix = taterzen.getCommandGroups().createGroup();
            source.method_9226(() -> TextUtil.successText("taterzens.command.commands.group.created", String.valueOf(ix + 1)), false);
        });
    }

    private static int listGroupCommands(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        int groupIndex = IntegerArgumentType.getInteger(context, (String)"group number") - 1;
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            ArrayList<AbstractTaterzenCommand> commands = taterzen.getGroupCommands(groupIndex);
            String separator = "\n-------------------------------------------------";
            class_5250 response = TextUtil.joinText("taterzens.command.commands.list", class_124.field_1075, class_124.field_1054, taterzen.method_5477().getString());
            response.method_27693("\n-------------------------------------------------");
            if (!commands.isEmpty()) {
                response.method_27693("\n");
                response.method_10852((class_2561)TextUtil.joinText("taterzens.command.commands.group", class_124.field_1076, class_124.field_1079, "#" + (groupIndex + 1)));
                response.method_27693("\n-------------------------------------------------");
                for (int i = 0; i < commands.size(); ++i) {
                    AbstractTaterzenCommand cmd = commands.get(i);
                    int finalJ = i + 1;
                    response.method_10852((class_2561)class_2561.method_43470((String)("\n" + (i + 1) + "-> ")).method_27692(i % 2 == 0 ? class_124.field_1054 : class_124.field_1065).method_27693(cmd.toString()).method_27693("   ").method_27693("(" + cmd.getType().toString().toLowerCase() + ")").method_27693("   ").method_10852((class_2561)class_2561.method_43470((String)"X").method_27692(class_124.field_1061).method_27692(class_124.field_1067).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextUtil.translate("taterzens.tooltip.delete", finalJ))).method_10958(new class_2558(class_2558.class_2559.field_11745, "/npc edit commands group id " + (groupIndex + 1) + " removeCommand " + finalJ)))));
                }
            }
            source.method_9226(() -> response, false);
        });
    }

    private static int deleteGroup(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        int groupIndex = IntegerArgumentType.getInteger(context, (String)"group number") - 1;
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            CommandGroups cmds = taterzen.getCommandGroups();
            if (groupIndex >= cmds.size()) {
                source.method_9226(() -> TextUtil.errorText("taterzens.command.commands.error.group.404", String.valueOf(groupIndex + 1)), false);
            } else {
                source.method_9226(() -> TextUtil.successText("taterzens.command.commands.group.removed", String.valueOf(groupIndex)), false);
                taterzen.clearGroupCommands(groupIndex);
            }
        });
    }

    private static int removeCommandFromGroup(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        int groupIndex = IntegerArgumentType.getInteger(context, (String)"group number") - 1;
        int cmdIx = IntegerArgumentType.getInteger(context, (String)"command id") - 1;
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            CommandGroups cmds = taterzen.getCommandGroups();
            if (groupIndex >= cmds.size() || cmdIx >= ((ArrayList)cmds.get(groupIndex)).size()) {
                source.method_9226(() -> TextUtil.errorText("taterzens.command.commands.error.404", String.valueOf(cmdIx)), false);
            } else {
                source.method_9226(() -> TextUtil.successText("taterzens.command.commands.removed", ((AbstractTaterzenCommand)((ArrayList)cmds.get(groupIndex)).get(cmdIx)).toString()), false);
                taterzen.removeGroupCommand(groupIndex, cmdIx);
            }
        });
    }

    private static int clearAllCommands(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            source.method_9226(() -> TextUtil.successText("taterzens.command.commands.cleared", taterzen.method_5477().getString()), false);
            taterzen.clearAllCommands();
        });
    }

    private static int clearGroupCommands(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        int groupIndex = IntegerArgumentType.getInteger(context, (String)"group number") - 1;
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            source.method_9226(() -> TextUtil.successText("taterzens.command.commands.group.cleared", String.valueOf(groupIndex)), false);
            taterzen.clearGroupCommands(groupIndex);
        });
    }

    private static int listAllTaterzenCommands(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            CommandGroups commands = taterzen.getCommandGroups();
            String separator = "\n-------------------------------------------------";
            class_5250 response = TextUtil.joinText("taterzens.command.commands.list", class_124.field_1075, class_124.field_1054, taterzen.method_5477().getString());
            response.method_27693("\n-------------------------------------------------");
            if (!commands.isEmpty()) {
                for (int i = 0; i < commands.size(); ++i) {
                    int finali = i + 1;
                    ArrayList cmdGrp = (ArrayList)commands.get(i);
                    response.method_27693("\n");
                    response.method_10852((class_2561)TextUtil.joinText("taterzens.command.commands.group", class_124.field_1076, class_124.field_1079, "#" + (i + 1)));
                    response.method_27693("   ").method_10852((class_2561)class_2561.method_43470((String)"X").method_27692(class_124.field_1067).method_27692(class_124.field_1061).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextUtil.translate("taterzens.tooltip.delete", finali))).method_10958(new class_2558(class_2558.class_2559.field_11745, "/npc edit commands group id " + finali + " delete"))));
                    for (int j = 0; j < cmdGrp.size(); ++j) {
                        AbstractTaterzenCommand cmd = (AbstractTaterzenCommand)cmdGrp.get(j);
                        int finalJ = j + 1;
                        response.method_10852((class_2561)class_2561.method_43470((String)("\n" + finalJ + "-> ")).method_27692(j % 2 == 0 ? class_124.field_1054 : class_124.field_1065).method_27693(cmd.toString()).method_27693("   ").method_27693("(" + cmd.getType().toString().toLowerCase() + ")").method_27693("   ").method_10852((class_2561)class_2561.method_43470((String)"X").method_27692(class_124.field_1061).method_27692(class_124.field_1067).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextUtil.translate("taterzens.tooltip.delete", finalJ))).method_10958(new class_2558(class_2558.class_2559.field_11745, "/npc edit commands group id " + finali + " removeCommand " + finalJ)))));
                    }
                    response.method_27693("\n-------------------------------------------------");
                }
            }
            source.method_9226(() -> response, false);
        });
    }

    private static int setPermissionLevel(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        int newPermLevel = IntegerArgumentType.getInteger(context, (String)"level");
        if (!Taterzens.config.perms.allowSettingHigherPermissionLevel && !source.method_9259(newPermLevel)) {
            source.method_9213((class_2561)TextUtil.errorText("taterzens.error.permission", String.valueOf(newPermLevel)));
            return -1;
        }
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            source.method_9226(() -> TextUtil.successText("taterzens.command.commands.permission.set", String.valueOf(newPermLevel)), false);
            taterzen.setPermissionLevel(newPermLevel);
        });
    }

    private static int addBungeeCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        boolean latest;
        class_2168 source = (class_2168)context.getSource();
        String command = StringArgumentType.getString(context, (String)"command");
        String player = StringArgumentType.getString(context, (String)"player");
        String argument = "";
        int group = 0;
        try {
            group = IntegerArgumentType.getInteger(context, (String)"group number") - 1;
            latest = false;
        }
        catch (IllegalArgumentException ignored) {
            latest = true;
        }
        try {
            argument = StringArgumentType.getString(context, (String)"argument");
        }
        catch (IllegalArgumentException ignored) {
            // empty catch block
        }
        String finalArgument = argument;
        int finalGroup = group;
        boolean finalLatest = latest;
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            boolean added = finalLatest ? taterzen.addCommand(new BungeeCommand(BungeeCommand.BungeeMessage.valueOf(command.toUpperCase()), player, finalArgument)) : taterzen.addCommand(new BungeeCommand(BungeeCommand.BungeeMessage.valueOf(command.toUpperCase()), player, finalArgument), finalGroup);
            class_5250 text = added ? TextUtil.joinText("taterzens.command.commands.setBungee", class_124.field_1065, class_124.field_1080, "/" + command + " " + player + " " + finalArgument) : TextUtil.errorText("taterzens.error.enableBungee", new String[0]);
            source.method_9226(() -> CommandsCommand.lambda$addBungeeCommand$39((class_2561)text), false);
        });
    }

    private static String addCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        boolean latest;
        class_2168 source = (class_2168)context.getSource();
        int group = 0;
        try {
            group = IntegerArgumentType.getInteger(context, (String)"group number") - 1;
            latest = false;
        }
        catch (IllegalArgumentException ignored) {
            latest = true;
        }
        AtomicReference command = new AtomicReference();
        int finalGroup = group;
        boolean finalLatest = latest;
        NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            String inputCmd = context.getInput();
            String index = "add minecraft ";
            command.set(inputCmd.substring(inputCmd.indexOf(index) + index.length()));
            if (finalLatest) {
                taterzen.addCommand(new MinecraftCommand((String)command.get()));
            } else {
                taterzen.addCommand(new MinecraftCommand((String)command.get()), finalGroup);
            }
        });
        return (String)command.get();
    }

    private static /* synthetic */ class_2561 lambda$addBungeeCommand$39(class_2561 text) {
        return text;
    }
}

