/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.taterzens.commands.edit.messages;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.samo_lego.taterzens.Taterzens;
import org.samo_lego.taterzens.commands.NpcCommand;
import org.samo_lego.taterzens.interfaces.ITaterzenEditor;
import org.samo_lego.taterzens.util.TextUtil;

public class MessagesCommand {
    public static LiteralCommandNode<class_2168> messagesNode;

    public static void registerNode(LiteralCommandNode<class_2168> editNode) {
        messagesNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"messages").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.messages.clear", Taterzens.config.perms.npcCommandPermissionLevel))).executes(MessagesCommand::clearTaterzenMessages))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.messages.list", Taterzens.config.perms.npcCommandPermissionLevel))).executes(MessagesCommand::listTaterzenMessages))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"swap").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id 1", (ArgumentType)IntegerArgumentType.integer()).requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.messages.swap", Taterzens.config.perms.npcCommandPermissionLevel))).then(class_2170.method_9244((String)"id 2", (ArgumentType)IntegerArgumentType.integer()).executes(MessagesCommand::swapMessages)))).requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.messages.reorder", Taterzens.config.perms.npcCommandPermissionLevel)))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"message id", (ArgumentType)IntegerArgumentType.integer()).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"delete").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.messages.delete", Taterzens.config.perms.npcCommandPermissionLevel))).executes(MessagesCommand::deleteTaterzenMessage))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setDelay").requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.messages.delay", Taterzens.config.perms.npcCommandPermissionLevel))).then(class_2170.method_9244((String)"delay", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(MessagesCommand::editMessageDelay)))).requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.messages", Taterzens.config.perms.npcCommandPermissionLevel))).executes(MessagesCommand::editMessage))).requires(src -> Taterzens.getInstance().getPlatform().checkPermission((class_2168)src, "taterzens.npc.edit.messages.edit", Taterzens.config.perms.npcCommandPermissionLevel))).executes(MessagesCommand::editTaterzenMessages)).build();
        editNode.addChild(messagesNode);
    }

    private static int swapMessages(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        return NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> {
            int firstId = IntegerArgumentType.getInteger((CommandContext)context, (String)"id 1");
            int secondId = IntegerArgumentType.getInteger((CommandContext)context, (String)"id 2");
            ArrayList<Pair<class_2561, Integer>> messages = taterzen.getMessages();
            int size = messages.size();
            if (firstId < 0) {
                firstId = Math.abs(size - firstId);
            }
            if (secondId < 0) {
                secondId = Math.abs(size - secondId);
            }
            if (firstId > size || secondId > size) {
                source.method_9213((class_2561)TextUtil.errorText("taterzens.command.message.error.404", firstId + " / " + secondId));
                return;
            }
            Pair<class_2561, Integer> first = messages.remove(--firstId);
            Pair<class_2561, Integer> second = messages.remove(--secondId - 1);
            messages.add(firstId, second);
            messages.add(secondId, first);
            source.method_9226(() -> TextUtil.translate("taterzens.command.message.swapped", ((class_2561)first.getFirst()).method_27661().method_27692(class_124.field_1054), ((class_2561)second.getFirst()).method_27661().method_27692(class_124.field_1054)).method_27692(class_124.field_1060), false);
        });
    }

    private static int deleteTaterzenMessage(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            ArrayList<Pair<class_2561, Integer>> messages;
            int size;
            int selected = IntegerArgumentType.getInteger((CommandContext)context, (String)"message id");
            int actual = MessagesCommand.getMessageIndex(selected, size = (messages = taterzen.getMessages()).size());
            if (actual == -1) {
                source.method_9213((class_2561)TextUtil.errorText("taterzens.command.message.error.404", String.valueOf(selected)));
            } else {
                source.method_9226(() -> TextUtil.successText("taterzens.command.message.deleted", taterzen.removeMessage(actual).getString()), false);
            }
        });
    }

    private static int editMessageDelay(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            ArrayList<Pair<class_2561, Integer>> messages;
            int size;
            int selected = IntegerArgumentType.getInteger((CommandContext)context, (String)"message id");
            int actual = MessagesCommand.getMessageIndex(selected, size = (messages = taterzen.getMessages()).size());
            if (actual == -1) {
                source.method_9213((class_2561)TextUtil.errorText("taterzens.command.message.error.404", String.valueOf(selected)));
            } else {
                int delay = IntegerArgumentType.getInteger((CommandContext)context, (String)"delay");
                int i = (actual - 1 + size) % size;
                String first = ((class_2561)((Pair)messages.get(i)).getFirst()).getString();
                String second = ((class_2561)((Pair)messages.get(actual)).getFirst()).getString();
                taterzen.setMessageDelay(actual, delay);
                source.method_9226(() -> TextUtil.successText("taterzens.command.message.delay", first, second, String.valueOf(delay)), false);
            }
        });
    }

    private static int getMessageIndex(int selected, int size) {
        selected = selected < 0 ? size + selected : --selected;
        if (selected >= size || selected < 0) {
            selected = -1;
        }
        return selected;
    }

    private static int editMessage(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        return NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> {
            ((ITaterzenEditor)player).setEditorMode(ITaterzenEditor.EditorMode.MESSAGES);
            int selected = IntegerArgumentType.getInteger((CommandContext)context, (String)"message id") - 1;
            if (selected >= taterzen.getMessages().size()) {
                source.method_9226(() -> TextUtil.successText("taterzens.command.message.list", String.valueOf(selected)), false);
            } else {
                ((ITaterzenEditor)player).setEditingMessageIndex(selected);
                source.method_9226(() -> TextUtil.successText("taterzens.command.message.editor.enter", ((class_2561)taterzen.getMessages().get(selected).getFirst()).getString()), false);
            }
        });
    }

    private static int listTaterzenMessages(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            ArrayList<Pair<class_2561, Integer>> messages = taterzen.getMessages();
            class_5250 response = TextUtil.joinText("taterzens.command.message.list", class_124.field_1075, class_124.field_1054, taterzen.method_5477().getString());
            AtomicInteger i = new AtomicInteger();
            messages.forEach((Consumer<Pair<class_2561, Integer>>)((Consumer<Pair>)pair -> {
                int index = i.get() + 1;
                response.method_10852((class_2561)class_2561.method_43470((String)("\n" + index + "-> ")).method_27692(index % 2 == 0 ? class_124.field_1054 : class_124.field_1065).method_10852((class_2561)pair.getFirst()).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/npc edit messages " + index)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextUtil.translate("taterzens.tooltip.edit", index))))).method_27693("   ").method_10852((class_2561)class_2561.method_43470((String)"X").method_27692(class_124.field_1061).method_27692(class_124.field_1067).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextUtil.translate("taterzens.tooltip.delete", index))).method_10958(new class_2558(class_2558.class_2559.field_11745, "/npc edit messages " + index + " delete"))));
                i.incrementAndGet();
            }));
            source.method_9226(() -> response, false);
        });
    }

    private static int clearTaterzenMessages(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        return NpcCommand.selectedTaterzenExecutor(source.method_9229(), taterzen -> {
            taterzen.clearMessages();
            source.method_9226(() -> TextUtil.successText("taterzens.command.message.clear", taterzen.method_5477().getString()), false);
        });
    }

    private static int editTaterzenMessages(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        return NpcCommand.selectedTaterzenExecutor((class_1297)player, taterzen -> {
            if (((ITaterzenEditor)player).getEditorMode() == ITaterzenEditor.EditorMode.MESSAGES) {
                ((ITaterzenEditor)player).setEditorMode(ITaterzenEditor.EditorMode.NONE);
                ((ITaterzenEditor)player).setEditingMessageIndex(-1);
                source.method_9226(() -> TextUtil.translate("taterzens.command.equipment.exit", new Object[0]).method_27692(class_124.field_1076), false);
            } else {
                ((ITaterzenEditor)player).setEditorMode(ITaterzenEditor.EditorMode.MESSAGES);
                source.method_9226(() -> TextUtil.joinText("taterzens.command.message.editor.enter", class_124.field_1076, class_124.field_1075, taterzen.method_5477().getString()).method_27692(class_124.field_1067).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/npc edit messages")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextUtil.translate("taterzens.tooltip.exit", new Object[0]).method_27692(class_124.field_1061)))), false);
                source.method_9226(() -> TextUtil.successText("taterzens.command.message.editor.desc.1", taterzen.method_5477().getString()).method_27693("\n").method_10852((class_2561)TextUtil.translate("taterzens.command.message.editor.desc.2", new Object[0])).method_27692(class_124.field_1060), false);
            }
        });
    }
}

