/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.taterzens.fabric.compatibility.carpet;

import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.samo_lego.taterzens.api.professions.AbstractProfession;
import org.samo_lego.taterzens.fabric.compatibility.carpet.TaterzenScarpetEvent;
import org.samo_lego.taterzens.npc.NPCData;
import org.samo_lego.taterzens.npc.TaterzenNPC;

public class ScarpetProfession
extends AbstractProfession {
    private static final TaterzenScarpetEvent PICKUP_EVENT = new TaterzenScarpetEvent("taterzen_tries_pickup", 3);
    private static final TaterzenScarpetEvent INTERACTION_EVENT = new TaterzenScarpetEvent("taterzen_interacted", 5);
    private static final TaterzenScarpetEvent BEING_ATTACKED_EVENT = new TaterzenScarpetEvent("taterzen_is_attacked", 3);
    private static final TaterzenScarpetEvent TICK_MOVEMENT_EVENT = new TaterzenScarpetEvent("taterzen_movement_ticks", 2);
    private static final TaterzenScarpetEvent REMOVED_EVENT = new TaterzenScarpetEvent("taterzen_removed", 2);
    private static final TaterzenScarpetEvent READ_NBT_EVENT = new TaterzenScarpetEvent("taterzen_nbt_loaded", 3);
    private static final TaterzenScarpetEvent SAVE_NBT_EVENT = new TaterzenScarpetEvent("taterzen_nbt_saved", 3);
    private static final TaterzenScarpetEvent MOVEMENT_SET_EVENT = new TaterzenScarpetEvent("taterzen_movement_set", 3);
    private static final TaterzenScarpetEvent BEHAVIOUR_SET_EVENT = new TaterzenScarpetEvent("taterzen_behaviour_set", 3);
    private static final TaterzenScarpetEvent TRY_RANGED_ATTACK_EVENT = new TaterzenScarpetEvent("taterzen_tries_ranged_attack", 3);
    private static final TaterzenScarpetEvent TRY_MELEE_ATTACK_EVENT = new TaterzenScarpetEvent("taterzen_tries_melee_attack", 3);
    private static final TaterzenScarpetEvent PLAYERS_NEARBY_EVENT = new TaterzenScarpetEvent("taterzen_approached_by", 3);
    private final HashSet<Value> SCARPET_TRAITS = new HashSet();
    public static final class_2960 ID = new class_2960("taterzens", "scarpet_profession");

    public ScarpetProfession(TaterzenNPC npc) {
        super(npc);
    }

    public void addTrait(String scarpetTrait) {
        this.SCARPET_TRAITS.add(StringValue.of((String)scarpetTrait));
    }

    public boolean removeTrait(String scarpetTrait) {
        return this.SCARPET_TRAITS.remove(StringValue.of((String)scarpetTrait));
    }

    public HashSet<Value> getTraits() {
        return this.SCARPET_TRAITS;
    }

    @Override
    public boolean tryPickupItem(class_1542 itemEntity) {
        PICKUP_EVENT.triggerCustomEvent(this.npc, this.getTraits(), itemEntity);
        return itemEntity.method_6983().method_7960() || itemEntity.method_31481();
    }

    @Override
    public class_1269 interactAt(class_1657 player, class_243 pos, class_1268 hand) {
        INTERACTION_EVENT.triggerCustomEvent(this.npc, this.getTraits(), player, ValueConversions.of((class_243)pos), hand);
        return super.interactAt(player, pos, hand);
    }

    @Override
    public boolean handleAttack(class_1297 attacker) {
        BEING_ATTACKED_EVENT.triggerCustomEvent(this.npc, this.getTraits(), attacker);
        return super.handleAttack(attacker);
    }

    @Override
    public void onPlayersNearby(List<class_3222> players) {
        PLAYERS_NEARBY_EVENT.triggerCustomEvent(this.npc, this.getTraits(), players);
    }

    @Override
    public class_1269 tickMovement() {
        TICK_MOVEMENT_EVENT.triggerCustomEvent(this.npc, this.getTraits(), new Object[0]);
        return super.tickMovement();
    }

    @Override
    public void onRemove() {
        REMOVED_EVENT.triggerCustomEvent(this.npc, this.getTraits(), new Object[0]);
    }

    @Override
    public void readNbt(class_2487 tag) {
        READ_NBT_EVENT.triggerCustomEvent(this.npc, this.getTraits(), tag);
        class_2499 scarpetTraits = (class_2499)tag.method_10580("ScarpetTraits");
        if (scarpetTraits != null) {
            scarpetTraits.forEach(profession -> this.addTrait(profession.method_10714()));
        }
    }

    @Override
    public void saveNbt(class_2487 tag) {
        SAVE_NBT_EVENT.triggerCustomEvent(this.npc, this.getTraits(), tag);
        if (!this.SCARPET_TRAITS.isEmpty()) {
            class_2499 scarpetTraits = new class_2499();
            this.SCARPET_TRAITS.forEach(prof -> scarpetTraits.add((Object)class_2519.method_23256((String)prof.getPrettyString())));
            tag.method_10566("ScarpetTraits", (class_2520)scarpetTraits);
        }
    }

    @Override
    public void onMovementSet(NPCData.Movement movement) {
        MOVEMENT_SET_EVENT.triggerCustomEvent(this.npc, this.getTraits(), new Object[]{movement});
    }

    @Override
    public void onBehaviourSet(NPCData.Behaviour behaviourLevel) {
        BEHAVIOUR_SET_EVENT.triggerCustomEvent(this.npc, this.getTraits(), new Object[]{behaviourLevel});
    }

    @Override
    public boolean cancelRangedAttack(class_1309 target) {
        TRY_RANGED_ATTACK_EVENT.triggerCustomEvent(this.npc, this.getTraits(), target);
        return super.cancelRangedAttack(target);
    }

    @Override
    public boolean cancelMeleeAttack(class_1297 target) {
        TRY_MELEE_ATTACK_EVENT.triggerCustomEvent(this.npc, this.getTraits(), target);
        return super.cancelMeleeAttack(target);
    }
}

